/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.mixin;

import com.google.common.collect.ImmutableMap;
import com.ultramega.playershells.entities.ShellEntity;
import com.ultramega.playershells.entities.renderer.ShellRenderer;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderDispatcher.class})
public class MixinEntityRenderDispatcher {
    @Unique
    private static final Map<PlayerSkin.Model, EntityRendererProvider<ShellEntity>> SHELL_PROVIDERS = Map.of(PlayerSkin.Model.WIDE, context -> new ShellRenderer(context, false), PlayerSkin.Model.SLIM, context -> new ShellRenderer(context, true));
    @Shadow
    @Final
    private ItemRenderer itemRenderer;
    @Shadow
    @Final
    private BlockRenderDispatcher blockRenderDispatcher;
    @Shadow
    @Final
    private ItemInHandRenderer itemInHandRenderer;
    @Shadow
    @Final
    private EntityModelSet entityModels;
    @Shadow
    @Final
    private Font font;
    @Unique
    private Map<PlayerSkin.Model, EntityRenderer<? extends ShellEntity>> playershells$shellRenderers = Map.of();

    @Inject(method={"getRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    private <T extends Entity> void playerShells$getRenderer(T entity, CallbackInfoReturnable<EntityRenderer<? super T>> cir) {
        if (entity instanceof ShellEntity) {
            ShellEntity shell = (ShellEntity)entity;
            PlayerSkin.Model skinModel = shell.getSkin().model();
            EntityRenderer<? extends ShellEntity> entityrenderer = this.playershells$shellRenderers.get(skinModel);
            cir.setReturnValue(entityrenderer != null ? entityrenderer : this.playershells$shellRenderers.get(PlayerSkin.Model.WIDE));
        }
    }

    @Inject(method={"onResourceManagerReload"}, at={@At(value="TAIL")})
    private void playershells$reload(ResourceManager resourceManager, CallbackInfo ci) {
        EntityRendererProvider.Context context = new EntityRendererProvider.Context((EntityRenderDispatcher)this, this.itemRenderer, this.blockRenderDispatcher, this.itemInHandRenderer, resourceManager, this.entityModels, this.font);
        this.playershells$shellRenderers = MixinEntityRenderDispatcher.playershells$createShellRenderers(context);
    }

    @Unique
    private static Map<PlayerSkin.Model, EntityRenderer<? extends ShellEntity>> playershells$createShellRenderers(EntityRendererProvider.Context context) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        SHELL_PROVIDERS.forEach((model, provider) -> {
            try {
                builder.put(model, (Object)provider.create(context));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to create shell model for " + String.valueOf(model), exception);
            }
        });
        return builder.build();
    }
}

