/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.storage;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.ultramega.playershells.blockentities.ShellForgeBlockEntity;
import com.ultramega.playershells.packet.s2c.SyncShellDataPacket;
import com.ultramega.playershells.storage.ShellState;
import com.ultramega.playershells.utils.MathUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.network.PacketDistributor;

public class ShellSavedData
extends SavedData {
    private final Multimap<UUID, ShellState> entries = ArrayListMultimap.create();

    public ShellSavedData() {
    }

    public ShellSavedData(CompoundTag tag, HolderLookup.Provider provider) {
        this.entries.putAll((Multimap)((Pair)ShellState.MULTIMAP_CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow()).getFirst());
    }

    public void add(UUID playerUuid, ShellState shellState) {
        this.entries.put((Object)playerUuid, (Object)shellState);
        this.setDirty();
    }

    public void updateShellCreationProgress(UUID playerUuid, UUID shellUuid, int newShellCreationProgress) {
        ShellState oldShellState = this.get(playerUuid, shellUuid);
        if (oldShellState != null) {
            ShellState newShellState = new ShellState(oldShellState.shellUUID(), oldShellState.shellForgePos(), oldShellState.playerData(), newShellCreationProgress);
            Collection states = this.entries.get((Object)playerUuid);
            states.remove(oldShellState);
            states.add(newShellState);
            this.setDirty();
        }
    }

    public Collection<ShellState> getAll(UUID playerUuid) {
        return this.entries.get((Object)playerUuid);
    }

    @Nullable
    public ShellState get(UUID playerUuid, UUID shellUuid) {
        for (ShellState state : this.entries.get((Object)playerUuid)) {
            if (state == null || !state.shellUUID().equals(shellUuid)) continue;
            return state;
        }
        return null;
    }

    @Nullable
    public ShellState getNearestActive(UUID playerUuid, ResourceLocation location, BlockPos playerPos) {
        ShellState nearest = null;
        double bestDistSq = Double.MAX_VALUE;
        ShellState fallback = null;
        for (ShellState shellState : this.getAll(playerUuid)) {
            if (shellState.shellCreationProgress() != 100) continue;
            if (shellState.shellForgePos().dimension().equals((Object)location)) {
                double distSqr = playerPos.distSqr((Vec3i)shellState.shellForgePos().pos());
                if (!(distSqr < bestDistSq)) continue;
                bestDistSq = distSqr;
                nearest = shellState;
                continue;
            }
            if (fallback != null) continue;
            fallback = shellState;
        }
        return nearest != null ? nearest : fallback;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        return (CompoundTag)ShellState.MULTIMAP_CODEC.encode(this.entries, (DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow();
    }

    public void setDirty() {
        super.setDirty();
        this.syncToClient();
    }

    public void validateShellData(Level level) {
        Iterator iterator = this.entries.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ShellState shellState = (ShellState)entry.getValue();
            if (shellState == null || level.getServer() == null) {
                iterator.remove();
                continue;
            }
            ServerLevel targetLevel = MathUtils.findTargetLevel(level.getServer(), shellState.shellForgePos());
            if (targetLevel == null) {
                iterator.remove();
                continue;
            }
            BlockEntity blockEntity = targetLevel.getBlockEntity(shellState.shellForgePos().pos());
            if (!(blockEntity instanceof ShellForgeBlockEntity)) {
                iterator.remove();
                continue;
            }
            ShellForgeBlockEntity shellForge = (ShellForgeBlockEntity)blockEntity;
            if (shellForge.getShellUuid().equals(shellState.shellUUID())) continue;
            iterator.remove();
        }
        this.setDirty();
    }

    public void syncToClient() {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncShellDataPacket((Multimap<UUID, ShellState>)ImmutableListMultimap.copyOf(this.entries)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static ShellSavedData getShellData(ServerLevel level) {
        ServerLevel serverLevel = Objects.requireNonNull(level.getServer().getLevel(Level.OVERWORLD));
        return (ShellSavedData)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(ShellSavedData::new, ShellSavedData::new), "player_shells");
    }
}

