/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.storage;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ultramega.playershells.utils.MathUtils;
import com.ultramega.playershells.utils.PositionReference;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ShellState(UUID shellUUID, PositionReference shellForgePos, CompoundTag playerData, int shellCreationProgress) {
    public static final StreamCodec<ByteBuf, ShellState> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, ShellState::shellUUID, PositionReference.STREAM_CODEC, ShellState::shellForgePos, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, ShellState::playerData, (StreamCodec)ByteBufCodecs.INT, ShellState::shellCreationProgress, ShellState::new);
    public static final Codec<ShellState> CODEC = RecordCodecBuilder.create(in -> in.group((App)UUIDUtil.CODEC.fieldOf("shellUUID").forGetter(ShellState::shellUUID), (App)PositionReference.CODEC.fieldOf("oldShellForgePos").forGetter(ShellState::shellForgePos), (App)CompoundTag.CODEC.fieldOf("playerData").forGetter(ShellState::playerData), (App)Codec.INT.fieldOf("shellCreationProgress").forGetter(ShellState::shellCreationProgress)).apply((Applicative)in, ShellState::new));
    public static final Codec<Multimap<UUID, ShellState>> MULTIMAP_CODEC = MathUtils.multiMapCodec(Codec.STRING.xmap(UUID::fromString, UUID::toString), CODEC);
}

