/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.blocks;

import com.ultramega.playershells.blockentities.ShellForgeBlockEntity;
import com.ultramega.playershells.blocks.AbstractMultiblockBlock;
import com.ultramega.playershells.gui.ShellSelectionOverlay;
import com.ultramega.playershells.packet.c2s.LeaveShellForgePacket;
import com.ultramega.playershells.packet.c2s.TransferPlayerPacket;
import com.ultramega.playershells.packet.c2s.ValidateShellForgePacket;
import com.ultramega.playershells.registry.ModBlockEntityTypes;
import com.ultramega.playershells.registry.ModBlocks;
import com.ultramega.playershells.storage.ShellSavedData;
import com.ultramega.playershells.utils.CameraHandler;
import com.ultramega.playershells.utils.MathUtils;
import com.ultramega.playershells.utils.PositionReference;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class ShellForgeBlock
extends AbstractMultiblockBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    private static final VoxelShape ROOF = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape FLOOR = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape NORTH_WALL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_WALL = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_WALL = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_WALL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final int HALF_BOTTOM = 0;
    private static final int HALF_TOP = 1;
    private static final int STATE_CLOSED = 0;
    private static final int STATE_OPEN = 1;
    private static final VoxelShape[][][] SHAPES = new VoxelShape[2][2][4];
    private boolean blockShellSelection;

    public ShellForgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean handled = this.handleUseCommon(level, state, pos, player);
        return handled ? ItemInteractionResult.sidedSuccess((boolean)level.isClientSide()) : ItemInteractionResult.FAIL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean handled = this.handleUseCommon(level, state, pos, player);
        return handled ? InteractionResult.sidedSuccess((boolean)level.isClientSide()) : InteractionResult.FAIL;
    }

    private boolean handleUseCommon(Level level, BlockState state, BlockPos pos, Player player) {
        boolean hasShellInside;
        BlockPos shellForgePos = ShellForgeBlock.isBottomHalf(state) ? pos : pos.below();
        BlockState shellForgeState = level.getBlockState(shellForgePos);
        BlockEntity blockEntity = level.getBlockEntity(shellForgePos);
        if (!(blockEntity instanceof ShellForgeBlockEntity)) {
            return false;
        }
        ShellForgeBlockEntity shellForge = (ShellForgeBlockEntity)blockEntity;
        boolean bl = hasShellInside = shellForge.getShellState() != ShellForgeBlockEntity.ShellStates.CREATE;
        if (!level.isClientSide()) {
            if (hasShellInside || player.isShiftKeyDown()) {
                player.openMenu((MenuProvider)shellForge, shellForgePos);
                return true;
            }
            shellForge.setPlayerState(ShellForgeBlockEntity.PlayerStates.GOING_IN);
            shellForge.setChanged();
            return true;
        }
        if (!hasShellInside && !player.isShiftKeyDown()) {
            this.openShellSelection(player, level, shellForgePos, shellForgeState);
            Minecraft mc = Minecraft.getInstance();
            if (mc.options.keyUse.isDown()) {
                mc.options.keyUse.setDown(false);
            }
        }
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int halfIdx = ShellForgeBlock.isBottomHalf(state) ? 0 : 1;
        int stateIdx = ShellForgeBlock.isOpen(state) ? 1 : 0;
        return SHAPES[halfIdx][stateIdx][ShellForgeBlock.dirToIndex(((Direction)state.getValue((Property)FACING)).getOpposite())];
    }

    private static int dirToIndex(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 0;
            case Direction.SOUTH -> 1;
            case Direction.WEST -> 2;
            case Direction.EAST -> 3;
            default -> throw new IllegalArgumentException("Direction must be horizontal: " + String.valueOf(direction));
        };
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        Player player;
        block9: {
            block8: {
                if (!(entity instanceof Player)) break block8;
                player = (Player)entity;
                if (ShellForgeBlock.isBottomHalf(state) && (blockEntity = level.getBlockEntity(pos)) instanceof ShellForgeBlockEntity) break block9;
            }
            return;
        }
        ShellForgeBlockEntity shellForge = (ShellForgeBlockEntity)blockEntity;
        if (level.isClientSide()) {
            if (shellForge.getPlayerState() == ShellForgeBlockEntity.PlayerStates.NONE) {
                this.blockShellSelection = false;
            }
            if (!ShellSelectionOverlay.INSTANCE.isOpened() && shellForge.getPlayerState() == ShellForgeBlockEntity.PlayerStates.INSIDE && !this.blockShellSelection) {
                this.openShellSelection(player, level, pos, state);
            } else if (ShellSelectionOverlay.INSTANCE.isOpened() && (shellForge.getPlayerState() == ShellForgeBlockEntity.PlayerStates.TRANSFERRED || shellForge.getPlayerState() == ShellForgeBlockEntity.PlayerStates.GOING_OUT)) {
                ShellSelectionOverlay.INSTANCE.close(true);
            }
        }
    }

    private void openShellSelection(Player player, Level level, BlockPos pos, BlockState state) {
        BlockPos thisShellForgePos = (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos).immutable();
        Direction thisFacing = (Direction)level.getBlockState(thisShellForgePos).getValue((Property)FACING);
        PositionReference thisShellForgePosReference = new PositionReference(thisShellForgePos, thisFacing, level.dimension().location());
        ShellSelectionOverlay.INSTANCE.open(player, shellEntry -> {
            if (shellEntry.shellForgePos().isEmpty()) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ValidateShellForgePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            BlockPos newShellForgePos = shellEntry.shellForgePos().get().pos().immutable();
            Direction newShellForgeFacing = shellEntry.shellForgePos().get().facing();
            CameraHandler.setMovingAnimation(thisShellForgePos.above(), thisFacing, newShellForgePos.above(), newShellForgeFacing, () -> PacketDistributor.sendToServer((CustomPacketPayload)new TransferPlayerPacket(thisShellForgePosReference, shellEntry.shellForgePos().get()), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }, () -> {
            this.blockShellSelection = true;
            PacketDistributor.sendToServer((CustomPacketPayload)new LeaveShellForgePacket(thisShellForgePos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    public static void movePlayerInside(Player player, BlockPos target, Direction facing) {
        float yaw = facing.toYRot();
        ShellForgeBlock.movePlayerTo(player, target, 0.0625);
        player.setXRot(0.0f);
        player.setYRot(yaw);
        player.setYHeadRot(yaw);
        player.setYBodyRot(yaw);
        player.yRotO = yaw;
        player.yBodyRotO = yaw;
        player.yHeadRotO = yaw;
    }

    public static void movePlayerTo(Player player, BlockPos target, double offsetY) {
        Vec3 currentPos = player.position();
        double targetX = (double)target.getX() + 0.5;
        double targetY = (double)target.getY() + offsetY;
        double targetZ = (double)target.getZ() + 0.5;
        double currentX = currentPos.x;
        double currentY = currentPos.y;
        double currentZ = currentPos.z;
        double velocityX = MathUtils.getMinVelocity(targetX - currentX, 0.33);
        double velocityY = MathUtils.getMinVelocity(targetY - currentY, 0.33);
        double velocityZ = MathUtils.getMinVelocity(targetZ - currentZ, 0.33);
        player.setDeltaMovement(velocityX, velocityY, velocityZ);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ShellSavedData.getShellData(serverLevel).validateShellData((Level)serverLevel);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPEN});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        if (!ShellForgeBlock.isBottomHalf(state)) {
            return null;
        }
        return new ShellForgeBlockEntity(blockPos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!ShellForgeBlock.isBottomHalf(state)) {
            return null;
        }
        return !level.isClientSide() ? MathUtils.createTickerHelper(blockEntityType, ModBlockEntityTypes.SHELL_FORGE.get(), ShellForgeBlockEntity::serverTick) : MathUtils.createTickerHelper(blockEntityType, ModBlockEntityTypes.SHELL_FORGE.get(), ShellForgeBlockEntity::clientTick);
    }

    public static void setValue(BlockState state, Level level, BlockPos pos, BoolProperty ... properties) {
        BlockState newState = state;
        for (BoolProperty property : properties) {
            newState = (BlockState)newState.setValue((Property)property.property(), (Comparable)Boolean.valueOf(property.value()));
        }
        level.setBlock(pos, newState, 3);
        BlockPos otherHalfPos = pos.relative(ShellForgeBlock.isBottomHalf(newState) ? Direction.UP : Direction.DOWN);
        BlockState otherHalfState = level.getBlockState(otherHalfPos);
        if (otherHalfState.is((Block)ModBlocks.SHELL_FORGE.get())) {
            BlockState newOther = otherHalfState;
            for (BoolProperty property : properties) {
                newOther = (BlockState)newOther.setValue((Property)property.property(), (Comparable)Boolean.valueOf(property.value()));
            }
            level.setBlock(otherHalfPos, newOther, 3);
        }
    }

    public static boolean isOpen(BlockState state) {
        return (Boolean)state.getValue((Property)OPEN);
    }

    static {
        VoxelShape allWalls = Shapes.or((VoxelShape)NORTH_WALL, (VoxelShape[])new VoxelShape[]{SOUTH_WALL, EAST_WALL, WEST_WALL}).optimize();
        VoxelShape closedBottom = Shapes.or((VoxelShape)allWalls, (VoxelShape)FLOOR).optimize();
        VoxelShape closedTop = Shapes.or((VoxelShape)allWalls, (VoxelShape)ROOF).optimize();
        VoxelShape openToNorth = Shapes.or((VoxelShape)NORTH_WALL, (VoxelShape[])new VoxelShape[]{EAST_WALL, WEST_WALL}).optimize();
        VoxelShape openToSouth = Shapes.or((VoxelShape)SOUTH_WALL, (VoxelShape[])new VoxelShape[]{EAST_WALL, WEST_WALL}).optimize();
        VoxelShape openToEast = Shapes.or((VoxelShape)NORTH_WALL, (VoxelShape[])new VoxelShape[]{SOUTH_WALL, EAST_WALL}).optimize();
        VoxelShape openToWest = Shapes.or((VoxelShape)NORTH_WALL, (VoxelShape[])new VoxelShape[]{SOUTH_WALL, WEST_WALL}).optimize();
        VoxelShape openToNorthBottom = Shapes.or((VoxelShape)openToNorth, (VoxelShape)FLOOR).optimize();
        VoxelShape openToSouthBottom = Shapes.or((VoxelShape)openToSouth, (VoxelShape)FLOOR).optimize();
        VoxelShape openToEastBottom = Shapes.or((VoxelShape)openToEast, (VoxelShape)FLOOR).optimize();
        VoxelShape openToWestBottom = Shapes.or((VoxelShape)openToWest, (VoxelShape)FLOOR).optimize();
        VoxelShape openToNorthTop = Shapes.or((VoxelShape)openToNorth, (VoxelShape)ROOF).optimize();
        VoxelShape openToSouthTop = Shapes.or((VoxelShape)openToSouth, (VoxelShape)ROOF).optimize();
        VoxelShape openToEastTop = Shapes.or((VoxelShape)openToEast, (VoxelShape)ROOF).optimize();
        VoxelShape openToWestTop = Shapes.or((VoxelShape)openToWest, (VoxelShape)ROOF).optimize();
        for (int i = 0; i < 4; ++i) {
            ShellForgeBlock.SHAPES[0][0][i] = closedBottom;
            ShellForgeBlock.SHAPES[1][0][i] = closedTop;
        }
        ShellForgeBlock.SHAPES[0][1][ShellForgeBlock.dirToIndex((Direction)Direction.NORTH)] = openToNorthBottom;
        ShellForgeBlock.SHAPES[0][1][ShellForgeBlock.dirToIndex((Direction)Direction.SOUTH)] = openToSouthBottom;
        ShellForgeBlock.SHAPES[0][1][ShellForgeBlock.dirToIndex((Direction)Direction.EAST)] = openToEastBottom;
        ShellForgeBlock.SHAPES[0][1][ShellForgeBlock.dirToIndex((Direction)Direction.WEST)] = openToWestBottom;
        ShellForgeBlock.SHAPES[1][1][ShellForgeBlock.dirToIndex((Direction)Direction.NORTH)] = openToNorthTop;
        ShellForgeBlock.SHAPES[1][1][ShellForgeBlock.dirToIndex((Direction)Direction.SOUTH)] = openToSouthTop;
        ShellForgeBlock.SHAPES[1][1][ShellForgeBlock.dirToIndex((Direction)Direction.EAST)] = openToEastTop;
        ShellForgeBlock.SHAPES[1][1][ShellForgeBlock.dirToIndex((Direction)Direction.WEST)] = openToWestTop;
    }

    public record BoolProperty(BooleanProperty property, boolean value) {
    }
}

