/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import com.ultramega.playershells.blockentities.renderer.ShellForgeBlockEntityRenderer;
import com.ultramega.playershells.entities.ShellEntity;
import com.ultramega.playershells.registry.ModRenderTypes;
import com.ultramega.playershells.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ArrayUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public abstract class RadialMenuRenderer<T> {
    public static final float INNER = 40.0f;
    public static final float OUTER = 100.0f;
    public static final float MIDDLE_DISTANCE = 70.0f;
    private static final float DRAWS = 300.0f;
    protected int lastIndexUnderMouse = -1;
    private int[] hoverGrows = new int[0];
    private long lastUpdate = System.currentTimeMillis();

    public abstract List<T> getEntries();

    public abstract Component getTitle(T var1);

    @Nullable
    public abstract ShellEntity getPlayerShell(T var1);

    public abstract int getPlayerShellCreationProgress(T var1);

    public void render(GuiGraphics graphics) {
        long current;
        List<T> entries = this.getEntries();
        if (entries.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = graphics.pose();
        mc.mouseHandler.releaseMouse();
        if (this.hoverGrows.length < entries.size()) {
            this.hoverGrows = ArrayUtils.addAll((int[])this.hoverGrows, (int[])IntStream.range(0, entries.size() - this.hoverGrows.length).map(i -> 0).toArray());
        }
        int count = entries.size();
        float angleSize = 360.0f / (float)count;
        int indexUnderMouse = this.getElementUnderMouse();
        if (!mc.isPaused() && !(mc.screen instanceof ChatScreen)) {
            this.lastIndexUnderMouse = indexUnderMouse;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float centerX = (float)graphics.guiWidth() / 2.0f;
        float centerY = (float)graphics.guiHeight() / 2.0f;
        poseStack.pushPose();
        poseStack.translate(centerX, centerY, 0.0f);
        for (int i2 = 0; i2 < entries.size(); ++i2) {
            boolean highlight = this.lastIndexUnderMouse == i2;
            float startAngle = -90.0f + 360.0f * (-0.5f + (float)i2) / (float)count;
            RadialMenuRenderer.drawTorus(graphics, startAngle, angleSize, 40.0f, 100.0f + 10.0f * ((float)this.hoverGrows[i2] / 10.0f), 0.3f, 0.3f, 0.3f, highlight ? 0.85f : 0.6f);
        }
        if (!mc.mouseHandler.isMouseGrabbed() && (current = System.currentTimeMillis()) >= this.lastUpdate + 25L) {
            this.lastUpdate = current;
            for (int i3 = 0; i3 < entries.size(); ++i3) {
                if (i3 == this.lastIndexUnderMouse) {
                    if (this.hoverGrows[i3] >= 10) continue;
                    int n = i3;
                    this.hoverGrows[n] = this.hoverGrows[n] + 1;
                    continue;
                }
                if (this.hoverGrows[i3] <= 0) continue;
                int n = i3;
                this.hoverGrows[n] = this.hoverGrows[n] - 1;
            }
        }
        record PositionedText(float x, float y, Component text) {
        }
        ArrayList<PositionedText> textToDraw = new ArrayList<PositionedText>(entries.size());
        float position = 0.0f;
        for (T key : entries) {
            float f = position;
            position = f + 1.0f;
            float degrees = 270.0f + 360.0f * (f / (float)count);
            float angle = (float)Math.PI / 180 * degrees;
            float x = Mth.cos((float)angle) * 70.0f;
            float y = Mth.sin((float)angle) * 70.0f;
            ShellEntity shellPlayer = this.getPlayerShell(key);
            if (shellPlayer == null) continue;
            shellPlayer.yBodyRotO = 0.0f;
            shellPlayer.yBodyRot = 0.0f;
            shellPlayer.setYRot(0.0f);
            shellPlayer.yHeadRotO = 0.0f;
            shellPlayer.yHeadRot = 0.0f;
            shellPlayer.setXRot(0.0f);
            EntityRenderDispatcher dispatcher = mc.getEntityRenderDispatcher();
            MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
            int shellCreationProgress = this.getPlayerShellCreationProgress(key);
            ResourceLocation skinTexture = dispatcher.getRenderer((Entity)shellPlayer).getTextureLocation((Entity)shellPlayer);
            RenderType renderType = (RenderType)ModRenderTypes.CREATE_SHADER_TYPE.apply((Object)skinTexture, (Object)shellPlayer, (Object)shellCreationProgress, (Object)20, (Object)MathUtils.packRGB8(54, 188, 184));
            ShellForgeBlockEntityRenderer.ShaderForcingBuffer remappedBuffer = new ShellForgeBlockEntityRenderer.ShaderForcingBuffer((MultiBufferSource)bufferSource, renderType, shellCreationProgress != 100);
            float scale = 20.0f;
            if (shellCreationProgress != 100) {
                textToDraw.add(new PositionedText(x, y - 12.0f, (Component)Component.literal((String)(shellCreationProgress + "%"))));
            }
            textToDraw.add(new PositionedText(x, y + 12.0f, this.getTitle(key)));
            poseStack.pushPose();
            poseStack.translate(x, y + 12.0f, 100.0f);
            poseStack.scale(20.0f, 20.0f, 20.0f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(30.0f));
            float yPos = new Transformation((Matrix4f)poseStack.last().pose()).getTranslation().y;
            shellPlayer.setPos(0.0, -yPos + 2.0f, 0.0);
            dispatcher.overrideCameraOrientation(new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f));
            dispatcher.setRenderShadow(false);
            RenderSystem.enableDepthTest();
            RenderSystem.runAsFancy(() -> dispatcher.render((Entity)shellPlayer, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, remappedBuffer, 0xF000F0));
            bufferSource.endBatch();
            dispatcher.setRenderShadow(true);
            poseStack.popPose();
        }
        Font font = mc.font;
        if (!textToDraw.isEmpty()) {
            for (PositionedText toDraw : textToDraw) {
                poseStack.pushPose();
                poseStack.translate(toDraw.x, toDraw.y, 120.0f);
                poseStack.scale(0.6f, 0.6f, 0.6f);
                Component text = toDraw.text;
                graphics.drawString(font, text.getVisualOrderText(), (float)(-font.width((FormattedText)text)) / 2.0f, 8.0f, -855638017, true);
                poseStack.popPose();
            }
        }
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    public static MousePos getMousePos() {
        Minecraft mc = Minecraft.getInstance();
        MouseHandler mouse = mc.mouseHandler;
        double mouseX = mouse.xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth();
        double mouseY = mouse.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight();
        return new MousePos(mouseX, mouseY);
    }

    public static MousePos getDiffFromCenter(double mouseX, double mouseY) {
        Window window = Minecraft.getInstance().getWindow();
        float centerX = (float)window.getGuiScaledWidth() / 2.0f;
        float centerY = (float)window.getGuiScaledHeight() / 2.0f;
        double xDiff = mouseX - (double)centerX;
        double yDiff = mouseY - (double)centerY;
        return new MousePos(xDiff, yDiff);
    }

    public int getElementUnderMouse() {
        MousePos mouse = RadialMenuRenderer.getMousePos();
        double mouseX = mouse.x;
        double mouseY = mouse.y;
        int count = this.getEntries().size();
        MousePos diffFromCenter = RadialMenuRenderer.getDiffFromCenter(mouseX, mouseY);
        double distanceFromCenter = Mth.length((double)diffFromCenter.x(), (double)diffFromCenter.y());
        if (distanceFromCenter > 30.0) {
            float angle = (float)(57.2957763671875 * Mth.atan2((double)diffFromCenter.y(), (double)diffFromCenter.x()));
            float modeSize = 180.0f / (float)count;
            float selectionAngle = MathUtils.wrapDegrees(angle + modeSize + 90.0f);
            return (int)(selectionAngle * ((float)count / 360.0f));
        }
        return -1;
    }

    public void clearState() {
        this.hoverGrows = new int[0];
    }

    private static void drawTorus(GuiGraphics graphics, float startAngle, float sizeAngle, float inner, float outer, float red, float green, float blue, float alpha) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder vertexBuffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix4f = graphics.pose().last().pose();
        float draws = 300.0f * (sizeAngle / 360.0f);
        int i = 0;
        while ((float)i <= draws) {
            float degrees = startAngle + (float)i / 300.0f * 360.0f;
            float angle = (float)Math.PI / 180 * degrees;
            float cos = Mth.cos((float)angle);
            float sin = Mth.sin((float)angle);
            vertexBuffer.addVertex(matrix4f, outer * cos, outer * sin, 0.0f).setColor(red, green, blue, alpha);
            vertexBuffer.addVertex(matrix4f, inner * cos, inner * sin, 0.0f).setColor(red, green, blue, alpha);
            ++i;
        }
        BufferUploader.drawWithShader((MeshData)vertexBuffer.buildOrThrow());
    }

    public record MousePos(double x, double y) {
    }
}

