/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ultramega.playershells.blockentities.ShellForgeBlockEntity;
import com.ultramega.playershells.container.ShellForgeContainerMenu;
import com.ultramega.playershells.gui.widgets.ProgressBarWidget;
import com.ultramega.playershells.gui.widgets.ShellButton;
import com.ultramega.playershells.packet.c2s.ShellButtonPressedPacket;
import com.ultramega.playershells.registry.ModSoundEvents;
import com.ultramega.playershells.utils.SoundHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ShellForgeScreen
extends AbstractContainerScreen<ShellForgeContainerMenu> {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"textures/gui/shell_forge.png");
    private static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot");
    private static final int ENERGY_BAR_HEIGHT = 52;
    private static final float STATUS_TEXT_SCALE = 0.5f;
    @Nullable
    private ShellButton shellButton;
    @Nullable
    private ProgressBarWidget progressBar;
    @Nullable
    private Component randomStatusSubText = this.getRandomStatusSubText();
    @Nullable
    private ShellForgeBlockEntity.ShellStates lastShellState;

    public ShellForgeScreen(ShellForgeContainerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.shellButton = new ShellButton(this.leftPos + (this.imageWidth - 80) / 2, this.topPos + 55, 80, 16, button -> {
            if (((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getShellState() == ShellForgeBlockEntity.ShellStates.EXTERMINATE && ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getLevel() != null) {
                SoundHandler.startBlockSound((SoundEvent)ModSoundEvents.FLAMETHROWER.get(), SoundSource.BLOCKS, 1.5f, 1.0f, ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getLevel().random, ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getBlockPos());
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ShellButtonPressedPacket(((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }, ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity());
        this.addRenderableWidget((GuiEventListener)this.shellButton);
        this.progressBar = new ProgressBarWidget(this.leftPos + (this.imageWidth - 80) / 2, this.topPos + 25, 80, 16, ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity(), () -> ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getShellPercentage());
        this.addRenderableWidget((GuiEventListener)this.progressBar);
        this.containerTick();
    }

    protected void containerTick() {
        if (this.shellButton != null) {
            this.shellButton.tick();
        }
        if (this.progressBar != null) {
            this.progressBar.tick();
        }
        if (this.lastShellState != ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getShellState()) {
            this.randomStatusSubText = this.getRandomStatusSubText();
        }
        this.lastShellState = ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getShellState();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.getXSize(), this.getYSize());
        if (((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getShellState() == ShellForgeBlockEntity.ShellStates.CREATE) {
            graphics.blitSprite(SLOT_SPRITE, this.leftPos + 79, this.topPos + 16, 0, 18, 18);
        }
        PoseStack poseStack = graphics.pose();
        if (((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getShellState() != ShellForgeBlockEntity.ShellStates.CREATE && this.randomStatusSubText != null) {
            MutableComponent status = Component.translatable((String)"gui.playershells.shell_forge.status", (Object[])new Object[]{this.randomStatusSubText});
            int x = (int)((float)this.leftPos + ((float)this.imageWidth - (float)this.font.width(status.getString()) * 0.5f) / 2.0f);
            int y = this.topPos + 47;
            poseStack.pushPose();
            poseStack.translate((float)x, (float)y, 0.0f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            graphics.drawString(this.font, status.getString(), 0, 0, -1);
            poseStack.popPose();
        }
        graphics.blit(BACKGROUND, this.leftPos + 8, this.topPos + 18, 176, 0, 6, 52);
        int energyAmount = ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().energyStorage.getEnergyStored();
        int energyMaxStored = ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().energyStorage.getMaxEnergyStored();
        int energyLevel = (int)((float)energyAmount * (52.0f / (float)energyMaxStored));
        graphics.blit(BACKGROUND, this.leftPos + 8, this.topPos + 18, 8, 18, 6, 52 - energyLevel);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderTooltip(graphics, mouseX, mouseY);
        if (this.isHovering(7, 18, 8, 53, mouseX, mouseY)) {
            graphics.renderTooltip(this.font, List.of(Component.translatable((String)"gui.playershells.energy", (Object[])new Object[]{((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().energyStorage.getEnergyStored()}).getVisualOrderText()), mouseX, mouseY);
        }
    }

    @Nullable
    private Component getRandomStatusSubText() {
        Level level = ((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getLevel();
        if (level == null) {
            return null;
        }
        RandomSource random = level.random;
        boolean useMainText = random.nextDouble() < 0.7;
        return switch (((ShellForgeContainerMenu)this.getMenu()).getBlockEntity().getShellState()) {
            default -> throw new MatchException(null, null);
            case ShellForgeBlockEntity.ShellStates.CREATE -> null;
            case ShellForgeBlockEntity.ShellStates.CREATING -> {
                if (useMainText) {
                    yield Component.translatable((String)"gui.playershells.shell_forge.status.creating");
                }
                yield Component.translatable((String)("gui.playershells.shell_forge.status.creating_" + random.nextInt(0, 5)));
            }
            case ShellForgeBlockEntity.ShellStates.EXTERMINATE -> {
                if (useMainText) {
                    yield Component.translatable((String)"gui.playershells.shell_forge.status.alive");
                }
                yield Component.translatable((String)("gui.playershells.shell_forge.status.alive_" + random.nextInt(0, 7)));
            }
            case ShellForgeBlockEntity.ShellStates.EXTERMINATING -> {
                if (useMainText) {
                    yield Component.translatable((String)"gui.playershells.shell_forge.status.exterminating");
                }
                yield Component.translatable((String)("gui.playershells.shell_forge.status.exterminating_" + random.nextInt(0, 2)));
            }
            case ShellForgeBlockEntity.ShellStates.DECAYING -> useMainText ? Component.translatable((String)"gui.playershells.shell_forge.status.decaying") : Component.translatable((String)("gui.playershells.shell_forge.status.decaying_" + random.nextInt(0, 3)));
        };
    }
}

