/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.items.extensions;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class SyringeItemExtension
implements IClientItemExtensions {
    public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack stackInHand, float partialTicks, float equippedProgress, float swingProgress) {
        if (player.getOffhandItem().is(stackInHand.getItem())) {
            return false;
        }
        int useDuration = stackInHand.getUseDuration((LivingEntity)player);
        int remainingUseTicks = player.getUseItemRemainingTicks();
        int useTicks = useDuration - remainingUseTicks;
        Minecraft mc = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        int packedLight = mc.getEntityRenderDispatcher().getPackedLightCoords((Entity)player, partialTicks);
        float equipProgress = equippedProgress;
        if (player.isUsingItem()) {
            equipProgress = 0.0f;
            if (remainingUseTicks > 0) {
                this.renderLeftPlayerArm(mc, player, poseStack, (MultiBufferSource)bufferSource, packedLight, partialTicks, useTicks);
            }
        }
        this.renderRightPlayerArm(mc, player, poseStack, (MultiBufferSource)bufferSource, packedLight, partialTicks, equipProgress, useTicks, useDuration);
        return true;
    }

    private void renderLeftPlayerArm(Minecraft mc, LocalPlayer localPlayer, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks, int useTicks) {
        float t = Mth.clamp((float)(((float)useTicks + partialTicks) / 6.0f), (float)0.0f, (float)1.0f);
        float moveFactor = Mth.lerp((float)t, (float)-1.6f, (float)0.0f);
        poseStack.pushPose();
        poseStack.translate(moveFactor, 0.0f, 0.0f);
        poseStack.translate(0.14f, 0.0f, -0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(50.0f));
        poseStack.translate(-1.0f, 3.6f, 3.5f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(120.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(200.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(-130.0f));
        poseStack.translate(5.8f, 0.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(80.0f));
        poseStack.translate(0.1f, -0.1f, 0.5f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(20.0f));
        PlayerRenderer playerRenderer = (PlayerRenderer)mc.getEntityRenderDispatcher().getRenderer((Entity)localPlayer);
        playerRenderer.renderLeftHand(poseStack, buffer, packedLight, (AbstractClientPlayer)localPlayer);
        poseStack.popPose();
    }

    private void renderRightPlayerArm(Minecraft mc, LocalPlayer localPlayer, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTicks, float equippedProgress, int useTicks, int useDuration) {
        float t = Mth.clamp((float)(((float)useTicks + partialTicks) / 6.0f), (float)0.0f, (float)1.0f);
        float moveFactor = useTicks != useDuration ? Mth.lerp((float)t, (float)0.0f, (float)-1.0f) : 0.0f;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.04f + equippedProgress * -1.2f, 0.0f);
        poseStack.translate(0.64f, -0.6f, -0.72f);
        poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        poseStack.translate(-1.0f, 3.6f, 3.5f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(120.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(200.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(-135.0f));
        poseStack.translate(5.6f, 0.0f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(75.0f * moveFactor));
        poseStack.translate(0.0f, -0.2f * moveFactor + 0.2f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(10.0f));
        PlayerRenderer playerRenderer = (PlayerRenderer)mc.getEntityRenderDispatcher().getRenderer((Entity)localPlayer);
        playerRenderer.renderRightHand(poseStack, buffer, packedLight, (AbstractClientPlayer)localPlayer);
        poseStack.popPose();
        poseStack.translate(0.57f, -0.32f + equippedProgress * -0.6f, -1.22f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-162.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(10.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(10.0f));
        poseStack.translate(moveFactor, 0.25f * moveFactor, 0.2f * moveFactor);
        poseStack.mulPose(Axis.YP.rotationDegrees(110.0f * moveFactor));
        poseStack.mulPose(Axis.XP.rotationDegrees(20.0f));
    }
}

