/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.ultramega.playershells.utils.PositionReference;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;

public final class MathUtils {
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);

    public static float yawForDirection(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> 270.0f;
            default -> 0.0f;
        };
    }

    public static double getMinVelocity(double velocity, double absLimit) {
        return Math.abs(velocity) < absLimit ? velocity : absLimit * Math.signum(velocity);
    }

    public static boolean near(float a, float b) {
        return Math.abs(a - b) < 1.0E-4f;
    }

    public static float smoothstep01(float x) {
        float smooth = MathUtils.clamp01(x);
        return smooth * smooth * (3.0f - 2.0f * smooth);
    }

    public static float clamp01(float x) {
        return x < 0.0f ? 0.0f : Math.min(x, 1.0f);
    }

    public static int[] interpolateGradient(float t, int[] colorA, int[] colorB, int[] colorC) {
        if (t < 0.5f) {
            return MathUtils.lerpColor(t / 0.5f, colorA, colorB);
        }
        return MathUtils.lerpColor((t - 0.5f) / 0.5f, colorB, colorC);
    }

    private static int[] lerpColor(float t, int[] from, int[] to) {
        return new int[]{(int)((float)from[0] + (float)(to[0] - from[0]) * t), (int)((float)from[1] + (float)(to[1] - from[1]) * t), (int)((float)from[2] + (float)(to[2] - from[2]) * t)};
    }

    public static Vec3 lerpVec3(Vec3 a, Vec3 b, float t) {
        float clampedT = Mth.clamp((float)t, (float)0.0f, (float)1.0f);
        return new Vec3((double)Mth.lerp((float)clampedT, (float)((float)a.x), (float)((float)b.x)), (double)Mth.lerp((float)clampedT, (float)((float)a.y), (float)((float)b.y)), (double)Mth.lerp((float)clampedT, (float)((float)a.z), (float)((float)b.z)));
    }

    public static float lerpAngle(float a, float b, float t) {
        float clampedT = Mth.clamp((float)t, (float)0.0f, (float)1.0f);
        float delta = Mth.wrapDegrees((float)(b - a));
        return a + delta * clampedT;
    }

    public static float wrapDegrees(float angle) {
        float newAngle = angle % 360.0f;
        if (newAngle < 0.0f) {
            newAngle += 360.0f;
        }
        return newAngle;
    }

    public static int packRGB8(int r, int g, int b) {
        int ri = Math.min(255, Math.max(0, r));
        int gi = Math.min(255, Math.max(0, g));
        int bi = Math.min(255, Math.max(0, b));
        return ri << 16 | gi << 8 | bi;
    }

    @Nullable
    public static ServerLevel findTargetLevel(MinecraftServer server, @Nullable PositionReference positionReference) {
        if (positionReference == null) {
            return null;
        }
        return StreamSupport.stream(server.getAllLevels().spliterator(), false).filter(level -> level.dimension().location().equals((Object)positionReference.dimension())).findAny().orElse(null);
    }

    public static boolean hasPlayerInside(BlockPos pos, Level level) {
        double z;
        double y;
        double x = (double)pos.getX() + 0.5;
        return level.getNearestPlayer(x, y = (double)pos.getY() + 0.5, z = (double)pos.getZ() + 0.5, 1.0, false) != null;
    }

    public static boolean isPlayerInFront(BlockPos pos, Level level, UUID playerUuid, Direction facing) {
        double fz;
        double dz;
        double dy;
        Player player = level.getPlayerByUUID(playerUuid);
        if (player == null) {
            return false;
        }
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5;
        double z = (double)pos.getZ() + 0.5;
        double dx = player.getX() - x;
        double length = Math.sqrt(dx * dx + (dy = player.getEyeY() - y) * dy + (dz = player.getZ() - z) * dz);
        if (length < 1.0E-6) {
            return false;
        }
        double ndx = dx / length;
        double ndz = dz / length;
        Vec3i dir = facing.getNormal();
        double fx = dir.getX();
        double dot = ndx * fx + ndz * (fz = (double)dir.getZ());
        return dot > 0.5;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    public static <K, V> Codec<Multimap<K, V>> multiMapCodec(Codec<K> keyCodec, Codec<V> valueCodec) {
        return Codec.unboundedMap(keyCodec, (Codec)valueCodec.listOf()).xmap(map -> {
            if (map != null) {
                HashMultimap multiMap = HashMultimap.create();
                map.forEach((arg_0, arg_1) -> ((Multimap)multiMap).putAll(arg_0, arg_1));
                return multiMap;
            }
            return null;
        }, multiMap -> multiMap != null ? multiMap.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Lists.newArrayList((Iterable)((Iterable)e.getValue())))) : null);
    }

    public static <K, V> StreamCodec<RegistryFriendlyByteBuf, Multimap<K, V>> multiMapStreamCodec(StreamCodec<ByteBuf, K> keyCodec, StreamCodec<ByteBuf, V> valueCodec) {
        StreamCodec listOfV = valueCodec.apply(ByteBufCodecs.list());
        StreamCodec mapCodec = ByteBufCodecs.map(HashMap::new, keyCodec, (StreamCodec)listOfV);
        return mapCodec.map(map -> {
            ArrayListMultimap multimap = ArrayListMultimap.create();
            map.forEach((arg_0, arg_1) -> MathUtils.lambda$multiMapStreamCodec$4((ListMultimap)multimap, arg_0, arg_1));
            return multimap;
        }, mm -> {
            HashMap out = new HashMap();
            mm.asMap().forEach((k, coll) -> out.put(k, new ArrayList(coll)));
            return out;
        });
    }

    private static /* synthetic */ void lambda$multiMapStreamCodec$4(ListMultimap multimap, Object k, List list) {
        if (list != null && !list.isEmpty()) {
            multimap.putAll(k, (Iterable)list);
        }
    }
}

