/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;

@EventBusSubscriber(modid="playershells", value={Dist.CLIENT})
public class SoundHandler {
    private static final Multimap<BlockPos, SoundInstance> SOUND_MAP = ArrayListMultimap.create();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockPlaySound(PlaySoundEvent event) {
        SoundInstance sound = event.getSound();
        if (sound == null) {
            return;
        }
        if (!event.getOriginalSound().getLocation().getNamespace().startsWith("playershells")) {
            return;
        }
        BlockPos pos = new BlockPos((int)sound.getX(), (int)sound.getY(), (int)sound.getZ());
        SOUND_MAP.put((Object)pos, (Object)sound);
    }

    public static void startBlockSound(SoundEvent soundEvent, SoundSource source, float volume, float pitch, RandomSource random, BlockPos pos) {
        SimpleSoundInstance sound = new SimpleSoundInstance(soundEvent, source, volume, pitch, random, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        Minecraft.getInstance().getSoundManager().play((SoundInstance)sound);
    }

    public static void stopAllBlockSounds(BlockPos pos) {
        for (SoundInstance sound : SOUND_MAP.get((Object)pos)) {
            if (sound == null) continue;
            Minecraft.getInstance().getSoundManager().stop(sound);
        }
        SOUND_MAP.removeAll((Object)pos);
    }
}

