/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.blockentities;

import com.ultramega.playershells.Config;
import com.ultramega.playershells.container.CentrifugeContainerMenu;
import com.ultramega.playershells.items.ItemWithOwner;
import com.ultramega.playershells.registry.ModBlockEntityTypes;
import com.ultramega.playershells.registry.ModBlocks;
import com.ultramega.playershells.registry.ModDataComponentTypes;
import com.ultramega.playershells.registry.ModItems;
import com.ultramega.playershells.utils.ObservableEnergyStorage;
import com.ultramega.playershells.utils.OwnerData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CentrifugeBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final int PROCESSING_TOTAL_TIME = 200;
    public final ItemStackHandler inventoryHandler = new ItemStackHandler(2){

        public void onContentsChanged(int slot) {
            CentrifugeBlockEntity.super.setChanged();
        }
    };
    public final ObservableEnergyStorage energyStorage = new ObservableEnergyStorage((int)((Integer)Config.CENTRIFUGE_ENERGY_CAPACITY.get())){

        @Override
        public void onEnergyChanged() {
            CentrifugeBlockEntity.this.setChanged();
        }
    };
    private int processingProgress = 0;

    public CentrifugeBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntityTypes.CENTRIFUGE.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CentrifugeBlockEntity blockEntity) {
        if (blockEntity.cannotOperate() || blockEntity.level == null) {
            return;
        }
        ++blockEntity.processingProgress;
        if (blockEntity.processingProgress >= 200) {
            blockEntity.processingProgress = 0;
            ItemStack syringeStack = blockEntity.inventoryHandler.getStackInSlot(0);
            OwnerData ownerData = (OwnerData)syringeStack.get(ModDataComponentTypes.OWNER_PLAYER.get());
            syringeStack.shrink(1);
            ItemStack dnaStack = ((ItemWithOwner)((Object)ModItems.DNA.get())).getDefaultInstance();
            dnaStack.setCount(blockEntity.level.random.nextInt(1, 6));
            dnaStack.set(ModDataComponentTypes.OWNER_PLAYER.get(), (Object)ownerData);
            blockEntity.inventoryHandler.insertItem(1, dnaStack, false);
            blockEntity.energyStorage.extractEnergy((Integer)Config.CENTRIFUGE_ENERGY_USAGE.get(), false);
        }
        blockEntity.setChanged();
    }

    private boolean cannotOperate() {
        ItemStack inputStack = this.inventoryHandler.getStackInSlot(0);
        ItemStack resultStack = this.inventoryHandler.getStackInSlot(1);
        boolean isNotSameUUID = true;
        if (!inputStack.isEmpty() && !resultStack.isEmpty()) {
            OwnerData inputOwnerData = (OwnerData)inputStack.get(ModDataComponentTypes.OWNER_PLAYER.get());
            OwnerData resultOwnerData = (OwnerData)resultStack.get(ModDataComponentTypes.OWNER_PLAYER.get());
            if (inputOwnerData != null && resultOwnerData != null && !inputOwnerData.playerUUID().equals(resultOwnerData.playerUUID())) {
                isNotSameUUID = false;
            }
        }
        return this.energyStorage.getEnergyStored() <= (Integer)Config.CENTRIFUGE_ENERGY_USAGE.get() || inputStack.isEmpty() || resultStack.getCount() >= resultStack.getMaxStackSize() || !isNotSameUUID;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("inv")) {
            this.inventoryHandler.deserializeNBT(registries, tag.getCompound("inv"));
        }
        if (tag.contains("energy")) {
            this.energyStorage.deserializeNBT(registries, tag.get("energy"));
        }
        this.processingProgress = tag.getInt("processingProgress");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inv", (Tag)this.inventoryHandler.serializeNBT(registries));
        tag.put("energy", this.energyStorage.serializeNBT(registries));
        tag.putInt("processingProgress", this.processingProgress);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public int getProcessingProgress() {
        return this.processingProgress;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.CENTRIFUGE.get()).getDescriptionId());
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new CentrifugeContainerMenu(containerId, inventory, this, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.getBlockPos()));
    }
}

