/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.packet.c2s;

import com.ultramega.playershells.blockentities.ShellForgeBlockEntity;
import com.ultramega.playershells.utils.MathUtils;
import com.ultramega.playershells.utils.PositionReference;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TransferPlayerPacket(PositionReference oldShellForgePos, PositionReference newShellForgePos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TransferPlayerPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"transfer_player_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TransferPlayerPacket> STREAM_CODEC = StreamCodec.composite(PositionReference.STREAM_CODEC, TransferPlayerPacket::oldShellForgePos, PositionReference.STREAM_CODEC, TransferPlayerPacket::newShellForgePos, TransferPlayerPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TransferPlayerPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Level level = context.player().level();
            if (level.getServer() == null) {
                return;
            }
            TransferPlayerPacket.transfer(level.getServer(), context.player(), data.oldShellForgePos(), data.newShellForgePos());
        }).exceptionally(e -> null);
    }

    public static void transfer(MinecraftServer server, Player player, @Nullable PositionReference oldShellForgePos, PositionReference newShellForgePos) {
        ShellForgeBlockEntity shellForge;
        BlockEntity blockEntity;
        ServerLevel oldTargetLevel = MathUtils.findTargetLevel(server, oldShellForgePos);
        ServerLevel newTargetLevel = MathUtils.findTargetLevel(server, newShellForgePos);
        if (oldTargetLevel != null && (blockEntity = oldTargetLevel.getBlockEntity(oldShellForgePos.pos())) instanceof ShellForgeBlockEntity) {
            shellForge = (ShellForgeBlockEntity)blockEntity;
            shellForge.transferPlayerFrom(player);
        }
        if (newTargetLevel != null && (blockEntity = newTargetLevel.getBlockEntity(newShellForgePos.pos())) instanceof ShellForgeBlockEntity && (shellForge = (ShellForgeBlockEntity)blockEntity).getShellState() == ShellForgeBlockEntity.ShellStates.EXTERMINATE) {
            shellForge.transferPlayerTo(player);
        }
    }
}

