/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.items;

import com.ultramega.playershells.items.ItemWithOwner;
import com.ultramega.playershells.registry.ModDataComponentTypes;
import com.ultramega.playershells.registry.ModItems;
import com.ultramega.playershells.utils.OwnerData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class SyringeItem
extends ItemWithOwner {
    public static final int MAX_EXTRACT_DURATION = 100;

    public SyringeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (stack.is((Item)ModItems.EMPTY_SYRINGE.get())) {
            player.startUsingItem(usedHand);
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(usedHand));
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack filledSyringe = ((SyringeItem)((Object)ModItems.BLOOD_SYRINGE.get())).getDefaultInstance();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            filledSyringe.set(ModDataComponentTypes.OWNER_PLAYER.get(), (Object)new OwnerData(player.getUUID(), player.getDisplayName().getString()));
        }
        return filledSyringe;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 100;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }
}

