/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ultramega.playershells.utils.PositionReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

public class ShellBundle {
    public static final Codec<ShellBundle> CODEC = RecordCodecBuilder.create(in -> in.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(k -> k.id), (App)ShellEntry.CODEC.listOf().fieldOf("entries").forGetter(k -> k.entries)).apply((Applicative)in, ShellBundle::new));
    public static final Codec<List<ShellBundle>> LIST_CODEC = CODEC.listOf();
    private final UUID id;
    private final List<ShellEntry> entries;

    public ShellBundle(UUID id, List<ShellEntry> entries) {
        this.id = id;
        this.entries = new ArrayList<ShellEntry>(entries);
    }

    public List<ShellEntry> getEntries() {
        return this.entries;
    }

    public record ShellEntry(String title, Optional<PositionReference> shellForgePos, Optional<InventoryEntry> inventory, Optional<StatEntry> stats, Optional<UUID> shellUuid) {
        public static final Codec<ShellEntry> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.STRING.fieldOf("title").forGetter(ShellEntry::title), (App)PositionReference.CODEC.optionalFieldOf("oldShellForgePos").forGetter(ShellEntry::shellForgePos), (App)InventoryEntry.CODEC.optionalFieldOf("inventory").forGetter(ShellEntry::inventory), (App)StatEntry.CODEC.optionalFieldOf("stats").forGetter(ShellEntry::stats), (App)UUIDUtil.CODEC.optionalFieldOf("shellUuid").forGetter(ShellEntry::shellUuid)).apply((Applicative)in, ShellEntry::new));
    }

    public record StatEntry(float health, int armorValue, int foodLevel, Map<Holder<MobEffect>, MobEffectInstance> activeEffects) {
        public static final Codec<StatEntry> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.FLOAT.fieldOf("health").forGetter(StatEntry::health), (App)Codec.INT.fieldOf("armorValue").forGetter(StatEntry::armorValue), (App)Codec.INT.fieldOf("foodLevel").forGetter(StatEntry::foodLevel), (App)Codec.unboundedMap((Codec)MobEffect.CODEC, (Codec)MobEffectInstance.CODEC).fieldOf("activeEffects").forGetter(StatEntry::activeEffects)).apply((Applicative)in, StatEntry::new));
    }

    public record InventoryEntry(NonNullList<ItemStack> items, NonNullList<ItemStack> armor, NonNullList<ItemStack> offhand) {
        public static final Codec<InventoryEntry> CODEC = RecordCodecBuilder.create(in -> in.group((App)NonNullList.codecOf((Codec)ItemStack.CODEC).fieldOf("items").forGetter(InventoryEntry::items), (App)NonNullList.codecOf((Codec)ItemStack.CODEC).fieldOf("armorValue").forGetter(InventoryEntry::armor), (App)NonNullList.codecOf((Codec)ItemStack.CODEC).fieldOf("offhand").forGetter(InventoryEntry::offhand)).apply((Applicative)in, InventoryEntry::new));
    }
}

