/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.container;

import com.ultramega.playershells.blockentities.CentrifugeBlockEntity;
import com.ultramega.playershells.registry.ModBlocks;
import com.ultramega.playershells.registry.ModDataComponentTypes;
import com.ultramega.playershells.registry.ModItems;
import com.ultramega.playershells.registry.ModMenuTypes;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class CentrifugeContainerMenu
extends AbstractContainerMenu {
    private final CentrifugeBlockEntity blockEntity;
    private final ContainerLevelAccess access;

    public CentrifugeContainerMenu(int containerId, Inventory playerInventory, FriendlyByteBuf data) {
        this(containerId, playerInventory, CentrifugeContainerMenu.getBlockEntity(playerInventory, data), ContainerLevelAccess.NULL);
    }

    public CentrifugeContainerMenu(int containerId, Inventory playerInventory, CentrifugeBlockEntity blockEntity, ContainerLevelAccess access) {
        super(ModMenuTypes.CENTRIFUGE.get(), containerId);
        int i;
        this.blockEntity = blockEntity;
        this.access = access;
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)blockEntity.inventoryHandler, 0, 56, 34){

            public boolean mayPlace(ItemStack stack) {
                return stack.is((Item)ModItems.BLOOD_SYRINGE.get()) && stack.has(ModDataComponentTypes.OWNER_PLAYER.get());
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)blockEntity.inventoryHandler, 1, 116, 35){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        InvWrapper itemHandler = new InvWrapper((Container)playerInventory);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, i, 8 + i * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack quickMovedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack rawStack = slot.getItem();
            quickMovedStack = rawStack.copy();
            if (index == 1) {
                if (!this.moveItemStackTo(rawStack, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(rawStack, quickMovedStack);
            } else if (index >= 2 && index < 38 ? !this.moveItemStackTo(rawStack, 0, 1, false) && (index < 29 ? !this.moveItemStackTo(rawStack, 29, 38, false) : !this.moveItemStackTo(rawStack, 2, 29, false)) : !this.moveItemStackTo(rawStack, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (rawStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (rawStack.getCount() == quickMovedStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, rawStack);
        }
        return quickMovedStack;
    }

    public boolean stillValid(Player player) {
        return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.CENTRIFUGE.get()));
    }

    public CentrifugeBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    private static CentrifugeBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity blockEntity = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (blockEntity instanceof CentrifugeBlockEntity) {
            CentrifugeBlockEntity block = (CentrifugeBlockEntity)blockEntity;
            return block;
        }
        throw new IllegalStateException("Block entityType is not correct! " + String.valueOf(blockEntity));
    }

    public float getProcessingProgress() {
        int progress = this.blockEntity.getProcessingProgress();
        return progress != 0 ? Mth.clamp((float)((float)progress / 200.0f), (float)0.0f, (float)1.0f) : 0.0f;
    }
}

