/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.events;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.ultramega.playershells.blockentities.renderer.ShellForgeBlockEntityRenderer;
import com.ultramega.playershells.gui.CentrifugeScreen;
import com.ultramega.playershells.gui.RadialMenuRenderer;
import com.ultramega.playershells.gui.ShellForgeScreen;
import com.ultramega.playershells.gui.ShellSelectionOverlay;
import com.ultramega.playershells.gui.layer.BloodLayer;
import com.ultramega.playershells.items.extensions.SyringeItemExtension;
import com.ultramega.playershells.registry.ModBlockEntityTypes;
import com.ultramega.playershells.registry.ModItems;
import com.ultramega.playershells.registry.ModMenuTypes;
import com.ultramega.playershells.registry.ModRenderTypes;
import com.ultramega.playershells.utils.CameraHandler;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public final class ClientEvents {
    public static BakedModel shellForgeGlassLeft;
    public static BakedModel shellForgeGlassRight;
    private static final ModelResourceLocation GLASS_LEFT_LOC;
    private static final ModelResourceLocation GLASS_RIGHT_LOC;

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (ShellSelectionOverlay.INSTANCE.getDisplayedShell() != null && mc.screen == null) {
            RadialMenuRenderer.MousePos mousePos = RadialMenuRenderer.getMousePos();
            ShellSelectionOverlay.INSTANCE.mouseClick(mousePos.x(), mousePos.y(), event.getButton(), event.getAction());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        if (ShellSelectionOverlay.INSTANCE.getDisplayedShell() != null && mc.screen == null) {
            ShellSelectionOverlay.INSTANCE.keyPressed(event.getKey());
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.EMPTY_SYRINGE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"extracting"), (stack, level, player, seed) -> player != null && player.isUsingItem() && player.getUseItem() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.EMPTY_SYRINGE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"extracting_progress"), (stack, level, player, seed) -> {
                if (player == null) {
                    return 0.0f;
                }
                return player.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(player) - player.getUseItemRemainingTicks()) / 100.0f;
            });
        });
    }

    @SubscribeEvent
    public static void onRegisterAdditional(ModelEvent.RegisterAdditional event) {
        event.register(GLASS_LEFT_LOC);
        event.register(GLASS_RIGHT_LOC);
    }

    @SubscribeEvent
    public static void onBakingCompleted(ModelEvent.BakingCompleted event) {
        shellForgeGlassLeft = (BakedModel)event.getModels().get(GLASS_LEFT_LOC);
        shellForgeGlassRight = (BakedModel)event.getModels().get(GLASS_RIGHT_LOC);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new SyringeItemExtension(), new Item[]{(Item)ModItems.EMPTY_SYRINGE.get()});
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(ModMenuTypes.SHELL_FORGE.get(), ShellForgeScreen::new);
        event.register(ModMenuTypes.CENTRIFUGE.get(), CentrifugeScreen::new);
    }

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"shells_selection"), (LayeredDraw.Layer)ShellSelectionOverlay.INSTANCE);
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"blood"), (LayeredDraw.Layer)new BloodLayer());
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlockEntityTypes.SHELL_FORGE.get(), ShellForgeBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"create_shader"), DefaultVertexFormat.NEW_ENTITY), shaderInstance -> {
            ModRenderTypes.createShaderInstance = shaderInstance;
        });
    }

    @SubscribeEvent
    public static void cancelRenderingGuiLayers(RenderGuiLayerEvent.Pre event) {
        if (CameraHandler.isCameraOutsideOfPlayer()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void cancelRenderingHand(RenderHandEvent event) {
        if (CameraHandler.isCameraOutsideOfPlayer()) {
            event.setCanceled(true);
        }
    }

    static {
        GLASS_LEFT_LOC = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"block/shell_forge_glass_left"), "standalone");
        GLASS_RIGHT_LOC = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"playershells", (String)"block/shell_forge_glass_right"), "standalone");
    }
}

