/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.playershells.items;

import com.ultramega.playershells.items.ItemWithOwner;
import com.ultramega.playershells.registry.ModDataComponentTypes;
import com.ultramega.playershells.registry.ModItems;
import com.ultramega.playershells.utils.MathUtils;
import com.ultramega.playershells.utils.OwnerData;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class SyringeItem
extends ItemWithOwner {
    public static final int MAX_EXTRACT_DURATION = 100;
    public static final float[] PULSE_POINTS = new float[]{0.1f, 0.3f, 0.5f, 0.7f, 0.95f};

    public SyringeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (stack.is((Item)ModItems.EMPTY_SYRINGE.get())) {
            player.startUsingItem(usedHand);
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(usedHand));
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (level.isClientSide()) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.options.getCameraType() != CameraType.FIRST_PERSON) {
                mc.options.setCameraType(CameraType.FIRST_PERSON);
            }
        }
        if (!level.isClientSide()) {
            float usePos = (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 100.0f;
            for (float point : PULSE_POINTS) {
                if (!MathUtils.near(usePos, point)) continue;
                entity.hurt(entity.damageSources().magic(), 2.0f);
            }
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack filledSyringe = ((SyringeItem)((Object)ModItems.BLOOD_SYRINGE.get())).getDefaultInstance();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            filledSyringe.set(ModDataComponentTypes.OWNER_PLAYER.get(), (Object)new OwnerData(player.getUUID(), player.getDisplayName().getString()));
        }
        return filledSyringe;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 100;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }
}

