/*
 * Decompiled with CFR 0.152.
 */
package dev.tubyoub.modchecker;

import dev.tubyoub.modchecker.ModListFetcher;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModChecker
implements ModInitializer {
    public static final String MOD_ID = "mod-checker";
    public static final Logger LOGGER = LogManager.getLogger((String)"mod-checker");
    public static boolean unexpectedModsDetected = false;
    private static final ModListFetcher modListFetcher = new ModListFetcher();

    public void onInitialize() {
        LOGGER.info("[ModChecker] Initializing ModChecker");
        this.checkForUnexpectedMods();
    }

    private void checkForUnexpectedMods() {
        List<String> allowedMods = modListFetcher.getAllowedMods();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            String modId = mod.getMetadata().getId();
            if (allowedMods.contains(modId) || modId.startsWith("fabric-")) continue;
            unexpectedModsDetected = true;
            LOGGER.info("[ModChecker] found unexpected mod: " + modId);
        }
    }
}

