/*
 * Decompiled with CFR 0.152.
 */
package dev.tubyoub.modchecker;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class ModListFetcher {
    private static final String MOD_LIST_URL = "https://raw.githubusercontent.com/TubYoub/ModChecker/master/allowed_mods.json";
    private static final Duration CACHE_DURATION = Duration.ofHours(24L);
    private List<String> cachedModList;
    private long lastFetchTime;

    public List<String> getAllowedMods() {
        if (this.cachedModList == null || System.currentTimeMillis() - this.lastFetchTime > CACHE_DURATION.toMillis()) {
            this.fetchModList();
        }
        return this.cachedModList;
    }

    private void fetchModList() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(MOD_LIST_URL)).timeout(Duration.ofSeconds(10L)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to fetch mod list: HTTP " + response.statusCode());
            }
            Gson gson = new Gson();
            this.cachedModList = (List)gson.fromJson(response.body(), new TypeToken<ArrayList<String>>(this){}.getType());
            this.lastFetchTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch mod list", e);
        }
    }
}

