/*
 * Decompiled with CFR 0.152.
 */
package dev.tubyoub.modchecker.mixin;

import dev.tubyoub.modchecker.ModChecker;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.client.ClientBrandRetriever;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientBrandRetriever.class})
public class ClientBrandMixin {
    private static String cachedBrand;

    @Inject(method={"getClientModName()Ljava/lang/String;"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void onGetClientModName(CallbackInfoReturnable<String> cir) {
        if (cachedBrand == null) {
            Optional<ModMetadata> optionalMetadata = FabricLoader.getInstance().getModContainer("mod-checker").map(container -> container.getMetadata());
            if (optionalMetadata.isPresent()) {
                ModMetadata metadata = optionalMetadata.get();
                String version = metadata.getVersion().getFriendlyString();
                cachedBrand = "ModChecker-fabric v" + version;
                cachedBrand = ModChecker.unexpectedModsDetected ? cachedBrand + " (Unexpected Mods detected)" : cachedBrand + " (No unexpected mods detected)";
            } else {
                cachedBrand = "ModChecker";
            }
            ModChecker.LOGGER.info("[ModChecker] Successfully changed client brand to: {}", (Object)cachedBrand);
        }
        cir.setReturnValue((Object)cachedBrand);
    }
}

