/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Deque;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3419;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import xerca.xercamusic.client.BetterSlider;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.client.MidiHandler;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.SoundEvents;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.clientbound.NotesPartAckFromServerPacketHandler;
import xerca.xercamusic.common.packets.serverbound.ImportMusicSendPacket;
import xerca.xercamusic.common.packets.serverbound.MusicUpdatePacket;
import xerca.xercamusic.common.packets.serverbound.SendNotesPartToServerPacket;

public class GuiMusicSheet
extends class_437 {
    public static final int BEATS_IN_SCREEN = 91;
    private static final String[] OCTAVE_NAMES = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII"};
    private static final class_2960 NOTE_GUI_LEFT_TEXTURE = Mod.id("textures/gui/music_sheet_left.png");
    private static final class_2960 NOTE_GUI_TEXTURES = Mod.id("textures/gui/music_sheet.png");
    private static final class_2960 INSTRUMENT_TEXTURES = Mod.id("textures/gui/instruments.png");
    private static final int NOTE_IMAGE_LEFT_TEX_X = 175;
    private static final int NOTE_IMAGE_LEFT_TEX_Y = 51;
    private static final int NOTE_IMAGE_LEFT_WIDTH = 81;
    private static final int NOTE_IMAGE_LEFT_HEIGHT = 205;
    private static final int NOTE_IMAGE_TEX_X = 0;
    private static final int NOTE_IMAGE_TEX_Y = 44;
    private static final int NOTE_IMAGE_WIDTH = 256;
    private static final int NOTE_IMAGE_HEIGHT = 210;
    private static final int NOTE_REGION_LEFT = 44;
    private static final int NOTE_REGION_TOP = 39;
    private static final int NOTE_REGION_RIGHT = 316;
    private static final int NOTE_REGION_BOTTOM = 182;
    private static final int BPM_BUT_W = 10;
    private static final int BPM_BUT_H = 10;
    private static final int BPM_BUT_X = 245;
    private static final int BPM_BUT_Y = 12;
    private static final int HL_BUT_X = 261;
    private static final int HL_BUT_Y = 23;
    private static final int[] OCTAVE_COLORS = new int[]{-10800640, -65536, -16060928, -16754177, -8716033, -1113929, -16719137, -727040};
    private static final int[] OCTAVE_COLORS_TRANS = new int[]{375075328, 385810432, 369815040, 369121791, 377159935, 384762039, 369156831, 385148928};
    private static final int MAX_LENGTH_BEATS = 32000;
    private static final byte COPY_BEGIN_BYTE = 50;
    private static final int MAX_NOTE_LENGTH = 60;
    private static final int MAX_UNDO_LENGTH = 16;
    private static final String NOTE_LEFT_STR_KEY = "note.leftButton";
    private static final String NOTE_RIGHT_STR_KEY = "note.rightButton";
    private static int currentOctave = 1;
    private static float brushVolume = 0.5f;
    private final class_1657 editingPlayer;
    private final NoteSound[] notePlaySounds;
    private final ArrayList<NoteEvent> recordingNotes = new ArrayList();
    private final boolean[] buttonPushStates = new boolean[96];
    private final UUID id;
    private final MusicUpdatePacket.FieldFlag dirtyFlag = new MusicUpdatePacket.FieldFlag();
    private final Deque<ArrayList<NoteEvent>> undoStack = new ArrayDeque<ArrayList<NoteEvent>>(16);
    private final ArrayList<ArrayList<NoteEvent>> neighborNotes = new ArrayList();
    private final ArrayList<Float> neighborVolumes = new ArrayList();
    private final ArrayList<Integer> neighborPreviewNextNoteIDs = new ArrayList();
    private final ArrayList<Integer> neighborPrevInstruments = new ArrayList();
    private final MidiHandler midiHandler;
    private int noteImageX;
    private int noteImageLeftX;
    private int noteImageY;
    private byte highlightInterval = (byte)12;
    private boolean isSigned;
    private int generation;
    private boolean gettingSigned;
    private boolean previewing;
    private boolean previewStarted;
    private boolean recording;
    private boolean preRecording;
    private boolean preRecordPlayTick;
    private int previewCursor;
    private int previewCursorStart;
    private int oldPreRecordBeat;
    private int editCursor;
    private int editCursorEnd;
    private int selectionStart;
    private int tickCount;
    private String noteTitle = "";
    private class_4185 bpmUp;
    private class_4185 bpmDown;
    private class_4185 octaveUp;
    private class_4185 octaveDown;
    private class_4185 hlUp;
    private class_4185 hlDown;
    private class_4185 buttonSign;
    private class_4185 buttonCancel;
    private class_4185 buttonFinalize;
    private class_4185 buttonHelp;
    private BetterSlider sliderTime;
    private BetterSlider sliderSheetVolume;
    private BetterSlider sliderNoteVolume;
    private NoteEditBox noteEditBox;
    private ChangeableImageButton buttonPreview;
    private ChangeableImageButton buttonRecord;
    private ChangeableImageButton buttonHideNeighbors;
    private LockImageButton buttonLockPrevIns;
    private boolean neighborsHidden;
    private boolean prevInsLocked;
    private boolean selfSigned;
    private int version;
    private ArrayList<NoteEvent> notes = new ArrayList();
    private short lengthBeats;
    private byte bps = (byte)8;
    private int bpm;
    private int previewInstrument = -1;
    private long lastMillis;
    private long cumMillis;
    private int previewNextNoteID;
    private NoteEvent currentlyAddedNote;
    private int sliderPosition;
    private int maxSliderPosition = 500;
    private int currentOctavePos = 1;
    private float volume = 1.0f;
    private boolean helpOn;

    GuiMusicSheet(class_1657 player, class_1799 sheet, class_2561 title) {
        super(title);
        int currentSlot;
        boolean added;
        int index;
        this.editingPlayer = player;
        UUID sheetId = (UUID)sheet.method_57824(Items.SHEET_ID);
        this.version = (Integer)sheet.method_57825(Items.SHEET_VERSION, (Object)-1);
        if (sheetId != null && this.version >= 0) {
            MusicManager.MusicData data = MusicManagerClient.getMusicData(sheetId, this.version);
            if (data != null) {
                this.notes.addAll(data.notes());
            }
            this.lengthBeats = (short)((Integer)sheet.method_57825(Items.SHEET_LENGTH, (Object)0)).intValue();
            this.bps = (Byte)sheet.method_57825(Items.SHEET_BPS, (Object)8);
            this.volume = ((Float)sheet.method_57825(Items.SHEET_VOLUME, (Object)Float.valueOf(1.0f))).floatValue();
            this.generation = (Integer)sheet.method_57825(Items.SHEET_GENERATION, (Object)0);
            this.isSigned = this.generation > 0;
            this.noteTitle = (String)sheet.method_57825(Items.SHEET_TITLE, (Object)"");
            String authorName = (String)sheet.method_57825(Items.SHEET_AUTHOR, (Object)"");
            this.prevInsLocked = (Boolean)sheet.method_57825(Items.SHEET_PREV_INSTRUMENT_LOCKED, (Object)false);
            Byte prevIns = (Byte)sheet.method_57824(Items.SHEET_PREV_INSTRUMENT);
            if (prevIns != null) {
                this.previewInstrument = prevIns.byteValue();
            }
            this.highlightInterval = (Byte)sheet.method_57825(Items.SHEET_HIGHLIGHT_INTERVAL, (Object)12);
            if (authorName.equals(player.method_5477().getString())) {
                this.selfSigned = true;
            }
        } else {
            this.isSigned = false;
            sheetId = UUID.randomUUID();
            this.version = 0;
            this.dirtyFlag.hasId = true;
            this.dirtyFlag.hasVersion = true;
        }
        this.id = sheetId;
        if (this.notes.isEmpty()) {
            this.lengthBeats = 0;
        }
        this.bpm = this.bps * 60;
        this.tickCount = 0;
        if (!this.prevInsLocked && (index = this.getCurrentOffhandInsIndex()) != this.previewInstrument) {
            this.previewInstrument = index;
            if (!this.isSigned || this.selfSigned || this.generation > 1) {
                this.dirtyFlag.hasPrevIns = true;
            }
        }
        if (added = this.addNeighborSheet(this.getStackInSlot((currentSlot = player.method_31548().field_7545) - 1))) {
            this.addNeighborSheet(this.getStackInSlot(currentSlot - 2));
        }
        if (added = this.addNeighborSheet(this.getStackInSlot(currentSlot + 1))) {
            this.addNeighborSheet(this.getStackInSlot(currentSlot + 2));
        }
        this.midiHandler = new MidiHandler(this::startSound, this::endSound, this::midiControlCommand);
        this.midiHandler.currentOctave = currentOctave;
        this.notePlaySounds = new NoteSound[96];
    }

    private static int octaveFromNote(byte note) {
        return (note - 21) / 12;
    }

    private int getCurrentOffhandInsIndex() {
        class_1792 offhand = this.editingPlayer.method_6079().method_7909();
        if (offhand instanceof IItemInstrument) {
            IItemInstrument ins = (IItemInstrument)offhand;
            return Items.INSTRUMENTS.indexOf(ins);
        }
        return -1;
    }

    private void startSound(MidiHandler.MidiData data) {
        int noteId = data.noteId();
        this.startSound(noteId, (byte)(data.volume() * 128.0f));
    }

    private void startSound(int noteId, byte volume) {
        if (noteId >= 0 && noteId < this.buttonPushStates.length && this.buttonPushStates[noteId]) {
            Mod.LOGGER.warn("Key pushed twice noteId: {} vol: {}", (Object)noteId, (Object)volume);
        }
        if (noteId >= 0 && noteId < this.buttonPushStates.length && !this.buttonPushStates[noteId]) {
            IItemInstrument.InsSound noteSound;
            this.buttonPushStates[noteId] = true;
            int note = IItemInstrument.idToNote(noteId);
            for (NoteEvent noteEvent : this.recordingNotes) {
                if (noteEvent.note != note) continue;
                Mod.LOGGER.warn("Existing note pushed? {} vol: {}", (Object)noteId, (Object)volume);
                return;
            }
            if (this.previewInstrument >= 0 && this.previewInstrument < Items.INSTRUMENTS.size()) {
                IItemInstrument ins = Items.INSTRUMENTS.get(this.previewInstrument);
                noteSound = ins.getSound(note);
            } else {
                noteSound = ((IItemInstrument)Items.HARP_MC).getSound(note);
            }
            if (noteSound == null) {
                Mod.LOGGER.warn("noteSound not found - noteId: {} vol: {}", (Object)noteId, (Object)volume);
                return;
            }
            try {
                this.notePlaySounds[noteId] = (NoteSound)((Object)Mod.onlyCallOnClient(() -> () -> ClientStuff.playNote(noteSound.sound(), this.editingPlayer.method_23317(), this.editingPlayer.method_23318(), this.editingPlayer.method_23321(), (float)volume / 128.0f, noteSound.pitch())));
            }
            catch (Exception e) {
                Mod.LOGGER.error("Error playing sound", (Throwable)e);
            }
            if (this.recording) {
                NoteEvent newNote = new NoteEvent((byte)note, (short)Math.max(0, this.previewCursor - 1), volume, 1);
                this.addRecordingNote(newNote);
                ++this.previewNextNoteID;
                this.dirtyFlag.hasNotes = true;
                this.dirtyFlag.hasLength = true;
            }
        }
    }

    private void endSound(int noteId) {
        if (noteId >= 0 && noteId < this.buttonPushStates.length && this.buttonPushStates[noteId]) {
            this.buttonPushStates[noteId] = false;
            if (this.notePlaySounds[noteId] != null) {
                this.notePlaySounds[noteId].stopSound();
                this.notePlaySounds[noteId] = null;
            }
            if (this.recording) {
                int note = IItemInstrument.idToNote(noteId);
                for (int i = 0; i < this.recordingNotes.size(); ++i) {
                    if (this.recordingNotes.get((int)i).note != note) continue;
                    this.recordingNotes.remove(i);
                    break;
                }
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    private boolean addNeighborSheet(class_1799 neighbor) {
        byte neighborBPS;
        if (!neighbor.method_7960() && neighbor.method_7909() instanceof ItemMusicSheet && (neighborBPS = ItemMusicSheet.getBPS(neighbor)) == this.bps) {
            UUID uuid = (UUID)neighbor.method_57824(Items.SHEET_ID);
            int ver = (Integer)neighbor.method_57825(Items.SHEET_VERSION, (Object)-1);
            if (uuid != null && ver >= 0) {
                MusicManagerClient.checkMusicDataAndRun(uuid, ver, () -> {
                    MusicManager.MusicData data = MusicManagerClient.getMusicData(uuid, ver);
                    if (data != null) {
                        this.neighborNotes.add(new ArrayList<NoteEvent>(data.notes()));
                        this.neighborPrevInstruments.add(ItemMusicSheet.getPrevInstrument(neighbor));
                        this.neighborPreviewNextNoteIDs.add(-1);
                        this.neighborVolumes.add(Float.valueOf(ItemMusicSheet.getVolume(neighbor)));
                    }
                });
            }
            return true;
        }
        return false;
    }

    private class_1799 getStackInSlot(int slot) {
        if (slot >= 0 && slot < this.editingPlayer.method_31548().method_5439()) {
            return this.editingPlayer.method_31548().method_5438(slot);
        }
        return class_1799.field_8037;
    }

    public void method_25426() {
        this.noteImageX = (this.field_22789 - 337) / 2 + 81;
        this.noteImageLeftX = this.noteImageX - 81;
        this.noteImageY = 2;
        if (!this.isSigned) {
            this.buttonSign = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"note.signButton"), button -> {
                if (!this.isSigned) {
                    this.gettingSigned = true;
                    this.updateButtons();
                }
            }).method_46434(this.noteImageLeftX + 112, this.noteImageY + 210, 98, 20).method_46431());
            this.buttonFinalize = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"note.finalizeButton"), button -> {
                if (!this.isSigned) {
                    this.dirtyFlag.hasSigned = true;
                    this.dirtyFlag.hasTitle = true;
                    this.isSigned = true;
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507(null);
                    }
                }
            }).method_46434(this.noteImageLeftX + 112, 145, 98, 20).method_46431());
            this.buttonCancel = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> {
                if (!this.isSigned) {
                    this.gettingSigned = false;
                    this.updateButtons();
                }
            }).method_46434(this.noteImageLeftX + 112, 170, 98, 20).method_46431());
        }
        this.buttonPreview = (ChangeableImageButton)this.method_37063((class_364)new ChangeableImageButton(this.noteImageLeftX + 50, 16, 16, 16, 224, 0, 16, NOTE_GUI_TEXTURES, button -> this.previewButton()));
        this.buttonRecord = (ChangeableImageButton)this.method_37063((class_364)new ChangeableImageButton(this.noteImageLeftX + 70, 16, 16, 16, 176, 0, 16, NOTE_GUI_TEXTURES, button -> this.recordButton()));
        this.buttonHideNeighbors = (ChangeableImageButton)this.method_37063((class_364)new ChangeableImageButton(this.noteImageLeftX + 90, 16, 16, 16, 192, 0, 16, NOTE_GUI_TEXTURES, button -> {
            boolean bl = this.neighborsHidden = !this.neighborsHidden;
            if (this.neighborsHidden) {
                this.buttonHideNeighbors.setTexStarts(208, 0);
            } else {
                this.buttonHideNeighbors.setTexStarts(192, 0);
            }
        }));
        this.buttonLockPrevIns = (LockImageButton)this.method_37063((class_364)new LockImageButton(this.noteImageLeftX + 110, 16, 16, 16, this.previewInstrument * 16 + 16, 32 * ((this.previewInstrument + 1) / 16), 16, INSTRUMENT_TEXTURES, button -> {
            if (!this.isSigned || this.selfSigned || this.generation > 1) {
                int index;
                this.prevInsLocked = !this.prevInsLocked;
                this.dirtyFlag.hasPrevInsLocked = true;
                if (!this.prevInsLocked && (index = this.getCurrentOffhandInsIndex()) != this.previewInstrument) {
                    this.previewInstrument = index;
                    this.buttonLockPrevIns.setTexStarts(this.previewInstrument * 16 + 16, 32 * ((this.previewInstrument + 1) / 16));
                    this.dirtyFlag.hasPrevIns = true;
                }
            }
        }));
        this.bpmUp = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"note.upButton"), button -> {
            if (!this.isSigned || this.selfSigned || this.generation > 1) {
                if (GuiMusicSheet.method_25442()) {
                    int mult;
                    int n = mult = GuiMusicSheet.method_25441() ? 3 : 2;
                    if (this.bps * mult <= 50) {
                        this.pushUndo();
                        this.bps = (byte)(this.bps * (byte)mult);
                        this.dirtyFlag.hasBps = true;
                        this.previewing = false;
                        this.previewCursor = this.previewCursorStart;
                        for (NoteEvent note : this.notes) {
                            note.time = (short)(note.time * (short)mult);
                            note.length = (byte)Math.min(60, note.length * mult);
                        }
                        this.updateLength();
                    }
                } else if (this.bps < 50) {
                    this.bps = (byte)(this.bps + 1);
                    this.dirtyFlag.hasBps = true;
                    this.cumMillis *= (long)((float)(this.bps - 1) / (float)this.bps);
                }
                this.bpm = 60 * this.bps;
            }
        }).method_46434(this.noteImageLeftX + 245, this.noteImageY + 12, 10, 10).method_46431());
        this.bpmDown = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"note.downButton"), button -> {
            if (!this.isSigned || this.selfSigned || this.generation > 1) {
                if (GuiMusicSheet.method_25442()) {
                    float mult;
                    float f = mult = GuiMusicSheet.method_25441() ? 0.33f : 0.5f;
                    if (Math.round((float)this.bps * mult) >= 1) {
                        this.pushUndo();
                        this.bps = (byte)Math.round((float)this.bps * mult);
                        this.dirtyFlag.hasBps = true;
                        this.previewing = false;
                        this.previewCursor = this.previewCursorStart;
                        for (NoteEvent note : this.notes) {
                            note.time = (short)Math.round((float)note.time * mult);
                            note.length = (byte)Math.max(Math.round((float)note.length * mult), 1);
                        }
                        this.updateLength();
                        NoteEvent.removeDuplicates(this.notes);
                    }
                } else if (this.bps > 1) {
                    this.bps = (byte)(this.bps - 1);
                    this.dirtyFlag.hasBps = true;
                    this.cumMillis *= (long)((float)(this.bps + 1) / (float)this.bps);
                }
                this.bpm = 60 * this.bps;
            }
        }).method_46434(this.noteImageLeftX + 245, this.noteImageY + 12 + 1 + 10, 10, 10).method_46431());
        this.octaveUp = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"note.upButton"), button -> {
            if (this.currentOctavePos < 4) {
                ++this.currentOctavePos;
            }
        }).method_46434(this.noteImageLeftX + 15, this.noteImageY + 30, 10, 10).method_46431());
        this.octaveDown = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"note.downButton"), button -> {
            if (this.currentOctavePos > 0) {
                --this.currentOctavePos;
            }
        }).method_46434(this.noteImageLeftX + 15, this.noteImageY + 182, 10, 10).method_46431());
        this.sliderTime = (BetterSlider)this.method_37063((class_364)new BetterSlider(this.noteImageLeftX + 44, this.noteImageY + 182 + 4, 272, 10, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), 0.0, 1.0, 0.0, 0.001, false){

            @Override
            public void method_25344() {
                GuiMusicSheet.this.sliderPosition = (int)(this.field_22753 * (double)GuiMusicSheet.this.maxSliderPosition);
            }
        });
        this.sliderSheetVolume = (BetterSlider)this.method_37063((class_364)new BetterSlider(this.noteImageLeftX + 316 - 55, this.noteImageY + 12, 54, 10, (class_2561)class_2561.method_43470((String)"S Vol "), (class_2561)class_2561.method_43473(), 0.0, 100.0, (double)(this.volume * 100.0f), true){

            @Override
            public void method_25344() {
                if (!GuiMusicSheet.this.isSigned || GuiMusicSheet.this.selfSigned || GuiMusicSheet.this.generation > 1) {
                    GuiMusicSheet.this.volume = (float)this.field_22753;
                    GuiMusicSheet.this.dirtyFlag.hasVolume = true;
                }
            }
        });
        this.sliderNoteVolume = (BetterSlider)this.method_37063((class_364)new BetterSlider(this.noteImageLeftX + 130, this.noteImageY + 12, 54, 10, (class_2561)class_2561.method_43470((String)"N Vol "), (class_2561)class_2561.method_43473(), 0.0, 100.0, (double)(brushVolume * 100.0f), true){

            @Override
            public void method_25344() {
                if (!GuiMusicSheet.this.isSigned) {
                    brushVolume = (float)this.field_22753;
                }
            }
        });
        this.hlDown = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)NOTE_LEFT_STR_KEY), button -> {
            if ((!this.isSigned || this.selfSigned || this.generation > 1) && this.highlightInterval > 1) {
                this.highlightInterval = (byte)(this.highlightInterval - 1);
                this.dirtyFlag.hasHlInterval = true;
            }
        }).method_46434(this.noteImageLeftX + 261, this.noteImageY + 23, 10, 10).method_46431());
        this.hlUp = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)NOTE_RIGHT_STR_KEY), button -> {
            if ((!this.isSigned || this.selfSigned || this.generation > 1) && this.highlightInterval < 24) {
                this.highlightInterval = (byte)(this.highlightInterval + 1);
                this.dirtyFlag.hasHlInterval = true;
            }
        }).method_46434(this.noteImageLeftX + 261 + 44, this.noteImageY + 23, 10, 10).method_46431());
        this.noteEditBox = (NoteEditBox)this.method_37063((class_364)new NoteEditBox(0, 0, 70, 55, (class_2561)class_2561.method_43473()));
        this.buttonHelp = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"?"), button -> this.toggleHelp()).method_46434(this.noteImageLeftX + 316 + 30, this.noteImageY + 12, 20, 20).method_46431());
        this.updateButtons();
        this.updateLength();
    }

    private void previewButton() {
        if (!this.previewing) {
            this.startPreview();
        } else {
            this.stopPreview();
        }
    }

    private void recordButton() {
        if (!this.recording && !this.preRecording) {
            this.startPreRecording();
        } else {
            this.stopRecording();
        }
    }

    private void updateButtons() {
        if (!this.isSigned) {
            this.buttonSign.field_22764 = !this.gettingSigned;
            this.buttonSign.field_22763 = !this.helpOn && !this.recording && !this.preRecording;
            this.buttonCancel.field_22764 = this.gettingSigned;
            this.buttonFinalize.field_22764 = this.gettingSigned;
            this.buttonFinalize.field_22763 = !this.noteTitle.trim().isEmpty();
        }
        this.bpmUp.field_22764 = !this.gettingSigned && (!this.isSigned || this.selfSigned || this.generation > 1);
        this.bpmDown.field_22764 = this.bpmUp.field_22764;
        this.bpmUp.field_22763 = !this.recording && !this.preRecording;
        this.bpmDown.field_22763 = this.bpmUp.field_22763;
        this.buttonPreview.field_22764 = !this.gettingSigned;
        this.buttonPreview.field_22763 = !this.recording && !this.preRecording;
        this.buttonLockPrevIns.field_22764 = !this.gettingSigned;
        this.buttonLockPrevIns.field_22763 = (!this.isSigned || this.selfSigned || this.generation > 1) && !this.recording && !this.preRecording;
        this.sliderSheetVolume.field_22764 = !this.gettingSigned;
        this.sliderSheetVolume.field_22763 = (!this.isSigned || this.selfSigned || this.generation > 1) && !this.recording && !this.preRecording;
        this.noteEditBox.field_22764 = false;
        this.noteEditBox.field_22763 = false;
        this.octaveDown.field_22764 = !this.gettingSigned;
        this.octaveUp.field_22764 = !this.gettingSigned;
        this.sliderTime.field_22764 = !this.gettingSigned;
        this.sliderTime.field_22763 = !this.recording && !this.preRecording;
        this.hlUp.field_22764 = !this.gettingSigned && (!this.isSigned || this.selfSigned || this.generation > 1);
        this.hlUp.field_22763 = (!this.isSigned || this.selfSigned || this.generation > 1) && !this.recording && !this.preRecording;
        this.hlDown.field_22764 = !this.gettingSigned && (!this.isSigned || this.selfSigned || this.generation > 1);
        this.hlDown.field_22763 = (!this.isSigned || this.selfSigned || this.generation > 1) && !this.recording && !this.preRecording;
        this.sliderNoteVolume.field_22764 = !this.isSigned && !this.gettingSigned;
        this.sliderNoteVolume.field_22763 = this.sliderNoteVolume.field_22764 && !this.recording && !this.preRecording;
        this.buttonHelp.field_22764 = !this.isSigned && !this.gettingSigned;
        this.buttonHelp.field_22763 = this.buttonHelp.field_22764 && !this.recording && !this.preRecording;
        this.buttonHideNeighbors.field_22764 = !this.neighborNotes.isEmpty() && !this.gettingSigned;
        this.buttonHideNeighbors.field_22763 = !this.recording && !this.preRecording;
        this.buttonRecord.field_22764 = !this.gettingSigned && !this.isSigned;
        this.buttonRecord.field_22763 = this.recording || this.preRecording || !this.previewing;
    }

    private void toggleHelp() {
        this.helpOn = !this.helpOn;
        this.updateButtons();
    }

    public void method_25393() {
        super.method_25393();
        ++this.tickCount;
    }

    private void playMetronomeTick() {
        try {
            Mod.onlyCallOnClient(() -> () -> ClientStuff.playNote(SoundEvents.TICK, this.editingPlayer.method_23317(), this.editingPlayer.method_23318(), this.editingPlayer.method_23321(), class_3419.field_15248, 1.0f, 0.975f + this.editingPlayer.method_37908().field_9229.method_43057() * 0.05f, (byte)-1));
        }
        catch (Exception e) {
            Mod.LOGGER.error("Exception in playMetronomeTick", (Throwable)e);
        }
    }

    private NoteSound playSound(NoteEvent event, int previewInstrument) {
        return this.playSound(event, previewInstrument, this.volume);
    }

    private NoteSound playSound(NoteEvent event, int previewInstrument, float sheetVolume) {
        IItemInstrument.InsSound insSound;
        if (event.note < 21 || event.note > 117) {
            Mod.LOGGER.warn("Note is invalid: {}", (Object)event.note);
            return null;
        }
        if (previewInstrument >= 0 && previewInstrument < Items.INSTRUMENTS.size()) {
            IItemInstrument ins = Items.INSTRUMENTS.get(previewInstrument);
            insSound = ins.getSound(event.note);
        } else {
            insSound = ((IItemInstrument)Items.HARP_MC).getSound(event.note);
        }
        if (insSound == null) {
            return null;
        }
        try {
            return (NoteSound)((Object)Mod.onlyCallOnClient(() -> () -> ClientStuff.playNote(insSound.sound(), this.editingPlayer.method_23317(), this.editingPlayer.method_23318(), this.editingPlayer.method_23321(), sheetVolume * event.floatVolume(), insSound.pitch(), (byte)this.beatsToTicks(event.length))));
        }
        catch (Exception e) {
            Mod.LOGGER.error("Exception in playSound", (Throwable)e);
            return null;
        }
    }

    private int beatsToTicks(int beats) {
        return Math.round((float)beats * 20.0f / (float)this.bps);
    }

    private void playPreviewSound(int curStart, int curEnd) {
        if (this.previewNextNoteID < this.notes.size()) {
            NoteEvent event = this.notes.get(this.previewNextNoteID);
            while (event.time >= curStart && event.time < curEnd) {
                if (!this.recordingNotes.contains(event)) {
                    this.playSound(event, this.previewInstrument);
                }
                ++this.previewNextNoteID;
                if (this.previewNextNoteID >= this.notes.size()) break;
                event = this.notes.get(this.previewNextNoteID);
            }
        }
        if (!this.neighborsHidden) {
            for (int i = 0; i < this.neighborNotes.size(); ++i) {
                ArrayList<NoteEvent> nn = this.neighborNotes.get(i);
                int nPrevNoteID = this.neighborPreviewNextNoteIDs.get(i);
                if (nPrevNoteID < 0 || nPrevNoteID >= nn.size()) continue;
                NoteEvent n = nn.get(nPrevNoteID);
                int ins = this.neighborPrevInstruments.get(i);
                while (n.time >= curStart && n.time < curEnd) {
                    this.playSound(n, ins, this.neighborVolumes.get(i).floatValue());
                    if (++nPrevNoteID >= nn.size()) break;
                    n = nn.get(nPrevNoteID);
                }
                this.neighborPreviewNextNoteIDs.set(i, nPrevNoteID);
            }
        }
    }

    private void drawSigning(class_332 guiGraphics) {
        int i = this.noteImageLeftX;
        int j = this.noteImageY;
        int left = i + 100;
        int top = j + 40;
        int width = 120;
        int height = 100;
        guiGraphics.method_25294(left, top, left + 120, top + 100, -1);
        Object titleStr = this.noteTitle;
        if (!this.isSigned) {
            titleStr = this.tickCount / 6 % 2 == 0 ? (String)titleStr + String.valueOf(class_124.field_1074) + "_" : (String)titleStr + String.valueOf(class_124.field_1080) + "_";
        }
        String writeTitleStr = class_1074.method_4662((String)"note.editTitle", (Object[])new Object[0]);
        int k = this.field_22793.method_1727(writeTitleStr);
        guiGraphics.method_51433(this.field_22793, writeTitleStr, (int)((float)left + (float)(120 - k) / 2.0f), top + 16, 0, false);
        int l = this.field_22793.method_1727((String)titleStr);
        guiGraphics.method_51433(this.field_22793, (String)titleStr, (int)((float)left + (float)(120 - l) / 2.0f), top + 30, 0, false);
        String authorStr = class_1074.method_4662((String)"note.byAuthor", (Object[])new Object[]{this.editingPlayer.method_5477().getString()});
        int i1 = this.field_22793.method_1727(authorStr);
        guiGraphics.method_51433(this.field_22793, String.valueOf(class_124.field_1063) + authorStr, (int)((float)left + (float)(116 - i1) / 2.0f), top + 42, 0, false);
        guiGraphics.method_51440(this.field_22793, (class_5348)class_2561.method_43471((String)"note.finalizeWarning"), left + 10, top + 60, 116, 0);
    }

    private int noteToPixelX(int noteX) {
        return this.noteImageLeftX + 44 + noteX * 3;
    }

    private void drawCursor(class_332 guiGraphics, int cursorX, int color) {
        if (this.inScreen(cursorX)) {
            int x = this.noteToPixelX(cursorX - this.sliderPosition);
            int y = this.noteImageY + 39;
            guiGraphics.method_25294(x + 1, y, x + 2, y + 144, color);
        }
    }

    public void midiControlCommand(MidiControl controlType) {
        switch (controlType.ordinal()) {
            case 0: {
                if (this.previewing || this.recording || this.preRecording) break;
                this.editCursor = 0;
                this.editCursorEnd = 0;
                if (this.inScreen(this.editCursor)) break;
                this.setSliderPos(this.editCursor);
                break;
            }
            case 1: {
                if (this.previewing || this.recording || this.preRecording) break;
                this.editCursor = this.lengthBeats - 1;
                this.editCursorEnd = this.lengthBeats - 1;
                if (this.inScreen(this.editCursor)) break;
                this.setSliderPos(this.editCursor);
                break;
            }
            case 2: {
                if (this.recording || this.preRecording) {
                    this.stopRecording();
                    break;
                }
                if (!this.previewing) break;
                this.stopPreview();
                break;
            }
            case 3: {
                if (!this.buttonPreview.field_22763) break;
                this.previewButton();
                break;
            }
            case 4: {
                if (!this.buttonRecord.field_22763) break;
                this.recordButton();
            }
        }
    }

    public void method_25420(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        class_4587 stack = guiGraphics.method_51448();
        if (this.previewing || this.recording || this.preRecording) {
            long currentMillis = System.currentTimeMillis();
            long delta = currentMillis - this.lastMillis;
            this.lastMillis = currentMillis;
            this.cumMillis += delta;
            int currentBeat = (int)(this.cumMillis * (long)this.bps) / 1000;
            if (this.preRecording) {
                if (currentBeat > this.oldPreRecordBeat) {
                    for (int i = 0; i < currentBeat - this.oldPreRecordBeat; ++i) {
                        if (this.preRecordPlayTick) {
                            this.preRecordPlayTick = false;
                            this.playMetronomeTick();
                            continue;
                        }
                        this.preRecordPlayTick = true;
                    }
                    if (currentBeat % 8 == 0 && this.cumMillis > 1500L || currentBeat % 4 == 0 && this.cumMillis > 1950L) {
                        this.startRecording();
                    }
                    this.oldPreRecordBeat = currentBeat;
                }
            } else {
                int oldPreviewCursor = this.previewCursor;
                this.previewCursor = this.previewCursorStart + currentBeat;
                if (this.previewCursor > this.sliderPosition + 91 - 12 && (this.lengthBeats > this.sliderPosition + 91 || this.recording)) {
                    this.setSliderPos(this.previewCursor - 24);
                }
                if (oldPreviewCursor != this.previewCursor) {
                    if (!this.recording && (this.previewCursor > this.lengthBeats || this.editCursorEnd != this.editCursor && this.previewCursor > this.editCursorEnd + 1)) {
                        this.stopPreview();
                    } else {
                        this.previewStarted = true;
                        this.playPreviewSound(oldPreviewCursor, this.previewCursor);
                    }
                    if (this.recording) {
                        for (NoteEvent note : this.recordingNotes) {
                            if (this.previewCursor - note.time <= 1) continue;
                            note.length = (byte)(note.length + (byte)(this.previewCursor - oldPreviewCursor));
                            if (note.length <= 60) continue;
                            note.length = (byte)60;
                        }
                    }
                }
            }
        }
        guiGraphics.method_25302(NOTE_GUI_LEFT_TEXTURE, this.noteImageLeftX, this.noteImageY + 7, 175, 51, 81, 205);
        guiGraphics.method_25302(NOTE_GUI_TEXTURES, this.noteImageX, this.noteImageY, 0, 44, 256, 210);
        if (this.gettingSigned) {
            this.drawSigning(guiGraphics);
        } else {
            int x;
            int y;
            int i;
            int x1 = this.noteImageLeftX + 44;
            int x2 = this.noteImageLeftX + 316;
            for (i = 0; i < 4; ++i) {
                int y1 = this.noteImageY + 39 + (4 - i) * 12 * 3;
                int y2 = this.noteImageY + 39 + (3 - i) * 12 * 3;
                guiGraphics.method_25294(x1, y1, x2, y2, OCTAVE_COLORS_TRANS[i + this.currentOctavePos]);
            }
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 6; ++j) {
                    y = this.noteImageY + 182 - i * 36 - j * 6;
                    guiGraphics.method_25294(x1, y - 1, x2 + 1, y, OCTAVE_COLORS[i + this.currentOctavePos]);
                }
            }
            for (i = 0; i < 4; ++i) {
                x = x1 - 24;
                y = this.noteImageY + 182 - 18 - i * 36;
                if (currentOctave == i + this.currentOctavePos) {
                    guiGraphics.method_25294(x - 10, y - 4, x + 10, y + 12, -1426063446);
                }
                guiGraphics.method_25300(this.field_22793, OCTAVE_NAMES[i + this.currentOctavePos], x, y, OCTAVE_COLORS[i + this.currentOctavePos]);
            }
            if (this.highlightInterval > 1) {
                for (i = this.sliderPosition; i < this.sliderPosition + 91; ++i) {
                    x = (i - this.sliderPosition) * 3 + this.noteImageLeftX + 44 + 1;
                    if (i % this.highlightInterval != 0) continue;
                    guiGraphics.method_25294(x, this.noteImageY + 39 - 1, x + 1, this.noteImageY + 182 + 3, -7833238);
                }
                stack.method_22903();
                stack.method_22905(0.5f, 0.5f, 0.5f);
                for (i = this.sliderPosition; i < this.sliderPosition + 91; ++i) {
                    if (i % this.highlightInterval != 0) continue;
                    x = (i - this.sliderPosition) * 3 + this.noteImageLeftX + 44;
                    y = this.noteImageY + 39 - 5;
                    String name = Integer.toString(i / this.highlightInterval + 1);
                    int w = this.field_22793.method_1727(name);
                    guiGraphics.method_51433(this.field_22793, name, (int)(((float)x - ((float)w - 6.0f) / 4.0f) * 2.0f), y * 2, -12303360, false);
                }
                stack.method_22909();
            }
            guiGraphics.method_51433(this.field_22793, "M:", this.noteImageLeftX + 261 + 14, this.noteImageY + 23 + 2, -16777216, false);
            guiGraphics.method_51433(this.field_22793, this.highlightInterval > 1 ? Integer.toString(this.highlightInterval) : "-", this.noteImageLeftX + 261 + 22, this.noteImageY + 23 + 2, -16777216, false);
            guiGraphics.method_51433(this.field_22793, "Tempo", this.noteImageLeftX + 245 - 30, this.noteImageY + 12, -16777216, false);
            guiGraphics.method_51433(this.field_22793, Integer.toString(this.bpm), this.noteImageLeftX + 245 - 30, this.noteImageY + 12 + 10, -16777216, false);
            this.drawCursor(guiGraphics, this.editCursor, -5627358);
            if (!this.isSigned) {
                if (this.editCursor != this.editCursorEnd) {
                    this.drawCursor(guiGraphics, this.editCursorEnd, -5627358);
                    this.drawSelectionRect(guiGraphics);
                }
            } else {
                int k = this.field_22793.method_1727(this.noteTitle);
                guiGraphics.method_51433(this.field_22793, this.noteTitle, (int)((float)this.noteImageLeftX + (float)(337 - k) / 2.0f), this.noteImageY + 14, -6750208, false);
                if (this.selfSigned) {
                    this.drawCursor(guiGraphics, this.editCursor, -5627358);
                    if (this.editCursor != this.editCursorEnd) {
                        this.drawCursor(guiGraphics, this.editCursorEnd, -5627358);
                        this.drawSelectionRect(guiGraphics);
                    }
                }
            }
            if (!this.neighborsHidden) {
                for (ArrayList<NoteEvent> nn : this.neighborNotes) {
                    for (NoteEvent event : nn) {
                        this.drawNote(guiGraphics, event, true);
                    }
                }
            }
            for (NoteEvent note : this.notes) {
                this.drawNote(guiGraphics, note, false);
            }
        }
        if (this.previewStarted) {
            int i = this.previewCursor - 1;
            this.drawCursor(guiGraphics, i, -5601246);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.buttonHelp.method_49606()) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"note.helpTooltip"), mouseX, mouseY);
        }
        if (this.helpOn) {
            int x = this.noteImageLeftX + 15;
            int y = this.noteImageY;
            guiGraphics.method_25294(x, y, x + 315, y + 220, -298634445);
            stack.method_22903();
            stack.method_22905(1.2f, 1.2f, 1.2f);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"note.helpText0"), (int)((float)(x + 10) / 1.2f), (int)((float)(y + 5) / 1.2f), -1118703, false);
            stack.method_22909();
            for (int i = 1; i <= 19; ++i) {
                class_5250 leftSide = class_2561.method_43471((String)("note.helpText" + i + "a"));
                class_5250 rightSide = class_2561.method_43471((String)("note.helpText" + i + "b"));
                guiGraphics.method_51439(this.field_22793, (class_2561)leftSide, x + 10, y + 10 + 10 * i, -1118703, false);
                guiGraphics.method_51439(this.field_22793, (class_2561)rightSide, x + 10 + this.field_22793.method_27525((class_5348)leftSide), y + 10 + 10 * i, -1118482, false);
            }
        } else if (this.buttonHideNeighbors.method_49606()) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"note.toggleTooltip"), mouseX, mouseY);
        } else if (this.buttonLockPrevIns.method_49606()) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"note.lockTooltip"), mouseX, mouseY);
        } else if (this.buttonPreview.method_49606()) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"note.previewTooltip"), mouseX, mouseY);
        } else if (this.buttonRecord.method_49606()) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"note.recordTooltip"), mouseX, mouseY);
        } else if (this.bpmDown.method_49606() || this.bpmUp.method_49606()) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"note.tempoTooltip"), mouseX, mouseY);
        } else if (this.hlDown.method_49606() || this.hlUp.method_49606()) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"note.measureTooltip"), mouseX, mouseY);
        } else if (this.sliderSheetVolume.method_49606()) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"note.sheetVolumeTooltip"), mouseX, mouseY);
        } else if (this.sliderNoteVolume.method_49606()) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"note.noteVolumeTooltip"), mouseX, mouseY);
        }
    }

    private void drawSelectionRect(class_332 guiGraphics) {
        if (this.inScreen(this.editCursor) || this.inScreen(this.editCursorEnd) || this.editCursor < this.sliderPosition && this.editCursorEnd >= this.sliderPosition + 91) {
            int selectionColor = -2011028822;
            int timeDrawBeginning = Math.max(this.editCursor - this.sliderPosition, 0);
            int timeDrawEnd = Math.min(this.editCursorEnd - this.sliderPosition, 91);
            int x1 = this.noteToPixelX(timeDrawBeginning);
            int x2 = this.noteToPixelX(timeDrawEnd);
            int y1 = this.noteImageY + 39;
            int y2 = y1 + 144;
            guiGraphics.method_25294(x1 + 1, y1, x2 + 2, y2, -2011028822);
        }
    }

    private boolean inScreen(int time) {
        return time >= this.sliderPosition && time < this.sliderPosition + 91;
    }

    private void drawNote(class_332 guiGraphics, NoteEvent event, boolean isNeighbor) {
        int octave = GuiMusicSheet.octaveFromNote(event.note);
        if (octave >= this.currentOctavePos && octave < this.currentOctavePos + 4 && (this.inScreen(event.time) || this.inScreen(event.time + event.length))) {
            int timeDrawEnd;
            int xEnd;
            int timeDrawBeginning = Math.max(event.time - this.sliderPosition, 0);
            int xBegin = this.noteImageLeftX + 44 + timeDrawBeginning * 3;
            if (xBegin == (xEnd = this.noteImageLeftX + 44 + (timeDrawEnd = Math.min(event.time - this.sliderPosition + event.length, 91)) * 3)) {
                return;
            }
            int xFillBegin = timeDrawBeginning == event.time - this.sliderPosition ? xBegin + 1 : xBegin;
            int xFillEnd = timeDrawEnd == event.time - this.sliderPosition + event.length ? xEnd - 1 : xEnd;
            int y = this.noteImageY + 39 + (47 - event.note + 21) * 3 + this.currentOctavePos * 36;
            int outlineColor = event == this.currentlyAddedNote || isNeighbor ? 0x77000000 : -16777216;
            int red = event.volume >= 64 ? 255 : event.volume * 4;
            int green = event.volume < 64 ? 255 : 255 - event.volume * 4;
            int fillColor = (event == this.currentlyAddedNote || isNeighbor ? 0x77000000 : -16777216) | red << 16 | green << 8;
            guiGraphics.method_25294(xBegin, y, xEnd, y + 3, outlineColor);
            guiGraphics.method_25294(xFillBegin, y + 1, xFillEnd, y + 2, fillColor);
        }
    }

    private void setNeighborNextNodeIDs() {
        if (!this.neighborsHidden) {
            block0: for (int i = 0; i < this.neighborNotes.size(); ++i) {
                ArrayList<NoteEvent> nn = this.neighborNotes.get(i);
                for (int j = 0; j < nn.size(); ++j) {
                    if (nn.get((int)j).time < this.previewCursor) continue;
                    this.neighborPreviewNextNoteIDs.set(i, j);
                    continue block0;
                }
            }
        }
        this.previewCursorStart = this.editCursor;
        this.previewStarted = false;
    }

    private void startPreview() {
        this.previewCursor = this.editCursor;
        boolean noteFound = false;
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get((int)i).time < this.previewCursor) continue;
            this.previewNextNoteID = i;
            noteFound = true;
            break;
        }
        if (noteFound) {
            this.setNeighborNextNodeIDs();
            this.previewing = true;
            this.cumMillis = 0L;
            this.lastMillis = System.currentTimeMillis();
            this.buttonPreview.setTexStarts(240, 0);
            if (!this.inScreen(this.previewCursorStart)) {
                this.setSliderPos(this.previewCursorStart);
            }
        }
        this.updateButtons();
    }

    private void startPreRecording() {
        this.preRecording = true;
        this.previewCursor = this.editCursor;
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get((int)i).time < this.previewCursor) continue;
            this.previewNextNoteID = i;
            break;
        }
        this.setNeighborNextNodeIDs();
        this.cumMillis = 0L;
        this.oldPreRecordBeat = 0;
        this.lastMillis = System.currentTimeMillis();
        this.buttonRecord.setTexStarts(240, 0);
        if (!this.inScreen(this.previewCursorStart)) {
            this.setSliderPos(this.previewCursorStart);
        }
        this.updateButtons();
    }

    private void startRecording() {
        this.preRecording = false;
        this.previewing = true;
        this.recording = true;
        this.cumMillis = 0L;
        this.lastMillis = System.currentTimeMillis();
        this.buttonRecord.setTexStarts(240, 0);
        if (!this.inScreen(this.previewCursorStart)) {
            this.setSliderPos(this.previewCursorStart);
        }
        this.updateButtons();
    }

    private void stopRecording() {
        this.preRecording = false;
        this.previewing = false;
        this.recording = false;
        this.previewStarted = false;
        this.buttonRecord.setTexStarts(176, 0);
        this.updateLength();
        this.recordingNotes.clear();
        this.updateButtons();
    }

    private void setSliderPos(int time) {
        time = Math.min(Math.max(time, 0), this.maxSliderPosition);
        this.sliderTime.setValue((float)time / (float)this.maxSliderPosition);
        this.sliderTime.method_25344();
    }

    private void stopPreview() {
        this.previewing = false;
        this.previewStarted = false;
        this.buttonPreview.setTexStarts(224, 0);
        this.updateButtons();
    }

    private void updateLength() {
        this.updateLength(true);
    }

    private void updateLength(boolean updateSliderPos) {
        this.lengthBeats = 0;
        if (!this.notes.isEmpty()) {
            for (NoteEvent event : this.notes) {
                this.lengthBeats = (short)(event.time + event.length) > this.lengthBeats ? (short)(event.time + event.length) : this.lengthBeats;
            }
            if (updateSliderPos) {
                int oldMaxSliderPos = this.maxSliderPosition;
                this.maxSliderPosition = Math.min(Math.max(this.lengthBeats + 91, 680), 32000);
                if (this.maxSliderPosition > oldMaxSliderPos) {
                    this.setSliderPos(this.sliderPosition);
                } else if (this.maxSliderPosition < oldMaxSliderPos) {
                    this.setSliderPos(this.maxSliderPosition - 91);
                }
            }
        }
    }

    public boolean method_25402(double dmouseX, double dmouseY, int mouseButton) {
        block5: {
            int my;
            int mx;
            block6: {
                int i;
                int note;
                int time;
                int mouseY;
                int mouseX;
                block7: {
                    boolean composing;
                    if (this.helpOn) {
                        this.helpOn = false;
                        return true;
                    }
                    if (super.method_25402(dmouseX, dmouseY, mouseButton)) {
                        this.method_25398(true);
                        return true;
                    }
                    mouseX = (int)Math.round(dmouseX);
                    mouseY = (int)Math.round(dmouseY);
                    boolean viewingSelfSigned = this.isSigned && this.selfSigned;
                    boolean bl = composing = !this.isSigned && !this.gettingSigned;
                    if (!this.gettingSigned && mouseButton == 1 && this.validClick(mx = mouseX - this.noteImageLeftX, my = mouseY - this.noteImageY)) {
                        this.editCursorEnd = this.editCursor = (mx - 44) / 3 + this.sliderPosition;
                        this.selectionStart = this.editCursor;
                    }
                    if (viewingSelfSigned && mouseButton == 0) {
                        this.editCursorEnd = this.editCursor;
                    }
                    if (!composing) break block5;
                    mx = mouseX - this.noteImageLeftX;
                    my = mouseY - this.noteImageY;
                    if (!this.validClick(mx, my)) break block6;
                    int nrx = mx - 44;
                    int nry = my - 39;
                    time = nrx / 3 + this.sliderPosition;
                    note = 47 - nry / 3 + 21 + this.currentOctavePos * 12;
                    if (mouseButton != 0) break block7;
                    this.addNote((byte)note, (short)time);
                    this.dirtyFlag.hasNotes = true;
                    this.dirtyFlag.hasLength = true;
                    this.editCursorEnd = this.editCursor;
                    break block5;
                }
                if (mouseButton != 2 || (i = this.findNote((byte)note, (short)time)) < 0) break block5;
                NoteEvent event = this.notes.get(i);
                this.noteEditBox.appear(mouseX, mouseY, event);
                break block5;
            }
            for (int i = 0; i < 4; ++i) {
                int x = 20;
                int y = 164 - i * 36;
                if (mx < 10 || mx > 30 || my < y - 4 || my > y + 12) continue;
                this.midiHandler.currentOctave = currentOctave = this.currentOctavePos + i;
                if (!this.recording) break;
                this.recordingNotes.clear();
                break;
            }
        }
        return true;
    }

    private void pushUndo() {
        if (this.undoStack.size() >= 16) {
            this.undoStack.removeLast();
        }
        ArrayList<NoteEvent> stackNotes = new ArrayList<NoteEvent>(this.notes.size());
        for (NoteEvent note : this.notes) {
            stackNotes.add(new NoteEvent(note));
        }
        this.undoStack.push(stackNotes);
    }

    private void addNote(byte note, short time) {
        this.addNote(note, time, true);
    }

    private void addNote(byte note, short time, boolean pushUndo) {
        int i;
        if (pushUndo) {
            this.pushUndo();
        }
        if ((i = this.findNote(note, time)) < 0) {
            this.addNote(note, time, (byte)(127.0f * brushVolume));
        } else {
            this.notes.remove(i);
        }
        this.updateLength();
    }

    private void addNote(byte note, short time, byte volume) {
        NoteEvent newEvent;
        this.currentlyAddedNote = newEvent = new NoteEvent(note, time, volume, 1);
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get((int)i).time <= time) continue;
            this.notes.add(i, newEvent);
            return;
        }
        this.notes.add(newEvent);
    }

    private void addRecordingNote(NoteEvent noteEvent) {
        for (int i = 0; i < this.notes.size(); ++i) {
            if (this.notes.get((int)i).time <= noteEvent.time) continue;
            this.notes.add(i, noteEvent);
            this.recordingNotes.add(noteEvent);
            return;
        }
        this.notes.add(noteEvent);
        this.recordingNotes.add(noteEvent);
    }

    private void finishAddingNote() {
        if (this.currentlyAddedNote == null) {
            return;
        }
        this.playSound(this.currentlyAddedNote, this.previewInstrument);
        this.currentlyAddedNote = null;
        this.updateLength();
    }

    private int findNote(byte note, short time) {
        for (int i = this.notes.size() - 1; i >= 0; --i) {
            NoteEvent event = this.notes.get(i);
            if (event.time > time || event.endTime() < time || event.note != note) continue;
            return i;
        }
        return -1;
    }

    public boolean method_25403(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        class_364 focused = this.method_25399();
        if (focused != null && this.method_25397()) {
            focused.method_25403(posX, posY, mouseButton, deltaX, deltaY);
            return true;
        }
        if (this.tickCount < 10) {
            return super.method_25403(posX, posY, mouseButton, deltaX, deltaY);
        }
        int mouseX = (int)Math.round(posX);
        int mouseY = (int)Math.round(posY);
        int mx = mouseX - this.noteImageLeftX;
        int my = mouseY - this.noteImageY;
        switch (mouseButton) {
            case 0: {
                int time;
                if (this.currentlyAddedNote == null || !this.validClick(mx, my) || this.currentlyAddedNote.time >= (time = (mx - 44) / 3 + this.sliderPosition) || time - this.currentlyAddedNote.time > 60) break;
                this.currentlyAddedNote.length = (byte)(time - this.currentlyAddedNote.time);
                break;
            }
            case 1: {
                if (!this.validClick(mx, my)) break;
                int noteX = (mx - 44) / 3 + this.sliderPosition;
                if (this.selectionStart > noteX) {
                    this.editCursor = noteX;
                    break;
                }
                this.editCursorEnd = noteX;
                break;
            }
        }
        return true;
    }

    public boolean method_25406(double posX, double posY, int mouseButton) {
        this.method_25398(false);
        if (this.noteEditBox.field_22763) {
            this.noteEditBox.method_25406(posX, posY, mouseButton);
            return true;
        }
        if (mouseButton == 0) {
            this.finishAddingNote();
        }
        return true;
    }

    private void putSpace(int x) {
        if (x == 31999) {
            return;
        }
        this.addEditCursor(1);
        if (this.lengthBeats == 0 || this.lengthBeats <= x) {
            return;
        }
        this.pushUndo();
        this.dirtyFlag.hasNotes = true;
        this.dirtyFlag.hasLength = true;
        for (int i = this.notes.size() - 1; i >= 0; --i) {
            NoteEvent event = this.notes.get(i);
            if (event.time <= x) continue;
            event.time = (short)(event.time + 1);
            if (event.time + event.length <= 32000) continue;
            this.notes.remove(i);
        }
        this.updateLength();
    }

    private void encodeToClipboard() {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        ArrayList<NoteEvent> toBeCopied = new ArrayList<NoteEvent>();
        for (NoteEvent event : this.notes) {
            if (event.time < this.editCursor || event.time > this.editCursorEnd || event.endTime() < this.editCursor || event.endTime() > this.editCursorEnd) continue;
            toBeCopied.add(event);
        }
        buffer.method_52997(50);
        buffer.method_53002(this.editCursorEnd - this.editCursor);
        buffer.method_53002(toBeCopied.size());
        for (NoteEvent event : toBeCopied) {
            event.time = (short)(event.time - (short)this.editCursor);
            event.encodeToBuffer(buffer);
            event.time = (short)(event.time + (short)this.editCursor);
        }
        int index = buffer.writerIndex();
        byte[] bytes = new byte[index];
        buffer.method_52952(0, bytes);
        String encodeBytes = Base64.getEncoder().encodeToString(bytes);
        GLFW.glfwSetClipboardString((long)class_310.method_1551().method_22683().method_4490(), (CharSequence)encodeBytes);
        this.editCursorEnd = this.editCursor;
    }

    private void decodeFromClipboard(boolean pushBack) {
        String encodedMusic = GLFW.glfwGetClipboardString((long)class_310.method_1551().method_22683().method_4490());
        if (encodedMusic != null && !encodedMusic.isEmpty()) {
            List<NoteEvent> toBePasted;
            byte[] byteArray;
            try {
                byteArray = Base64.getDecoder().decode(encodedMusic);
            }
            catch (IllegalArgumentException ex) {
                return;
            }
            int length = 0;
            if (byteArray[0] != 50) {
                for (byte b : byteArray) {
                    if (b >= 0 && b <= 48) continue;
                    Mod.LOGGER.info("User tried to copy invalid data into music: {}", (Object)b);
                    return;
                }
                toBePasted = ItemMusicSheet.oldMusicToNotes(byteArray);
                if (!toBePasted.isEmpty()) {
                    Object object = toBePasted.iterator();
                    while (object.hasNext()) {
                        NoteEvent event = (NoteEvent)object.next();
                        length = (short)(event.time + event.length) > length ? (int)(event.time + event.length) : length;
                    }
                }
            } else {
                class_2540 buffer = new class_2540(Unpooled.copiedBuffer((byte[])byteArray));
                buffer.readByte();
                length = buffer.readInt() + 1;
                int count = buffer.readInt();
                toBePasted = new ArrayList<NoteEvent>(count);
                for (int i = 0; i < count; ++i) {
                    toBePasted.add(NoteEvent.fromBuffer(buffer));
                }
            }
            this.pushUndo();
            if (pushBack) {
                for (NoteEvent event : this.notes) {
                    if (event.time < this.editCursor) continue;
                    event.time = (short)(event.time + (short)length);
                }
            }
            for (NoteEvent event : toBePasted) {
                event.time = (short)(event.time + (short)this.editCursor);
                this.notes.add(event);
            }
            NoteEvent.sortNotes(this.notes);
            NoteEvent.removeDuplicates(this.notes);
            this.updateLength();
            this.editCursor += length;
            this.editCursorEnd = this.editCursor;
            this.dirtyFlag.hasNotes = true;
            this.dirtyFlag.hasLength = true;
        }
    }

    private void delAtCursor(int x) {
        boolean doSort = false;
        for (int i = this.notes.size() - 1; i >= 0; --i) {
            NoteEvent event = this.notes.get(i);
            short start = event.time;
            int end = start + event.length;
            if (start > x) {
                event.time = (short)(event.time - 1);
                doSort = true;
                continue;
            }
            if (start < x && end > x) {
                event.length = (byte)(event.length - 1);
                continue;
            }
            if (start != x) continue;
            if (event.length == 1) {
                this.notes.remove(i);
                continue;
            }
            event.length = (byte)(event.length - 1);
        }
        if (doSort) {
            NoteEvent.sortNotes(this.notes);
        }
        this.updateLength();
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        this.method_25395(null);
        super.method_16803(keyCode, scanCode, modifiers);
        int firstScanCode = GLFW.glfwGetKeyScancode((int)81);
        int lastScanCode = firstScanCode + 11;
        if (scanCode >= firstScanCode && scanCode <= lastScanCode && currentOctave >= 0 && this.recording) {
            this.endSound(IItemInstrument.noteToId((byte)(scanCode - firstScanCode + 21 + 12 * currentOctave)));
        }
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean viewingSelfSigned;
        this.method_25395(null);
        super.method_25404(keyCode, scanCode, modifiers);
        boolean bl = viewingSelfSigned = this.isSigned && this.selfSigned;
        if (viewingSelfSigned) {
            if (keyCode == 67 && (modifiers & 2) == 2) {
                this.encodeToClipboard();
            }
            if (keyCode == 65 && (modifiers & 2) == 2) {
                this.editCursor = 0;
                this.editCursorEnd = this.lengthBeats - 1;
            }
        }
        if (!this.isSigned) {
            if (this.gettingSigned) {
                switch (keyCode) {
                    case 259: {
                        if (this.noteTitle.isEmpty()) break;
                        this.noteTitle = this.noteTitle.substring(0, this.noteTitle.length() - 1);
                        this.updateButtons();
                        break;
                    }
                    case 257: {
                        if (this.noteTitle.isEmpty()) break;
                        this.dirtyFlag.hasSigned = true;
                        this.dirtyFlag.hasTitle = true;
                        this.isSigned = true;
                        if (this.field_22787 == null) break;
                        this.field_22787.method_1507(null);
                        break;
                    }
                }
                return true;
            }
            int x = this.editCursor;
            boolean resetEditCursorEnd = true;
            switch (keyCode) {
                case 261: {
                    if (this.lengthBeats == 0 || this.lengthBeats <= x) break;
                    this.pushUndo();
                    this.dirtyFlag.hasNotes = true;
                    this.dirtyFlag.hasLength = true;
                    if (this.editCursorEnd == x) {
                        this.delAtCursor(x);
                        break;
                    }
                    this.deleteSelected();
                    this.updateLength();
                    break;
                }
                case 259: {
                    if (this.editCursorEnd == x) {
                        if (x == 0) break;
                        if (this.lengthBeats == 0 || this.lengthBeats < x) {
                            this.addEditCursor(-1);
                            break;
                        }
                        this.pushUndo();
                        this.dirtyFlag.hasNotes = true;
                        this.dirtyFlag.hasLength = true;
                        this.addEditCursor(-1);
                        this.delAtCursor(this.editCursor);
                        break;
                    }
                    this.pushUndo();
                    this.dirtyFlag.hasNotes = true;
                    this.dirtyFlag.hasLength = true;
                    this.deleteSelected();
                    this.updateLength();
                    break;
                }
                case 32: {
                    this.putSpace(x - 1);
                    break;
                }
                case 262: {
                    this.addEditCursor(1);
                    if (this.editCursor <= 31999) break;
                    this.setEditCursor(31999);
                    break;
                }
                case 263: {
                    this.addEditCursor(-1);
                    if (this.editCursor >= 0) break;
                    this.setEditCursor(0);
                    break;
                }
                case 257: {
                    this.previewButton();
                    break;
                }
                case 342: 
                case 346: {
                    this.recordButton();
                    break;
                }
                case 67: {
                    if ((modifiers & 2) != 2) break;
                    this.encodeToClipboard();
                    break;
                }
                case 86: {
                    if ((modifiers & 2) != 2) break;
                    this.decodeFromClipboard((modifiers & 1) != 1);
                    break;
                }
                case 72: {
                    this.toggleHelp();
                    break;
                }
                case 90: {
                    if ((modifiers & 2) != 2 || this.noteEditBox.field_22763 || this.undoStack.isEmpty()) break;
                    this.notes = this.undoStack.pop();
                    this.updateLength(false);
                    break;
                }
                case 65: {
                    if ((modifiers & 2) == 2) {
                        this.editCursor = 0;
                        this.editCursorEnd = this.lengthBeats - 1;
                        resetEditCursorEnd = false;
                        break;
                    }
                    if (this.editCursor == this.editCursorEnd) {
                        if (--currentOctave < -2) {
                            currentOctave = -2;
                        }
                        this.midiHandler.currentOctave = currentOctave;
                        if (!this.recording) break;
                        this.recordingNotes.clear();
                        break;
                    }
                    boolean changed = false;
                    for (NoteEvent event : this.notes) {
                        if (event.endTime() < this.editCursor || event.time > this.editCursorEnd || IItemInstrument.noteToId(event.note) / 12 <= 0) continue;
                        if (!changed) {
                            this.pushUndo();
                            this.dirtyFlag.hasNotes = true;
                            this.dirtyFlag.hasLength = true;
                            changed = true;
                        }
                        event.note = (byte)(event.note - 12);
                    }
                    resetEditCursorEnd = false;
                    break;
                }
                case 83: {
                    if (this.editCursor == this.editCursorEnd) {
                        if (++currentOctave > 7) {
                            currentOctave = 7;
                        }
                        this.midiHandler.currentOctave = currentOctave;
                        if (!this.recording) break;
                        this.recordingNotes.clear();
                        break;
                    }
                    boolean changed = false;
                    for (NoteEvent event : this.notes) {
                        if (event.endTime() < this.editCursor || event.time > this.editCursorEnd || IItemInstrument.noteToId(event.note) / 12 >= 7) continue;
                        if (!changed) {
                            this.pushUndo();
                            this.dirtyFlag.hasNotes = true;
                            this.dirtyFlag.hasLength = true;
                            changed = true;
                        }
                        event.note = (byte)(event.note + 12);
                    }
                    resetEditCursorEnd = false;
                    break;
                }
                case 341: 
                case 345: {
                    resetEditCursorEnd = false;
                    break;
                }
                default: {
                    int firstScanCode = GLFW.glfwGetKeyScancode((int)81);
                    int lastScanCode = firstScanCode + 11;
                    if (scanCode < firstScanCode || scanCode > lastScanCode || currentOctave < 0) break;
                    if (this.recording) {
                        this.startSound(IItemInstrument.noteToId((byte)(scanCode - firstScanCode + 21 + 12 * currentOctave)), (byte)100);
                        break;
                    }
                    this.putSpace(x - 1);
                    this.addNote((byte)(scanCode - firstScanCode + 21 + 12 * currentOctave), (short)x, false);
                    this.finishAddingNote();
                }
            }
            if (resetEditCursorEnd) {
                this.editCursorEnd = this.editCursor;
            }
        }
        return true;
    }

    private void deleteSelected() {
        boolean doSort = false;
        int cutLen = this.editCursorEnd - this.editCursor;
        for (int i = this.notes.size() - 1; i >= 0; --i) {
            NoteEvent event = this.notes.get(i);
            short start = event.time;
            short end = event.endTime();
            if (start >= this.editCursor && end <= this.editCursorEnd) {
                this.notes.remove(i);
                continue;
            }
            if (start < this.editCursor && end >= this.editCursor && end <= this.editCursorEnd) {
                event.length = (byte)(this.editCursor - start);
                continue;
            }
            if (start >= this.editCursor && start <= this.editCursorEnd) {
                event.length = (byte)(end - this.editCursorEnd);
                event.time = (short)(this.editCursor + 1);
                doSort = true;
                continue;
            }
            if (start < this.editCursor && end > this.editCursorEnd) {
                event.length = (byte)(this.editCursor - start);
                continue;
            }
            if (start <= this.editCursorEnd) continue;
            event.time = (short)(event.time - (short)cutLen);
            doSort = true;
        }
        if (doSort) {
            NoteEvent.sortNotes(this.notes);
        }
    }

    private void setEditCursor(int x) {
        if (this.editCursor != this.editCursorEnd) {
            this.editCursor = x;
        } else {
            this.editCursor = x;
            this.editCursorEnd = x;
        }
    }

    private void addEditCursor(int x) {
        this.setEditCursor(this.editCursor + x);
    }

    public boolean method_25400(char typedChar, int something) {
        super.method_25400(typedChar, something);
        if (!this.isSigned) {
            if (this.gettingSigned && this.noteTitle.length() < 16 && class_3544.method_57175((char)typedChar)) {
                this.noteTitle = this.noteTitle + typedChar;
                this.updateButtons();
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double x, double y, double scrollX, double scrollY) {
        if (scrollY != 0.0) {
            if (scrollY > 0.0) {
                this.octaveUp.method_25354(class_310.method_1551().method_1483());
                this.octaveUp.method_25306();
            } else if (scrollY < 0.0) {
                this.octaveDown.method_25354(class_310.method_1551().method_1483());
                this.octaveDown.method_25306();
            }
            return true;
        }
        return super.method_25401(x, y, scrollX, scrollY);
    }

    public void method_25432() {
        if (this.dirtyFlag.hasAny()) {
            if (this.recording) {
                this.stopRecording();
            }
            if (this.dirtyFlag.hasNotes || this.dirtyFlag.hasLength) {
                ++this.version;
                this.dirtyFlag.hasVersion = true;
                MusicManagerClient.setMusicData(this.id, this.version, this.notes);
            }
            try {
                MusicUpdatePacket pack = MusicUpdatePacket.create(this.dirtyFlag, this.notes, this.lengthBeats, this.bps, this.volume, this.isSigned, this.noteTitle, (byte)this.previewInstrument, this.prevInsLocked, this.id, this.version, this.highlightInterval);
                ClientStuff.sendToServer(pack);
            }
            catch (ImportMusicSendPacket.NotesTooLargeException e) {
                int partsCount = (int)Math.ceil((double)this.notes.size() / 5000.0);
                try {
                    MusicUpdatePacket pack = MusicUpdatePacket.create(this.dirtyFlag, null, this.lengthBeats, this.bps, this.volume, this.isSigned, this.noteTitle, (byte)this.previewInstrument, this.prevInsLocked, this.id, this.version, this.highlightInterval);
                    NotesPartAckFromServerPacketHandler.addCallback(this.id, () -> ClientStuff.sendToServer(pack));
                    for (int i = 0; i < partsCount; ++i) {
                        List<NoteEvent> part = this.notes.subList(i * 5000, Math.min((i + 1) * 5000, this.notes.size()));
                        ClientStuff.sendToServer(new SendNotesPartToServerPacket(this.id, partsCount, i, part));
                    }
                }
                catch (ImportMusicSendPacket.NotesTooLargeException ex) {
                    Mod.LOGGER.error("Could not send partial notes to server:", (Throwable)ex);
                }
            }
        }
        if (this.midiHandler != null) {
            this.midiHandler.closeDevices();
        }
        if (SoundEvents.CLOSE_SCROLL != null) {
            this.editingPlayer.method_5783(SoundEvents.CLOSE_SCROLL, 1.0f, 0.8f + this.editingPlayer.method_37908().field_9229.method_43057() * 0.4f);
        }
    }

    private boolean validClick(int x, int y) {
        return x <= 316 && x >= 44 && y <= 182 && y >= 39;
    }

    public static class ChangeableImageButton
    extends class_4185 {
        protected final class_2960 resourceLocation;
        protected final int yDiffText;
        protected final int texWidth;
        protected final int texHeight;
        protected int xTexStart;
        protected int yTexStart;

        public ChangeableImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, class_2960 texture, class_4185.class_4241 onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, 256, 256, onClick);
        }

        public ChangeableImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, class_2960 texture, int texWidth, int texHeight, class_4185.class_4241 onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, texWidth, texHeight, onClick, (class_2561)class_2561.method_43473());
        }

        public ChangeableImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, class_2960 texture, int texWidth, int texHeight, class_4185.class_4241 onClick, class_2561 message) {
            super(x, y, width, height, message, onClick, class_4185.field_40754);
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.xTexStart = xTexStart;
            this.yTexStart = yTexStart;
            this.yDiffText = yDiffText;
            this.resourceLocation = texture;
        }

        public void setTexStarts(int x, int y) {
            this.xTexStart = x;
            this.yTexStart = y;
        }

        protected int preRender() {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
            GlStateManager._disableDepthTest();
            int yTexStartNew = this.yTexStart;
            if (this.field_22762 && this.field_22763) {
                yTexStartNew += this.yDiffText;
            }
            return yTexStartNew;
        }

        protected void postRender() {
            GlStateManager._enableDepthTest();
        }

        public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            int yTexStartNew = this.preRender();
            guiGraphics.method_25290(this.resourceLocation, this.method_46426(), this.method_46427(), (float)this.xTexStart, (float)yTexStartNew, this.field_22758, this.field_22759, this.texWidth, this.texHeight);
            this.postRender();
        }
    }

    public class LockImageButton
    extends ChangeableImageButton {
        public LockImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, class_2960 texture, class_4185.class_4241 onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, 256, 256, onClick);
        }

        public LockImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, class_2960 texture, int texWidth, int texHeight, class_4185.class_4241 onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, texWidth, texHeight, onClick, (class_2561)class_2561.method_43473());
        }

        public LockImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, class_2960 texture, int texWidth, int texHeight, class_4185.class_4241 onClick, class_2561 message) {
            super(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, texWidth, texHeight, onClick, message);
        }

        @Override
        public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            int yTexStartNew = this.preRender();
            guiGraphics.method_25290(this.resourceLocation, this.method_46426(), this.method_46427(), (float)this.xTexStart, (float)yTexStartNew, this.field_22758, this.field_22759, this.texWidth, this.texHeight);
            if (GuiMusicSheet.this.prevInsLocked) {
                guiGraphics.method_25290(this.resourceLocation, this.method_46426(), this.method_46427(), 0.0f, (float)this.texHeight - (float)this.field_22759, this.field_22758, this.field_22759, this.texWidth, this.texHeight);
            }
            this.postRender();
        }
    }

    public class NoteEditBox
    extends class_339 {
        public final class_4185 buttonNoteDown;
        public final class_4185 buttonNoteUp;
        public final class_4185 buttonLengthDown;
        public final class_4185 buttonLengthUp;
        public final class_4185 buttonExit;
        public final class_4185 buttonPrev;
        public final BetterSlider sliderVelocity;
        private static final int NOTE_Y = 18;
        private static final int LENGTH_Y = 29;
        private final class_339[] children;
        private static final String[] noteNames = new String[]{"A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#"};
        private static final String[] noteNamesSolfege = new String[]{"La", "La#", "Si", "Do", "Do#", "Re", "Re#", "Mi", "Fa", "Fa#", "Sol", "Sol#"};
        private NoteEvent event;
        private NoteSound previewSound;
        private boolean changed;

        public NoteEditBox(int x, int y, int w, int h, class_2561 msg) {
            super(x, y, w, h, msg);
            this.children = new class_339[7];
            this.sliderVelocity = new BetterSlider(10, 0, 50, 10, (class_2561)class_2561.method_43470((String)"Vol "), (class_2561)class_2561.method_43473(), 0.0, 100.0, 50.0, true){

                @Override
                public void method_25344() {
                    NoteEditBox.this.setChanged();
                    NoteEditBox.this.event.volume = (byte)Math.round(this.field_22753 * 127.0);
                }
            };
            this.buttonNoteDown = class_4185.method_46430((class_2561)class_2561.method_43471((String)GuiMusicSheet.NOTE_LEFT_STR_KEY), button -> {
                if (this.event.note > 0) {
                    this.setChanged();
                    this.event.note = (byte)(this.event.note - 1);
                    this.playPrev();
                }
            }).method_46434(0, 0, 10, 8).method_46431();
            this.buttonNoteUp = class_4185.method_46430((class_2561)class_2561.method_43471((String)GuiMusicSheet.NOTE_RIGHT_STR_KEY), button -> {
                if (this.event.note < 95) {
                    this.setChanged();
                    this.event.note = (byte)(this.event.note + 1);
                    this.playPrev();
                }
            }).method_46434(0, 0, 10, 8).method_46431();
            this.buttonLengthDown = class_4185.method_46430((class_2561)class_2561.method_43471((String)GuiMusicSheet.NOTE_LEFT_STR_KEY), button -> {
                if (this.event.length > 1) {
                    this.setChanged();
                    this.event.length = (byte)(this.event.length - 1);
                    this.playPrev();
                }
            }).method_46434(0, 0, 10, 8).method_46431();
            this.buttonLengthUp = class_4185.method_46430((class_2561)class_2561.method_43471((String)GuiMusicSheet.NOTE_RIGHT_STR_KEY), button -> {
                if (this.event.length < 60) {
                    this.setChanged();
                    this.event.length = (byte)(this.event.length + 1);
                    this.playPrev();
                }
            }).method_46434(0, 0, 10, 8).method_46431();
            this.buttonExit = class_4185.method_46430((class_2561)class_2561.method_43471((String)"note.exitButton"), button -> {
                this.field_22764 = false;
                this.field_22763 = false;
                if (this.previewSound != null && !this.previewSound.method_4793()) {
                    this.previewSound.stopSound();
                }
            }).method_46434(0, 0, 10, 10).method_46431();
            this.buttonPrev = class_4185.method_46430((class_2561)class_2561.method_43471((String)"note.startPreviewButton"), button -> this.playPrev()).method_46434(0, 0, 10, 10).method_46431();
            this.children[0] = this.sliderVelocity;
            this.children[1] = this.buttonNoteDown;
            this.children[2] = this.buttonNoteUp;
            this.children[3] = this.buttonLengthDown;
            this.children[4] = this.buttonLengthUp;
            this.children[5] = this.buttonExit;
            this.children[6] = this.buttonPrev;
        }

        private void setChanged() {
            if (!this.changed) {
                this.changed = true;
                GuiMusicSheet.this.dirtyFlag.hasNotes = true;
                GuiMusicSheet.this.dirtyFlag.hasLength = true;
                GuiMusicSheet.this.pushUndo();
            }
        }

        private void playPrev() {
            if (this.previewSound != null && !this.previewSound.method_4793()) {
                this.previewSound.stopSound();
            }
            this.previewSound = GuiMusicSheet.this.playSound(this.event, GuiMusicSheet.this.previewInstrument);
        }

        public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.field_22764 && this.event != null) {
                guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -1118482);
                class_310 minecraft = class_310.method_1551();
                class_327 font = minecraft.field_1772;
                int noteId = IItemInstrument.noteToId(this.event.note);
                int octave = noteId / 12;
                guiGraphics.method_51433(font, noteNames[noteId % 12] + (noteId % 12 < 3 ? octave : octave + 1), this.method_46426() + 15, this.method_46427() + 18, -2899456, false);
                guiGraphics.method_51433(font, noteNamesSolfege[noteId % 12], this.method_46426() + 35, this.method_46427() + 18, -2899456, false);
                guiGraphics.method_51433(font, this.event.length + (this.event.length == 1 ? " Beat" : " Beats"), this.method_46426() + 15, this.method_46427() + 29, -11968795, false);
                for (class_339 widget : this.children) {
                    widget.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
                }
                if (this.buttonPrev.method_49606()) {
                    guiGraphics.method_51438(font, (class_2561)class_2561.method_43471((String)"note.previewNoteTooltip"), mouseX, mouseY);
                } else if (this.buttonExit.method_49606()) {
                    guiGraphics.method_51438(font, (class_2561)class_2561.method_43471((String)"note.closeNoteTooltip"), mouseX, mouseY);
                }
            }
        }

        public void appear(int x, int y, NoteEvent event) {
            this.changed = false;
            this.method_46421(x);
            this.method_46419(y);
            this.field_22764 = true;
            this.field_22763 = true;
            this.event = event;
            this.sliderVelocity.method_46421(x + 10);
            int sliderY = 41;
            this.sliderVelocity.method_46419(y + sliderY);
            this.sliderVelocity.setValue(event.floatVolume() * 100.0f);
            this.sliderVelocity.method_25344();
            this.buttonNoteDown.method_46421(x + 3);
            this.buttonNoteDown.method_46419(y + 18);
            this.buttonNoteUp.method_46421(x + 59);
            this.buttonNoteUp.method_46419(y + 18);
            this.buttonLengthDown.method_46421(x + 3);
            this.buttonLengthDown.method_46419(y + 29);
            this.buttonLengthUp.method_46421(x + 59);
            this.buttonLengthUp.method_46419(y + 29);
            this.buttonExit.method_46421(x + 59);
            this.buttonExit.method_46419(y + 2);
            this.buttonPrev.method_46421(x + 3);
            this.buttonPrev.method_46419(y + 2);
            this.playPrev();
        }

        public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
            if (this.field_22763 && this.field_22764) {
                if (mouseButton == 2) {
                    this.field_22764 = false;
                    this.field_22763 = false;
                }
                for (class_339 widget : this.children) {
                    if (!(mouseX >= (double)widget.method_46426()) || !(mouseX < (double)(widget.method_46426() + widget.method_25368())) || !(mouseY >= (double)widget.method_46427()) || !(mouseY < (double)(widget.method_46427() + widget.method_25364()))) continue;
                    widget.method_25402(mouseX, mouseY, mouseButton);
                    return true;
                }
                boolean flag = this.method_25361(mouseX, mouseY);
                if (flag) {
                    this.method_25348(mouseX, mouseY);
                } else {
                    this.field_22764 = false;
                    this.field_22763 = false;
                }
                return true;
            }
            return false;
        }

        public boolean method_25403(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
            if (posX >= (double)this.sliderVelocity.method_46426() && posX < (double)(this.sliderVelocity.method_46426() + this.sliderVelocity.method_25368()) && posY >= (double)this.sliderVelocity.method_46427() && posY < (double)(this.sliderVelocity.method_46427() + this.sliderVelocity.method_25364())) {
                this.sliderVelocity.method_25403(posX, posY, mouseButton, deltaX, deltaY);
            }
            return true;
        }

        protected void method_47399(@NotNull class_6382 pNarrationElementOutput) {
            this.method_37021(pNarrationElementOutput);
        }

        public boolean method_25406(double posX, double posY, int mouseButton) {
            this.sliderVelocity.method_25357(posX, posY);
            return true;
        }
    }

    public static enum MidiControl {
        BEGINNING,
        END,
        STOP,
        PREVIEW,
        RECORD;

    }
}

