/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import java.util.ArrayList;
import java.util.function.Consumer;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import net.minecraft.class_310;
import org.apache.logging.log4j.util.Supplier;
import xerca.xercamusic.client.GuiMusicSheet;
import xerca.xercamusic.common.Mod;

public class MidiHandler {
    final ArrayList<MidiDevice> devices = new ArrayList();
    final ArrayList<Transmitter> transmitters = new ArrayList();
    final Consumer<MidiData> noteOnHandler;
    final Consumer<Integer> noteOffHandler;
    final Consumer<GuiMusicSheet.MidiControl> midiControlHandler;
    public volatile int currentOctave;

    public MidiHandler(Consumer<MidiData> noteOnHandler, Consumer<Integer> noteOffHandler, Consumer<GuiMusicSheet.MidiControl> midiControlHandler) {
        MidiDevice.Info[] infos;
        this.noteOnHandler = noteOnHandler;
        this.noteOffHandler = noteOffHandler;
        this.midiControlHandler = midiControlHandler;
        for (MidiDevice.Info info : infos = MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice device = MidiSystem.getMidiDevice(info);
                if (device.getMaxTransmitters() == 0) continue;
                Mod.LOGGER.debug((Object)info);
                device.open();
                Transmitter trans = device.getTransmitter();
                trans.setReceiver(new MidiInputReceiver(device.getDeviceInfo().toString()));
                this.transmitters.add(trans);
                this.devices.add(device);
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = device::getDeviceInfo;
                Mod.LOGGER.debug("{} was opened", supplierArray);
            }
            catch (MidiUnavailableException exception) {
                Mod.LOGGER.debug("Midi unavailable: ", (Throwable)exception);
            }
        }
    }

    public MidiHandler(Consumer<MidiData> noteOnHandler, Consumer<Integer> noteOffHandler) {
        this(noteOnHandler, noteOffHandler, null);
    }

    public void closeDevices() {
        for (Transmitter t : this.transmitters) {
            t.close();
        }
        this.transmitters.clear();
        for (MidiDevice device : this.devices) {
            if (!device.isOpen()) continue;
            device.close();
        }
        this.devices.clear();
    }

    public class MidiInputReceiver
    implements Receiver {
        public static final int NOTE_ON = 144;
        public static final int NOTE_OFF = 128;
        public static final int CONTROL = 176;
        public static final int DATA_RECORD = 107;
        public static final int DATA_PREVIEW = 106;
        public static final int DATA_STOP = 105;
        public static final int DATA_END = 104;
        public static final int DATA_BEGINNING = 103;
        static final float YM = 0.7f;
        static final float B = 0.1836735f;
        public final String name;

        public MidiInputReceiver(String name) {
            this.name = name;
        }

        private static float volumeCurve(float x) {
            return (float)(Math.pow(0.1836735f, x) / -0.8163264989852905 - (double)-1.225f);
        }

        private static void submitAndCheck(Runnable r) {
            class_310.method_1551().method_20493(r).whenComplete((v, t) -> {
                if (t != null) {
                    Mod.LOGGER.error("Midi controller task failed", t);
                }
            });
        }

        @Override
        public void send(MidiMessage msg, long timeStamp) {
            if (msg instanceof ShortMessage) {
                ShortMessage sm = (ShortMessage)msg;
                int command = sm.getCommand();
                if (command == 176 && MidiHandler.this.midiControlHandler != null) {
                    int data = sm.getData1();
                    int value = sm.getData2();
                    if (value == 0) {
                        return;
                    }
                    switch (data) {
                        case 103: {
                            MidiInputReceiver.submitAndCheck(() -> MidiHandler.this.midiControlHandler.accept(GuiMusicSheet.MidiControl.BEGINNING));
                            break;
                        }
                        case 104: {
                            MidiInputReceiver.submitAndCheck(() -> MidiHandler.this.midiControlHandler.accept(GuiMusicSheet.MidiControl.END));
                            break;
                        }
                        case 105: {
                            MidiInputReceiver.submitAndCheck(() -> MidiHandler.this.midiControlHandler.accept(GuiMusicSheet.MidiControl.STOP));
                            break;
                        }
                        case 106: {
                            MidiInputReceiver.submitAndCheck(() -> MidiHandler.this.midiControlHandler.accept(GuiMusicSheet.MidiControl.PREVIEW));
                            break;
                        }
                        case 107: {
                            MidiInputReceiver.submitAndCheck(() -> MidiHandler.this.midiControlHandler.accept(GuiMusicSheet.MidiControl.RECORD));
                            break;
                        }
                        default: {
                            Mod.LOGGER.info("Unhandled midi control {}", (Object)data);
                        }
                    }
                    return;
                }
                int key = sm.getData1() - 21 + 12 * MidiHandler.this.currentOctave;
                int velocity = sm.getData2();
                Mod.LOGGER.debug("Note message {} key: {} vel: {}", (Object)(command == 144 ? "on" : "off"), (Object)key, (Object)velocity);
                if (key < 0 || key > 95) {
                    return;
                }
                if (command == 144 && velocity > 0) {
                    float vel = (float)velocity / 128.0f;
                    float vol = MidiInputReceiver.volumeCurve(vel);
                    MidiInputReceiver.submitAndCheck(() -> MidiHandler.this.noteOnHandler.accept(new MidiData(key, vol)));
                } else if (command == 128 || command == 144 && velocity == 0) {
                    MidiInputReceiver.submitAndCheck(() -> MidiHandler.this.noteOffHandler.accept(key));
                }
            }
        }

        @Override
        public void close() {
        }
    }

    public record MidiData(int noteId, float volume) {
    }
}

