/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import org.apache.logging.log4j.util.Supplier;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.packets.serverbound.MusicDataRequestPacket;

public final class MusicManagerClient {
    static final Map<UUID, MusicManager.MusicData> MUSIC_MAP = new HashMap<UUID, MusicManager.MusicData>();
    static final Map<UUID, Runnable> TASK_MAP = new HashMap<UUID, Runnable>();
    static final String CACHE_DIR = "music_sheets/.cache/";

    public static void load() {
        File[] directoryListing;
        File directory = new File(CACHE_DIR);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if ((directoryListing = directory.listFiles()) != null) {
            for (File file : directoryListing) {
                String fileName = file.getName();
                try {
                    UUID id = UUID.fromString(fileName);
                    class_2487 tag = class_2507.method_30613((Path)file.toPath(), (class_2505)class_2505.method_53898());
                    if (tag.method_10545("id") && id.equals(tag.method_25926("id")) && tag.method_10545("ver") && tag.method_10545("notes")) {
                        int version = tag.method_10550("ver");
                        ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>();
                        NoteEvent.fillArrayFromNBT(notes, tag);
                        MUSIC_MAP.put(id, new MusicManager.MusicData(version, notes));
                        continue;
                    }
                    if (file.delete()) continue;
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = file::getAbsolutePath;
                    Mod.LOGGER.warn("Could not delete invalid music sheet file: {}", supplierArray);
                }
                catch (IOException | IllegalArgumentException e) {
                    if (file.delete()) continue;
                    Mod.LOGGER.warn("Could not delete music sheet file on exception {}: {}", (Object)e, (Object)file.getAbsolutePath());
                }
            }
        }
    }

    public static void checkMusicDataAndRun(UUID id, int ver, Runnable task) {
        if (MUSIC_MAP.containsKey(id)) {
            MusicManager.MusicData data = MUSIC_MAP.get(id);
            int dataVer = data.version();
            if (dataVer >= ver) {
                Mod.LOGGER.debug("Music data found in client (id: {}, requested ver: {}) (checkMusicDataAndRun)", (Object)id, (Object)ver);
                task.run();
                return;
            }
            Mod.LOGGER.info("Music data in client is too old (id: {}, data ver: {}, requested ver: {}) (checkMusicDataAndRun)", (Object)id, (Object)dataVer, (Object)ver);
        }
        Mod.LOGGER.info("Requesting music data from server (id: {}, requested ver: {}) (checkMusicDataAndRun)", (Object)id, (Object)ver);
        TASK_MAP.put(id, task);
        MusicDataRequestPacket packet = new MusicDataRequestPacket(id, ver);
        ClientStuff.sendToServer(packet);
    }

    public static MusicManager.MusicData getMusicData(UUID id, int ver) {
        if (MUSIC_MAP.containsKey(id)) {
            MusicManager.MusicData data = MUSIC_MAP.get(id);
            int dataVer = data.version();
            if (dataVer >= ver) {
                Mod.LOGGER.debug("Music data found in client (id: {}, requested ver: {}) (getMusicData)", (Object)id, (Object)ver);
                return data;
            }
            Mod.LOGGER.info("Music data in client is too old (id: {}, data ver: {}, requested ver: {}) (getMusicData)", (Object)id, (Object)dataVer, (Object)ver);
        }
        Mod.LOGGER.info("Requesting music data from server (id: {}, requested ver: {}) (getMusicData)", (Object)id, (Object)ver);
        MusicDataRequestPacket packet = new MusicDataRequestPacket(id, ver);
        ClientStuff.sendToServer(packet);
        return null;
    }

    public static void setMusicData(UUID id, int ver, List<NoteEvent> notes) {
        MUSIC_MAP.put(id, new MusicManager.MusicData(ver, notes));
        String filename = id.toString();
        String filepath = "music_sheets/.cache//" + filename;
        File directory = new File(CACHE_DIR);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        class_2487 tag = new class_2487();
        tag.method_25927("id", id);
        tag.method_10569("ver", ver);
        NoteEvent.fillNBTFromArray(notes, tag);
        try {
            class_2507.method_30614((class_2487)tag, (Path)Path.of(filepath, new String[0]));
        }
        catch (IOException e) {
            Mod.LOGGER.warn("Could not write music data to cache file {}: {}", (Object)filepath, (Object)e);
        }
        if (TASK_MAP.containsKey(id)) {
            Runnable task = TASK_MAP.get(id);
            TASK_MAP.remove(id);
            task.run();
        }
    }
}

