/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_638;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.tile_entity.TileEntityMusicBox;

public class SoundController
extends Thread {
    private final List<NoteEvent> notes;
    private final IItemInstrument instrument;
    private final byte bps;
    private final int spiritID;
    private final float volume;
    private volatile boolean doStop;
    private volatile double x;
    private volatile double y;
    private volatile double z;
    private TileEntityMusicBox musicBox;
    private static final AtomicInteger CONTROLLER_COUNTER = new AtomicInteger();

    public SoundController(List<NoteEvent> notes, double x, double y, double z, IItemInstrument instrument, byte bps, float volume, int spiritID) {
        this.notes = notes;
        this.x = x;
        this.y = y;
        this.z = z;
        this.instrument = instrument;
        this.bps = bps;
        this.volume = volume;
        this.spiritID = spiritID;
        this.setDaemon(true);
        this.setName("XercaMusic-SoundController-" + CONTROLLER_COUNTER.incrementAndGet());
    }

    public SoundController(List<NoteEvent> notes, double x, double y, double z, IItemInstrument instrument, byte bps, float volume, TileEntityMusicBox musicBox) {
        this(notes, x, y, z, instrument, bps, volume, -1);
        this.musicBox = musicBox;
    }

    private int beatsToTicks(int beats) {
        return Math.max(1, Math.round((float)beats * 20.0f / (float)this.bps));
    }

    @Override
    public void run() {
        if (this.bps == 0) {
            Mod.LOGGER.error("BPS is 0! This should not happen!");
            return;
        }
        int msPerBeat = Math.round(1000.0f / (float)this.bps);
        int currentBeat = 0;
        class_310 minecraft = class_310.method_1551();
        for (NoteEvent event : this.notes) {
            if (this.doStop) {
                return;
            }
            while (event.time > currentBeat) {
                this.accurateSleep(msPerBeat);
                ++currentBeat;
                while (minecraft.method_1493()) {
                    this.inaccurateSleep(1L);
                }
                if (!this.doStop && minecraft.field_1687 != null) continue;
                return;
            }
            this.playNote(event);
        }
        if (this.spiritID >= 0 && minecraft.field_1724 != null) {
            minecraft.method_20493(() -> ClientStuff.endMusic(this.spiritID, minecraft.field_1724.method_5628())).whenComplete((v, t) -> {
                if (t != null) {
                    Mod.LOGGER.error("Failed to end music", t);
                }
            });
        }
    }

    private void playNote(NoteEvent event) {
        if (event.note >= 21 && event.note <= 117) {
            byte note = event.note;
            class_310.method_1551().method_20493(() -> {
                class_638 level = class_310.method_1551().field_1687;
                IItemInstrument.InsSound insSound = this.instrument.getSound(note);
                if (level == null || insSound == null) {
                    return;
                }
                if (this.musicBox == null) {
                    ClientStuff.playNote(insSound.sound(), this.x, this.y, this.z, this.volume * event.floatVolume(), insSound.pitch(), (byte)this.beatsToTicks(event.length));
                    level.method_8406((class_2394)class_2398.field_11224, this.x, this.y + 2.2, this.z, (double)note / 24.0, 0.0, 0.0);
                } else {
                    ClientStuff.playNoteTE(insSound.sound(), this.x, this.y, this.z, this.volume * event.floatVolume(), insSound.pitch(), (byte)this.beatsToTicks(event.length));
                    level.method_8406((class_2394)class_2398.field_11224, this.x + 0.5, this.y + 2.2, this.z + 0.5, (double)note / 24.0, 0.0, 0.0);
                }
            }).whenComplete((v, t) -> {
                if (t != null) {
                    Mod.LOGGER.error("Failed to play note", t);
                }
            });
        }
    }

    public void setStop() {
        this.doStop = true;
    }

    public void setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private void accurateSleep(long millis) {
        if (millis == 0L) {
            return;
        }
        long start = System.currentTimeMillis();
        if (millis > 8L) {
            try {
                SoundController.sleep(millis - 8L);
            }
            catch (InterruptedException e) {
                Mod.LOGGER.warn("Interrupted while sleeping", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        while (System.currentTimeMillis() < start + millis) {
            Thread.onSpinWait();
        }
    }

    private void inaccurateSleep(long millis) {
        if (millis == 0L) {
            return;
        }
        try {
            SoundController.sleep(millis);
        }
        catch (InterruptedException e) {
            Mod.LOGGER.warn("Interrupted while sleeping", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

