/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import net.minecraft.class_9331;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.clientbound.ExportMusicPacket;

public final class CommandExport {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"musicexport").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandExport.musicExport((class_2168)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int musicExport(class_2168 stack, String name) {
        Mod.LOGGER.debug("Music export called. name: {}", (Object)name);
        if (stack.method_9228() == null) {
            Mod.LOGGER.error("Command entity is not found");
            return 0;
        }
        class_1297 commander = stack.method_9228();
        if (!(commander instanceof class_3222)) {
            Mod.LOGGER.error("Command entity is not a player");
            return 0;
        }
        class_3222 player = (class_3222)commander;
        ExportMusicPacket pack = new ExportMusicPacket(name);
        Mod.sendToClient(player, pack);
        return 1;
    }

    public static boolean doExport(class_1657 player, String name) {
        File directory = new File("music_sheets");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        Path filePath = directory.toPath().resolve(name + ".sheet");
        for (class_1799 stack : player.method_5877()) {
            if (!(stack.method_7909() instanceof ItemMusicSheet)) continue;
            CommandExport.exportSheetIfValid(stack, filePath);
            return true;
        }
        return false;
    }

    private static void exportSheetIfValid(class_1799 stack, Path filePath) {
        UUID id = (UUID)stack.method_57824(Items.SHEET_ID);
        int ver = (Integer)stack.method_57825(Items.SHEET_VERSION, (Object)-1);
        int length = (Integer)stack.method_57825(Items.SHEET_LENGTH, (Object)0);
        if (id == null || ver < 0 || length <= 0) {
            return;
        }
        MusicManagerClient.checkMusicDataAndRun(id, ver, () -> CommandExport.writeSheetFile(stack, id, ver, length, filePath));
    }

    private static void writeSheetFile(class_1799 stack, UUID id, int ver, int length, Path filePath) {
        MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
        if (data == null) {
            return;
        }
        class_2487 tag = new class_2487();
        tag.method_10569("ver", ver);
        tag.method_25927("id", id);
        tag.method_10569("l", length);
        tag.method_10569("generation", ((Integer)stack.method_57825(Items.SHEET_GENERATION, (Object)0)).intValue());
        CommandExport.putOptionalByte(stack, Items.SHEET_BPS, tag, "bps");
        CommandExport.putOptionalBoolean(stack, Items.SHEET_PREV_INSTRUMENT_LOCKED, tag, "piLocked");
        CommandExport.putOptionalByte(stack, Items.SHEET_PREV_INSTRUMENT, tag, "prevIns");
        CommandExport.putOptionalTitleAuthor(stack, tag);
        CommandExport.putOptionalByte(stack, Items.SHEET_HIGHLIGHT_INTERVAL, tag, "hl");
        CommandExport.putOptionalFloat(stack, Items.SHEET_VOLUME, tag, "vol");
        NoteEvent.fillNBTFromArray(data.notes(), tag);
        try {
            class_2507.method_10630((class_2487)tag, (Path)filePath);
        }
        catch (IOException e) {
            Mod.LOGGER.error("Failed to write music sheet file {}: {}", (Object)filePath, (Object)e);
        }
    }

    private static void putOptionalByte(class_1799 stack, class_9331<Byte> key, class_2487 tag, String tagName) {
        Byte value = (Byte)stack.method_57824(key);
        if (value != null) {
            tag.method_10567(tagName, value.byteValue());
        }
    }

    private static void putOptionalBoolean(class_1799 stack, class_9331<Boolean> key, class_2487 tag, String tagName) {
        Boolean value = (Boolean)stack.method_57824(key);
        if (value != null) {
            tag.method_10556(tagName, value.booleanValue());
        }
    }

    private static void putOptionalFloat(class_1799 stack, class_9331<Float> key, class_2487 tag, String tagName) {
        Float value = (Float)stack.method_57824(key);
        if (value != null) {
            tag.method_10548(tagName, value.floatValue());
        }
    }

    private static void putOptionalTitleAuthor(class_1799 stack, class_2487 tag) {
        String title = (String)stack.method_57824(Items.SHEET_TITLE);
        String author = (String)stack.method_57824(Items.SHEET_AUTHOR);
        if (title != null && author != null) {
            tag.method_10582("title", title);
            tag.method_10582("author", author);
        }
    }
}

