/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class NoteEvent {
    public byte note;
    public short time;
    public byte volume;
    public byte length;

    public NoteEvent(byte note, short time, byte volume, byte length) {
        this.note = note;
        this.time = time;
        this.volume = volume;
        this.length = length;
    }

    public NoteEvent() {
    }

    public NoteEvent(NoteEvent noteEvent) {
        this.note = noteEvent.note;
        this.time = noteEvent.time;
        this.volume = noteEvent.volume;
        this.length = noteEvent.length;
    }

    public static NoteEvent fromNBT(class_2487 tag) {
        NoteEvent noteEvent = new NoteEvent();
        noteEvent.deserializeNBT(tag);
        return noteEvent;
    }

    public static NoteEvent fromBuffer(class_2540 buf) {
        NoteEvent noteEvent = new NoteEvent();
        noteEvent.decodeFromBuffer(buf);
        return noteEvent;
    }

    public static void fillArrayFromNBT(List<NoteEvent> noteEvents, class_2487 tag) {
        class_2499 notesTag = tag.method_10554("notes", 10);
        for (int i = 0; i < notesTag.size(); ++i) {
            noteEvents.add(NoteEvent.fromNBT(notesTag.method_10602(i)));
        }
        NoteEvent.sortNotes(noteEvents);
        NoteEvent.removeDuplicates(noteEvents);
    }

    public static void sortNotes(List<NoteEvent> notes) {
        notes.sort(Comparator.comparingInt(NoteEvent::startTime));
    }

    public static void removeDuplicates(List<NoteEvent> notes) {
        if (notes.isEmpty()) {
            return;
        }
        short currentTime = notes.get((int)0).time;
        long seenLo = 0L;
        long seenHi = 0L;
        int i = 0;
        while (i < notes.size()) {
            int note;
            NoteEvent e = notes.get(i);
            if (e.note < 21 || e.note > 117) {
                notes.remove(i);
                continue;
            }
            if (e.time != currentTime) {
                currentTime = e.time;
                seenLo = 0L;
                seenHi = 0L;
            }
            if ((note = e.note & 0xFF) < 64) {
                bit = 1L << note;
                if ((seenLo & bit) != 0L) {
                    notes.remove(i);
                    continue;
                }
                seenLo |= bit;
            } else {
                bit = 1L << note - 64;
                if ((seenHi & bit) != 0L) {
                    notes.remove(i);
                    continue;
                }
                seenHi |= bit;
            }
            ++i;
        }
    }

    public static void fillNBTFromArray(List<NoteEvent> noteEvents, class_2487 tag) {
        class_2499 noteList = new class_2499();
        for (NoteEvent event : noteEvents) {
            noteList.add((Object)event.serializeNBT());
        }
        tag.method_10566("notes", (class_2520)noteList);
    }

    public short endTime() {
        return (short)(this.time + this.length - 1);
    }

    public short startTime() {
        return this.time;
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10567("n", this.note);
        tag.method_10575("d", this.time);
        tag.method_10567("v", this.volume);
        tag.method_10567("l", this.length);
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.note = tag.method_10571("n");
        this.time = tag.method_10568("d");
        this.volume = tag.method_10571("v");
        this.length = tag.method_10571("l");
    }

    public void encodeToBuffer(class_2540 buf) {
        buf.method_52997((int)this.note);
        buf.method_52998((int)this.time);
        buf.method_52997((int)this.volume);
        buf.method_52997((int)this.length);
    }

    public void decodeFromBuffer(class_2540 buf) {
        this.note = buf.readByte();
        this.time = buf.readShort();
        this.volume = buf.readByte();
        this.length = buf.readByte();
    }

    public float floatVolume() {
        return (float)this.volume / 127.0f;
    }
}

