/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3414;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.ItemInstrument;

public class ItemBlockInstrument
extends class_1747
implements IItemInstrument {
    private final int minOctave;
    private final int maxOctave;
    private final int instrumentId;
    private IItemInstrument.InsSound[] insSounds;

    public ItemBlockInstrument(int instrumentId, int minOctave, int maxOctave, class_2248 block) {
        this(instrumentId, minOctave, maxOctave, new class_1792.class_1793(), block);
    }

    public ItemBlockInstrument(int instrumentId, int minOctave, int maxOctave, class_1792.class_1793 properties, class_2248 block) {
        super(block, properties);
        this.instrumentId = instrumentId;
        this.minOctave = minOctave;
        this.maxOctave = maxOctave;
    }

    @Override
    public int getMinOctave() {
        return this.minOctave;
    }

    @Override
    public int getMaxOctave() {
        return this.maxOctave;
    }

    @Override
    public int getInstrumentId() {
        return this.instrumentId;
    }

    @Nonnull
    public class_1271<class_1799> method_7836(@NotNull class_1937 worldIn, @NotNull class_1657 playerIn, @NotNull class_1268 handIn) {
        return ItemInstrument.useInstrument(worldIn, playerIn, handIn);
    }

    @Nonnull
    public class_1269 method_7884(@NotNull class_1838 context) {
        if (ItemInstrument.useInstrumentOn(context)) {
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    public boolean method_7873(@NotNull class_1799 stack, @NotNull class_1309 target, @NotNull class_1309 attacker) {
        ItemInstrument.hurtEnemyWithInstrument(target, attacker, this.minOctave, this.maxOctave, this);
        return true;
    }

    @Override
    public void setSounds(List<IItemInstrument.Pair<Integer, class_3414>> sounds) {
        this.insSounds = new IItemInstrument.InsSound[96];
        for (int i = 0; i < 96; ++i) {
            int octave = i / 12;
            if (octave < this.minOctave || octave > this.maxOctave) continue;
            int note = IItemInstrument.idToNote(i);
            int index = ItemInstrument.getClosest(note, sounds);
            if (index < 0 || index >= sounds.size()) {
                Mod.LOGGER.error("Invalid sound index in Instrument construction");
                continue;
            }
            IItemInstrument.Pair<Integer, class_3414> base = sounds.get(index);
            float pitch = (float)Math.pow(1.05946314465679, note - base.first());
            this.insSounds[i] = new IItemInstrument.InsSound(base.second(), pitch);
        }
    }

    @Override
    @Nullable
    public IItemInstrument.InsSound getSound(int note) {
        int id = IItemInstrument.noteToId(note);
        if (id >= 0 && id < 96) {
            return this.insSounds[id];
        }
        Mod.LOGGER.warn("Requested invalid note from Instrument getSound: {}", (Object)note);
        return null;
    }
}

