/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.clientbound.TripleNoteClientPacket;

public class ItemInstrument
extends class_1792
implements IItemInstrument {
    public final int minOctave;
    public final int maxOctave;
    private final int instrumentId;
    private IItemInstrument.InsSound[] insSounds;

    public ItemInstrument(int instrumentId, int minOctave, int maxOctave) {
        this(instrumentId, minOctave, maxOctave, new class_1792.class_1793());
    }

    public ItemInstrument(int instrumentId, int minOctave, int maxOctave, class_1792.class_1793 properties) {
        super(properties);
        this.instrumentId = instrumentId;
        this.minOctave = minOctave;
        this.maxOctave = maxOctave;
    }

    @Override
    public int getInstrumentId() {
        return this.instrumentId;
    }

    public static class_1271<class_1799> useInstrument(@NotNull class_1937 worldIn, @NotNull class_1657 playerIn, @NotNull class_1268 handIn) {
        class_1799 heldItem = playerIn.method_5998(handIn);
        class_1799 off = playerIn.method_6079();
        if (handIn == class_1268.field_5808 && off.method_7909() == Items.MUSIC_SHEET) {
            if (!worldIn.field_9236) {
                IItemInstrument.playMusic(worldIn, playerIn, true);
            }
        } else if (worldIn.field_9236) {
            Mod.onlyRunOnClient(() -> ClientStuff::showInstrumentGui);
        }
        return new class_1271(class_1269.field_5812, (Object)heldItem);
    }

    public static boolean useInstrumentOn(@NotNull class_1838 context) {
        class_2338 blockpos;
        class_1937 world = context.method_8045();
        class_2680 blockState = world.method_8320(blockpos = context.method_8037());
        if (blockState.method_26204() == Blocks.MUSIC_BOX && !((Boolean)blockState.method_11654((class_2769)BlockMusicBox.HAS_INSTRUMENT)).booleanValue()) {
            class_1799 itemstack = context.method_8041();
            if (!world.field_9236) {
                BlockMusicBox.insertInstrument((class_1936)world, blockpos, blockState, itemstack.method_7909());
                class_1657 player = context.method_8036();
                if (player != null && !player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
            }
            return true;
        }
        return false;
    }

    public static void hurtEnemyWithInstrument(@NotNull class_1309 target, class_1309 attacker, int minOctave, int maxOctave, IItemInstrument instrument) {
        class_1937 world = attacker.method_37908();
        if (!world.field_9236) {
            int note1 = 21 + minOctave * 12 + world.field_9229.method_43048((maxOctave + 1) * 12 - minOctave * 12);
            int note2 = 21 + minOctave * 12 + world.field_9229.method_43048((maxOctave + 1) * 12 - minOctave * 12);
            int note3 = 21 + minOctave * 12 + world.field_9229.method_43048((maxOctave + 1) * 12 - minOctave * 12);
            Collection players = PlayerLookup.around((class_3218)((class_3218)target.method_37908()), (class_243)target.method_19538(), (double)24.0);
            TripleNoteClientPacket packet = new TripleNoteClientPacket(note1, note2, note3, instrument, (class_1297)target);
            for (class_3222 player : players) {
                Mod.sendToClient(player, packet);
            }
        }
    }

    @Nonnull
    public class_1271<class_1799> method_7836(@NotNull class_1937 worldIn, @NotNull class_1657 playerIn, @NotNull class_1268 handIn) {
        return ItemInstrument.useInstrument(worldIn, playerIn, handIn);
    }

    @Nonnull
    public class_1269 method_7884(@NotNull class_1838 context) {
        if (ItemInstrument.useInstrumentOn(context)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_7873(@NotNull class_1799 stack, @NotNull class_1309 target, @NotNull class_1309 attacker) {
        ItemInstrument.hurtEnemyWithInstrument(target, attacker, this.minOctave, this.maxOctave, this);
        return true;
    }

    @Override
    public void setSounds(List<IItemInstrument.Pair<Integer, class_3414>> sounds) {
        this.insSounds = new IItemInstrument.InsSound[96];
        for (int i = 0; i < 96; ++i) {
            int octave;
            int note = IItemInstrument.idToNote(i);
            int index = ItemInstrument.getClosest(note, sounds);
            if (index < 0 || index >= sounds.size()) {
                Mod.LOGGER.error("Invalid sound index in Instrument construction");
            }
            if ((octave = i / 12) < this.minOctave || octave > this.maxOctave) continue;
            float pitch = (float)Math.pow(1.05946314465679, note - sounds.get(index).first());
            this.insSounds[i] = new IItemInstrument.InsSound(sounds.get(index).second(), pitch);
        }
    }

    public static int getClosest(int note, List<IItemInstrument.Pair<Integer, class_3414>> sounds) {
        int minDiff = 100;
        int bestIndex = -1;
        for (int i = 0; i < sounds.size(); ++i) {
            int diff = Math.abs(sounds.get(i).first() - note);
            if (diff >= minDiff) continue;
            minDiff = diff;
            bestIndex = i;
        }
        return bestIndex;
    }

    @Override
    public IItemInstrument.InsSound getSound(int note) {
        int id = IItemInstrument.noteToId(note);
        if (id >= 0 && id < 96) {
            return this.insSounds[id];
        }
        Mod.LOGGER.warn("Requested invalid note from Instrument getSound: {}", (Object)note);
        return null;
    }

    @Override
    public int getMinOctave() {
        return this.minOctave;
    }

    @Override
    public int getMaxOctave() {
        return this.maxOctave;
    }
}

