/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;

public class ItemMusicSheet
extends class_1792 {
    private static final HashMap<IItemInstrument.Pair<String, String>, UUID> CONVERT_MAP = new HashMap();
    private static final int ADD_TO_OLD_END = 8;
    public static final String KEY_NOTES = "notes";
    public static final String KEY_AUTHOR = "author";
    public static final String KEY_TITLE = "title";
    public static final String KEY_VERSION = "ver";
    public static final String KEY_GENERATION = "generation";
    public static final String KEY_ID = "id";
    public static final String KEY_LENGTH = "l";
    public static final String KEY_BPS = "bps";
    public static final String KEY_PREV_INSTRUMENT_LOCKED = "piLocked";
    public static final String KEY_PREV_INSTRUMENT = "prevIns";
    public static final String KEY_HIGHLIGHT_INTERVAL = "hl";
    public static final String KEY_VOLUME = "vol";
    public static final String KEY_MUSIC_OLD = "music";
    public static final String KEY_LENGTH_OLD = "length";
    public static final String KEY_PAUSE_OLD = "pause";

    ItemMusicSheet() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public static List<NoteEvent> oldMusicToNotes(byte[] music) {
        ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>();
        for (int i = 0; i < music.length; ++i) {
            if (music[i] <= 0) continue;
            int nextTime = -1;
            for (int j = i + 1; j < music.length; ++j) {
                if (music[j] <= 0) continue;
                nextTime = j;
                break;
            }
            int l = 1;
            if (nextTime > i && nextTime - i < 20) {
                l = nextTime - i;
            } else if (i == music.length - 1) {
                l = 8;
            }
            byte note = (byte)(music[i] + 32);
            notes.add(new NoteEvent(note, (short)i, 64, (byte)l));
        }
        return notes;
    }

    public static List<NoteEvent> convertFromOld(class_2487 nbt, MinecraftServer server) {
        UUID id;
        int length = nbt.method_10550(KEY_LENGTH_OLD);
        byte pause = nbt.method_10571(KEY_PAUSE_OLD);
        byte[] music = nbt.method_10547(KEY_MUSIC_OLD);
        byte bps = (byte)Math.round(20.0f / (float)pause);
        List<NoteEvent> notes = ItemMusicSheet.oldMusicToNotes(music);
        nbt.method_10569(KEY_LENGTH, length + 8);
        nbt.method_10567(KEY_BPS, bps);
        if (nbt.method_10545(KEY_AUTHOR) && nbt.method_10545(KEY_TITLE)) {
            String title;
            String author = nbt.method_10558(KEY_AUTHOR);
            IItemInstrument.Pair<String, String> key = new IItemInstrument.Pair<String, String>(author, title = nbt.method_10558(KEY_TITLE));
            if (CONVERT_MAP.containsKey(key)) {
                id = CONVERT_MAP.get(key);
            } else {
                id = UUID.randomUUID();
                CONVERT_MAP.put(key, id);
                MusicManager.setMusicData(id, 1, notes, server);
            }
        } else {
            id = UUID.randomUUID();
            MusicManager.setMusicData(id, 1, notes, server);
        }
        nbt.method_25927(KEY_ID, id);
        nbt.method_10569(KEY_VERSION, 1);
        nbt.method_10551(KEY_LENGTH_OLD);
        nbt.method_10551(KEY_PAUSE_OLD);
        nbt.method_10551(KEY_MUSIC_OLD);
        return notes;
    }

    public static byte getBPS(@Nonnull class_1799 stack) {
        return (Byte)stack.method_57825(Items.SHEET_BPS, (Object)0);
    }

    public static int getPrevInstrument(@Nonnull class_1799 stack) {
        Byte prevIns = (Byte)stack.method_57824(Items.SHEET_PREV_INSTRUMENT);
        if (prevIns != null) {
            return prevIns.byteValue();
        }
        return -1;
    }

    public static float getVolume(@Nonnull class_1799 stack) {
        return ((Float)stack.method_57825(Items.SHEET_VOLUME, (Object)Float.valueOf(1.0f))).floatValue();
    }

    public static boolean isEmptySheet(@Nonnull class_1799 stack) {
        return stack.method_57824(Items.SHEET_GENERATION) == null && stack.method_57824(Items.SHEET_ID) == null && stack.method_57824(Items.SHEET_VERSION) == null;
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, @Nonnull class_1268 hand) {
        class_1799 heldItem = playerIn.method_5998(hand);
        if (worldIn.field_9236) {
            Mod.onlyRunOnClient(() -> ClientStuff::showMusicGui);
        }
        return new class_1271(class_1269.field_5812, (Object)heldItem);
    }

    @Nonnull
    public class_2561 method_7864(@Nonnull class_1799 stack) {
        String title = (String)stack.method_57824(Items.SHEET_TITLE);
        if (title != null) {
            return class_2561.method_43470((String)title);
        }
        return super.method_7864(stack);
    }

    public void method_7851(@NotNull class_1799 stack, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 tooltipFlag) {
        int prevIns;
        byte bps;
        int length;
        int generation;
        String s = (String)stack.method_57824(Items.SHEET_AUTHOR);
        if (s != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"note.byAuthor", (Object[])new Object[]{s}));
        }
        if ((generation = ((Integer)stack.method_57825(Items.SHEET_GENERATION, (Object)0)).intValue()) > 0) {
            tooltip.add((class_2561)class_2561.method_43471((String)("note.generation." + (generation - 1))).method_27692(generation == 1 ? class_124.field_1065 : class_124.field_1080));
        }
        if ((length = ((Integer)stack.method_57825(Items.SHEET_LENGTH, (Object)0)).intValue()) > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"note.length", (Object[])new Object[]{length}).method_27692(class_124.field_1080));
        }
        if ((bps = ItemMusicSheet.getBPS(stack)) > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"note.tempo", (Object[])new Object[]{bps * 60}).method_27692(class_124.field_1080));
        }
        if ((prevIns = ItemMusicSheet.getPrevInstrument(stack)) >= 0 && prevIns < Items.INSTRUMENTS.size()) {
            class_2561 name = ((class_1792)Items.INSTRUMENTS.get(prevIns)).method_7864(new class_1799((class_1935)((class_1792)Items.INSTRUMENTS.get(prevIns))));
            tooltip.add((class_2561)class_2561.method_43469((String)"note.preview_instrument", (Object[])new Object[]{name}).method_27692(class_124.field_1080));
        }
    }

    @Nonnull
    public class_1269 method_7884(class_1838 context) {
        class_2338 blockpos;
        class_1937 world = context.method_8045();
        class_2680 blockState = world.method_8320(blockpos = context.method_8037());
        if (blockState.method_26204() == Blocks.MUSIC_BOX && !((Boolean)blockState.method_11654((class_2769)BlockMusicBox.HAS_MUSIC)).booleanValue()) {
            class_1799 itemstack = context.method_8041();
            if (!world.field_9236 && itemstack.method_57824(Items.SHEET_ID) != null) {
                BlockMusicBox.insertMusic((class_1936)world, blockpos, blockState, itemstack.method_7972());
                class_1657 player = context.method_8036();
                if (player != null && !player.method_31549().field_7477) {
                    itemstack.method_7934(1);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_7886(class_1799 stack) {
        return (Integer)stack.method_57825(Items.SHEET_GENERATION, (Object)0) > 0;
    }
}

