/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.clientbound;

import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_746;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.packets.clientbound.ImportMusicPacket;
import xerca.xercamusic.common.packets.clientbound.NotesPartAckFromServerPacketHandler;
import xerca.xercamusic.common.packets.serverbound.ImportMusicSendPacket;
import xerca.xercamusic.common.packets.serverbound.SendNotesPartToServerPacket;

public class ImportMusicPacketHandler
implements ClientPlayNetworking.PlayPayloadHandler<ImportMusicPacket> {
    private static void processMessage(ImportMusicPacket msg, class_746 player) {
        block3: {
            String filename = msg.name() + ".sheet";
            String filepath = "music_sheets/" + filename;
            try {
                class_2487 tag = class_2507.method_10633((Path)Path.of(filepath, new String[0]));
                if (tag == null) {
                    throw new IOException("File not found!");
                }
                ImportMusicPacketHandler.sendMusic(tag);
            }
            catch (IOException | NullPointerException | ImportMusicSendPacket.NotesTooLargeException e) {
                Mod.LOGGER.error("Exception while reading music sheet: ", (Throwable)e);
                if (player == null) break block3;
                player.method_43496((class_2561)class_2561.method_43469((String)"xercamusic.import.fail.4", (Object[])new Object[]{filepath}).method_27692(class_124.field_1061));
            }
        }
    }

    private static void sendMusic(class_2487 tag) throws IOException, ImportMusicSendPacket.NotesTooLargeException {
        try {
            ImportMusicSendPacket pack = ImportMusicSendPacket.create(tag);
            ClientStuff.sendToServer(pack);
        }
        catch (ImportMusicSendPacket.NotesTooLargeException e) {
            if (e.id == null) {
                throw new IOException("Music has many notes, but no UUID!");
            }
            int partsCount = (int)Math.ceil((double)e.notes.size() / 5000.0);
            tag.method_10551("notes");
            ImportMusicSendPacket pack = ImportMusicSendPacket.create(tag);
            NotesPartAckFromServerPacketHandler.addCallback(e.id, () -> ClientStuff.sendToServer(pack));
            for (int i = 0; i < partsCount; ++i) {
                SendNotesPartToServerPacket partPack = new SendNotesPartToServerPacket(e.id, partsCount, i, e.notes.subList(i * 5000, Math.min((i + 1) * 5000, e.notes.size())));
                ClientStuff.sendToServer(partPack);
            }
        }
    }

    public void receive(ImportMusicPacket packet, ClientPlayNetworking.Context context) {
        if (packet != null) {
            context.client().execute(() -> ImportMusicPacketHandler.processMessage(packet, context.player()));
        }
    }
}

