/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.clientbound;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.packets.clientbound.SingleNoteClientPacket;

public class SingleNoteClientPacketHandler
implements ClientPlayNetworking.PlayPayloadHandler<SingleNoteClientPacket> {
    static final Map<IItemInstrument.Pair<class_1657, Integer>, NoteSoundEntry> NOTE_SOUNDS = new HashMap<IItemInstrument.Pair<class_1657, Integer>, NoteSoundEntry>();

    private static void processMessage(SingleNoteClientPacket msg) {
        int playerId = msg.playerId();
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            Mod.LOGGER.warn("Level is null while trying to get entity");
            return;
        }
        class_1297 entity = level.method_8469(playerId);
        if (!(entity instanceof class_1657)) {
            Mod.LOGGER.warn("Invalid playerId: {}", (Object)playerId);
            return;
        }
        class_1657 playerEntity = (class_1657)entity;
        if (!playerEntity.equals((Object)class_310.method_1551().field_1724)) {
            IItemInstrument.InsSound sound = msg.instrumentItem().getSound(msg.note());
            if (sound == null) {
                return;
            }
            if (!msg.isStop()) {
                NoteSound noteSound;
                double x = playerEntity.method_23317();
                double y = playerEntity.method_23318();
                double z = playerEntity.method_23321();
                try {
                    noteSound = (NoteSound)((Object)Mod.onlyCallOnClient(() -> () -> ClientStuff.playNote(sound.sound(), x, y, z, class_3419.field_15248, msg.volume() * 1.5f, sound.pitch(), (byte)-1)));
                }
                catch (Exception e) {
                    Mod.LOGGER.error("Exception while playing note: ", (Throwable)e);
                    return;
                }
                NOTE_SOUNDS.put(IItemInstrument.Pair.of(playerEntity, msg.note()), new NoteSoundEntry(noteSound, playerEntity));
                playerEntity.method_37908().method_8406((class_2394)class_2398.field_11224, x, y + 2.2, z, (double)msg.note() / 24.0, 0.0, 0.0);
            } else {
                NoteSoundEntry oldNoteSoundEntry = NOTE_SOUNDS.get(IItemInstrument.Pair.of(playerEntity, msg.note()));
                if (oldNoteSoundEntry != null && !oldNoteSoundEntry.noteSound.method_4793()) {
                    oldNoteSoundEntry.noteSound.stopSound();
                }
            }
        }
    }

    public void receive(SingleNoteClientPacket packet, ClientPlayNetworking.Context context) {
        if (packet != null) {
            context.client().execute(() -> SingleNoteClientPacketHandler.processMessage(packet));
        }
    }

    private record NoteSoundEntry(NoteSound noteSound, class_1657 playerEntity) {
    }
}

