/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets.serverbound;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.NoteEvent;

public record ImportMusicSendPacket(UUID uuid, class_2487 tag, ArrayList<NoteEvent> notes) implements class_8710
{
    public static final class_8710.class_9154<ImportMusicSendPacket> PACKET_ID = new class_8710.class_9154(Mod.id("import_music_send"));
    public static final class_9139<class_2540, ImportMusicSendPacket> PACKET_CODEC = class_9139.method_56438(ImportMusicSendPacket::encode, ImportMusicSendPacket::decode);

    public static ImportMusicSendPacket createEmpty() {
        return new ImportMusicSendPacket(null, null, null);
    }

    public static ImportMusicSendPacket create(class_2487 tag) throws NotesTooLargeException {
        UUID uuid = null;
        ArrayList<NoteEvent> notes = null;
        if (tag.method_10545("id")) {
            uuid = tag.method_25926("id");
        }
        if (tag.method_10545("notes")) {
            notes = new ArrayList<NoteEvent>();
            NoteEvent.fillArrayFromNBT(notes, tag);
            tag.method_10551("notes");
            if (notes.size() > 5000) {
                throw new NotesTooLargeException(notes, uuid);
            }
        }
        return new ImportMusicSendPacket(uuid, tag, notes);
    }

    public static ImportMusicSendPacket create(class_2487 tag, ArrayList<NoteEvent> notes) {
        UUID uuid = null;
        if (tag.method_10545("id")) {
            uuid = tag.method_25926("id");
        }
        return new ImportMusicSendPacket(uuid, tag, notes);
    }

    public static ImportMusicSendPacket decode(class_2540 buf) {
        try {
            ArrayList<NoteEvent> notes = ImportMusicSendPacket.notesFromBuffer(buf);
            class_2487 tag = buf.method_10798();
            if (tag == null) {
                Mod.LOGGER.error("CompoundTag was null in ImportMusicSendPacket");
                return ImportMusicSendPacket.createEmpty();
            }
            return notes == null ? ImportMusicSendPacket.create(tag) : ImportMusicSendPacket.create(tag, notes);
        }
        catch (NotesTooLargeException e) {
            Mod.LOGGER.error("NotesTooLargeException while reading ImportMusicSendPacket: ", (Throwable)e);
            return ImportMusicSendPacket.createEmpty();
        }
    }

    public static ArrayList<NoteEvent> notesFromBuffer(class_2540 buf) {
        int eventCount = buf.readInt();
        ArrayList<NoteEvent> notes = null;
        if (eventCount > 0) {
            notes = new ArrayList<NoteEvent>(eventCount);
            for (int i = 0; i < eventCount; ++i) {
                notes.add(NoteEvent.fromBuffer(buf));
            }
        }
        return notes;
    }

    public void encode(class_2540 buf) {
        if (this.notes != null) {
            buf.method_53002(this.notes.size());
            for (NoteEvent event : this.notes) {
                event.encodeToBuffer(buf);
            }
        } else {
            buf.method_53002(0);
        }
        buf.method_10794((class_2520)this.tag);
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }

    public static class NotesTooLargeException
    extends Exception {
        public final List<NoteEvent> notes;
        public final UUID id;

        public NotesTooLargeException(List<NoteEvent> notes, UUID id) {
            this.notes = notes;
            this.id = id;
        }
    }
}

