/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.tile_entity;

import java.util.ArrayList;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.client.SoundController;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.clientbound.MusicBoxUpdatePacket;
import xerca.xercamusic.common.tile_entity.BlockEntities;

public class TileEntityMusicBox
extends class_2586 {
    private final ArrayList<NoteEvent> notes = new ArrayList();
    private boolean isPlaying = false;
    private boolean oldPoweredState = false;
    private boolean isPowering = false;
    private boolean firstBlockUpdate = true;
    private class_1799 sheetStack = class_1799.field_8037;
    private IItemInstrument instrument;
    private byte bps;
    private float volume;
    private int poweringAge = 0;
    private int playingAge = 0;
    private int length = 0;
    private SoundController soundController = null;
    private static final String KEY_NOTE = "note";
    private static final String KEY_INS_ID = "instrument_id";

    public TileEntityMusicBox(class_2338 blockPos, class_2680 blockState) {
        super(BlockEntities.MUSIC_BOX, blockPos, blockState);
        if (((Boolean)blockState.method_11654((class_2769)BlockMusicBox.POWERED)).booleanValue()) {
            this.oldPoweredState = true;
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, TileEntityMusicBox t) {
        if (level != null && !t.sheetStack.method_7960() && t.notes.isEmpty() && !ItemMusicSheet.isEmptySheet(t.sheetStack)) {
            UUID id = (UUID)t.sheetStack.method_57824(Items.SHEET_ID);
            int ver = (Integer)t.sheetStack.method_57825(Items.SHEET_VERSION, (Object)-1);
            byte bps = (Byte)t.sheetStack.method_57825(Items.SHEET_BPS, (Object)0);
            int length = (Integer)t.sheetStack.method_57825(Items.SHEET_LENGTH, (Object)0);
            if (id != null && ver >= 0 && bps > 0 && length > 0) {
                if (level.field_9236) {
                    MusicManagerClient.checkMusicDataAndRun(id, ver, () -> {
                        MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
                        if (data != null) {
                            t.notes.clear();
                            t.notes.addAll(data.notes());
                        }
                    });
                } else {
                    MinecraftServer server = level.method_8503();
                    if (server != null) {
                        MusicManager.MusicData data = MusicManager.getMusicData(id, ver, server);
                        if (data != null) {
                            t.notes.clear();
                            t.notes.addAll(data.notes());
                        } else {
                            Mod.LOGGER.warn("Unknown music sheet (id: {})", (Object)id);
                        }
                    }
                }
            }
        }
        if (t.isPowering) {
            if (t.poweringAge >= 10) {
                t.stopPowering();
                return;
            }
            ++t.poweringAge;
        }
        if (t.sheetStack.method_7960() || t.instrument == null) {
            if (t.soundController != null) {
                t.soundController.setStop();
            }
            t.isPlaying = false;
            return;
        }
        if (((Boolean)state.method_11654((class_2769)BlockMusicBox.POWERED)).booleanValue()) {
            if (!t.oldPoweredState) {
                t.isPlaying = !t.isPlaying;
                t.poweringAge = 0;
                t.oldPoweredState = true;
                t.playingAge = 0;
                if (t.isPlaying) {
                    TileEntityMusicBox.musicStart(t, blockPos);
                } else if (t.soundController != null) {
                    t.soundController.setStop();
                }
            }
        } else if (t.oldPoweredState) {
            t.oldPoweredState = false;
        }
        if (t.isPlaying) {
            ++t.playingAge;
            if (t.playingAge >= t.beatsToTicks(t.length)) {
                TileEntityMusicBox.musicOver(t, state);
            }
        }
    }

    public static void musicOver(TileEntityMusicBox t, class_2680 state) {
        t.poweringAge = 0;
        t.isPlaying = false;
        t.isPowering = true;
        class_1937 level = t.field_11863;
        if (level != null) {
            class_2350 rightSide = ((class_2350)state.method_11654((class_2769)BlockMusicBox.field_11177)).method_10170();
            level.method_8501(t.field_11867, (class_2680)state.method_11657((class_2769)BlockMusicBox.POWERING, (Comparable)Boolean.valueOf(true)));
            class_2338 neighbor = t.field_11867.method_10093(rightSide);
            level.method_8492(neighbor, t.method_11010().method_26204(), t.field_11867);
            level.method_8508(neighbor, t.method_11010().method_26204(), rightSide.method_10153());
        }
    }

    public static void musicStart(TileEntityMusicBox t, class_2338 blockPos) {
        if (t.field_11863 != null && t.field_11863.field_9236) {
            if (t.soundController != null) {
                t.soundController.setStop();
            }
            t.soundController = new SoundController(t.notes, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), t.instrument, t.bps, t.volume, t);
            t.soundController.start();
        }
    }

    public void method_11007(@NotNull class_2487 parent, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 levelRegistry) {
        super.method_11007(parent, levelRegistry);
        if (!this.sheetStack.method_7960()) {
            class_2487 sheetTag = new class_2487();
            parent.method_10566(KEY_NOTE, this.sheetStack.method_57376(levelRegistry, (class_2520)sheetTag));
        }
        if (this.instrument != null) {
            class_2960 resourcelocation = class_7923.field_41178.method_10221((Object)((class_1792)this.instrument));
            parent.method_10582(KEY_INS_ID, resourcelocation.toString());
        }
    }

    public void method_11014(@NotNull class_2487 parent, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 levelRegistry) {
        super.method_11014(parent, levelRegistry);
        if (parent.method_10573(KEY_NOTE, 10)) {
            class_2487 sheetTag = parent.method_10562(KEY_NOTE);
            class_1799 sheet = class_1799.method_57360((class_7225.class_7874)levelRegistry, (class_2520)sheetTag).orElse(class_1799.field_8037);
            this.setSheetStack(sheet, false);
        }
        if (parent.method_10573(KEY_INS_ID, 8)) {
            this.setInstrument((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)parent.method_10558(KEY_INS_ID))));
        }
    }

    @NotNull
    public class_2487 method_16887(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        return this.method_38242(registries);
    }

    private void stopPowering() {
        class_2680 state = this.method_11010();
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)BlockMusicBox.POWERING, (Comparable)Boolean.valueOf(false)));
        }
        this.isPowering = false;
        this.poweringAge = 0;
    }

    private int beatsToTicks(int beats) {
        return Math.round((float)beats * 20.0f / (float)this.bps);
    }

    public class_1799 getSheetStack() {
        return this.sheetStack;
    }

    public void setSheetStack(class_1799 sheetStack, boolean updateClient) {
        if (sheetStack.method_7909() instanceof ItemMusicSheet) {
            if (updateClient && this.field_11863 != null && !this.field_11863.field_9236) {
                this.updateClient(sheetStack, (class_1792)this.instrument);
            }
            this.sheetStack = sheetStack;
            if (!ItemMusicSheet.isEmptySheet(sheetStack)) {
                this.bps = (Byte)sheetStack.method_57825(Items.SHEET_BPS, (Object)8);
                this.volume = ((Float)sheetStack.method_57825(Items.SHEET_VOLUME, (Object)Float.valueOf(1.0f))).floatValue();
                this.length = (Integer)sheetStack.method_57825(Items.SHEET_LENGTH, (Object)0);
            } else {
                this.notes.clear();
            }
            this.method_5431();
        }
    }

    public void removeSheetStack() {
        if (!this.sheetStack.method_7960()) {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.updateClient(class_1799.field_8037, (class_1792)this.instrument);
            }
            this.sheetStack = class_1799.field_8037;
            this.notes.clear();
            this.method_5431();
        }
    }

    public IItemInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(class_1792 instrument) {
        if (instrument instanceof IItemInstrument) {
            IItemInstrument itemInstrument = (IItemInstrument)instrument;
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.updateClient(null, instrument);
            }
            this.instrument = itemInstrument;
            this.method_5431();
        }
    }

    public void removeInstrument() {
        if (this.instrument != null) {
            if (this.field_11863 != null && !this.field_11863.field_9236) {
                this.updateClient(null, null);
            }
            this.instrument = null;
            this.method_5431();
        }
    }

    private void updateClient(class_1799 sheetStack, class_1792 itemInstrument) {
        MusicBoxUpdatePacket packet = MusicBoxUpdatePacket.create(this.field_11867, sheetStack, itemInstrument);
        for (class_3222 player : PlayerLookup.tracking((class_2586)this)) {
            Mod.sendToClient(player, packet);
        }
    }

    public class_2622 getUpdatePacket() {
        if (this.firstBlockUpdate) {
            this.firstBlockUpdate = false;
            if (this.field_11863 != null && ((Boolean)this.method_11010().method_11654((class_2769)BlockMusicBox.POWERING)).booleanValue()) {
                this.stopPowering();
            }
            return class_2622.method_38585((class_2586)this);
        }
        return null;
    }

    public void method_11012() {
        if (this.soundController != null) {
            this.soundController.setStop();
        }
        super.method_11012();
    }
}

