/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.client;

import com.aizistral.nochatreports.common.NCRClient;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.config.NCRServerPreferences;
import com.aizistral.nochatreports.common.core.ServerSafetyLevel;
import com.aizistral.nochatreports.common.core.ServerSafetyState;
import com.aizistral.nochatreports.common.core.SigningMode;
import com.aizistral.nochatreports.common.gui.AdvancedImageButton;
import com.aizistral.nochatreports.common.gui.AdvancedTooltip;
import com.aizistral.nochatreports.common.gui.GUIShenanigans;
import com.aizistral.nochatreports.common.gui.SwitchableSprites;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public abstract class MixinChatScreen
extends Screen {
    private static final Identifier CHAT_STATUS_ICONS = Identifier.fromNamespaceAndPath((String)"nochatreports", (String)"textures/gui/chat_status_icons_extended.png");
    private static final Identifier ENCRYPTION_BUTTON = Identifier.fromNamespaceAndPath((String)"nochatreports", (String)"textures/gui/encryption_toggle_button.png");
    private AdvancedImageButton safetyStatusButton;
    @Shadow
    protected EditBox input;

    protected MixinChatScreen() {
        super(null);
        throw new IllegalStateException("Can't touch this");
    }

    protected void changeFocus(ComponentPath path) {
        if (GUIShenanigans.getLeaf(path).component() instanceof EditBox) {
            super.changeFocus(path);
        }
    }

    public void setFocused(GuiEventListener listener) {
        if (listener instanceof EditBox) {
            super.setFocused(listener);
        }
    }

    @Inject(method={"handleChatInput"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleChatInput(String string, boolean bl, CallbackInfo info) {
        if (NCRConfig.getServerPreferences().hasModeCurrent(SigningMode.ALWAYS) && !ServerSafetyState.allowChatSigning() && this.minecraft.getConnection().getConnection().isEncrypted() && !this.normalizeChatMessage(string).isEmpty()) {
            ServerSafetyState.updateCurrent(ServerSafetyLevel.INSECURE);
            ServerSafetyState.scheduleSigningAction(NCRClient::resendLastChatMessage);
            ServerSafetyState.setAllowChatSigning(true);
            info.cancel();
        }
    }

    @Inject(method={"normalizeChatMessage"}, at={@At(value="RETURN")}, cancellable=true)
    public void onBeforeMessage(String original, CallbackInfoReturnable<String> info) {
        String message = (String)info.getReturnValue();
        ServerSafetyState.setLastMessage(message);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void onInit(CallbackInfo info) {
        int buttonX = this.width - 23;
        if (NCRConfig.getClient().showServerSafety() && NCRConfig.getClient().enableMod()) {
            this.safetyStatusButton = new AdvancedImageButton(buttonX, this.height - 37, 20, 20, SwitchableSprites.of(GUIShenanigans.getSprites("safety_state/insecure"), GUIShenanigans.getSprites("safety_state/unintrusive"), GUIShenanigans.getSprites("safety_state/secure"), GUIShenanigans.getSprites("safety_state/realms"), GUIShenanigans.getSprites("safety_state/unknown"), GUIShenanigans.getSprites("safety_state/undefined")).setIndex(this.getSpriteSet()), btn -> {
                if (!NCRClient.areSigningKeysPresent()) {
                    return;
                }
                ServerAddress address = ServerSafetyState.getLastServer();
                if (address != null) {
                    NCRServerPreferences preferences = NCRConfig.getServerPreferences();
                    preferences.setMode(address, preferences.getModeUnresolved(address).next());
                    preferences.saveFile();
                }
            }, (Component)Component.empty(), this);
            this.safetyStatusButton.setTooltip(new AdvancedTooltip(() -> {
                MutableComponent tooltip = this.getSafetyLevel().getTooltip();
                if (ServerSafetyState.allowChatSigning()) {
                    tooltip = Component.translatable((String)"gui.nochatreports.safety_status.insecure_signing");
                } else if (ServerSafetyState.isInSingleplayer()) {
                    return tooltip;
                }
                ServerAddress address = ServerSafetyState.getLastServer();
                SigningMode mode = NCRConfig.getServerPreferences().getModeUnresolved(address);
                Object signing = "gui.nochatreports.signing_status.";
                signing = !this.minecraft.getConnection().getConnection().isEncrypted() ? (String)signing + "disabled_offline" : (ServerSafetyState.getCurrent() == ServerSafetyLevel.REALMS ? (String)signing + "allowed_realms" : (mode.resolve() == SigningMode.ALWAYS ? (ServerSafetyState.allowChatSigning() ? (String)signing + "allowed" : (String)signing + "disabled_allowance_pending") : (ServerSafetyState.allowChatSigning() ? (String)signing + "allowed_session" : (String)signing + "disabled")));
                tooltip.append("\n\n");
                tooltip.append((Component)Component.translatable((String)signing));
                if (ServerSafetyState.isOnRealms()) {
                    return tooltip;
                }
                tooltip.append("\n\n");
                tooltip.append((Component)Component.translatable((String)"gui.nochatreports.safety_status_button.controls"));
                tooltip.append("\n\n");
                tooltip.append((Component)Component.translatable((String)"gui.nochatreports.signing_mode", (Object[])new Object[]{mode.getName().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.AQUA})}));
                tooltip.append("\n");
                tooltip.append((Component)(mode == SigningMode.DEFAULT ? mode.resolve() : mode).getTooltip());
                return tooltip;
            }).setMaxWidth(250).setRenderWithoutGap(true));
            this.addRenderableWidget((GuiEventListener)this.safetyStatusButton);
            buttonX -= 25;
        }
    }

    public void tick() {
        if (this.safetyStatusButton != null) {
            this.safetyStatusButton.useSprites(this.getSpriteSet());
        }
    }

    private ServerSafetyLevel getSafetyLevel() {
        return ServerSafetyState.getCurrent();
    }

    private int getSpriteSet() {
        return this.getSpriteSet(this.getSafetyLevel());
    }

    private int getSpriteSet(ServerSafetyLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case ServerSafetyLevel.INSECURE -> 0;
            case ServerSafetyLevel.UNINTRUSIVE -> 1;
            case ServerSafetyLevel.SECURE, ServerSafetyLevel.SINGLEPLAYER -> 2;
            case ServerSafetyLevel.REALMS -> 3;
            case ServerSafetyLevel.UNKNOWN -> 4;
            case ServerSafetyLevel.UNDEFINED -> 5;
        };
    }

    @Shadow
    public abstract String normalizeChatMessage(String var1);
}

