/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.gui;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public abstract class AdaptiveWarningScreen
extends Screen {
    private final Component title;
    private final Component content;
    private final Component narration;
    @Nullable
    protected final Screen previous;
    @Nullable
    private final Component check;
    @Nullable
    protected Checkbox stopShowing = null;
    protected MultiLineLabel message = MultiLineLabel.EMPTY;

    public AdaptiveWarningScreen(Component title, Component content, @Nullable Component check, @Nullable Screen previous) {
        super(title);
        this.title = title;
        this.content = content;
        this.check = check;
        this.narration = this.title.copy().append("\n").append(this.content);
        this.previous = previous;
    }

    protected void init() {
        this.clearWidgets();
        super.init();
        this.message = MultiLineLabel.create((Font)this.font, (Component)this.content, (int)(this.width - (this.hugeGUI() ? 65 : 100)));
        int i = (this.message.getLineCount() + 1) * this.getLineHeight();
        if (this.check != null) {
            int checkY = this.hugeGUI() ? 27 : 76;
            int j = this.font.width((FormattedText)this.check);
            if (this.check != null) {
                this.stopShowing = Checkbox.builder((Component)this.check, (Font)this.font).pos(this.width / 2 - j / 2 - 8, checkY + i).build();
                this.addRenderableWidget((GuiEventListener)this.stopShowing);
            }
        }
        this.initButtons(i + (this.hugeGUI() ? 55 : 100));
    }

    protected abstract void initButtons(int var1);

    public void render(GuiGraphics graphics, int i, int j, float f) {
        super.render(graphics, i, j, f);
        this.renderTitle(graphics);
        int k = this.width / 2 - this.message.getWidth() / 2;
        this.message.render(graphics, MultiLineLabel.Align.LEFT, k, this.hugeGUI() ? 35 : 70, this.getLineHeight(), true, -1);
    }

    private void renderTitle(GuiGraphics graphics) {
        graphics.drawString(this.font, this.title, 25, this.hugeGUI() ? 15 : 30, -1);
    }

    private boolean hugeGUI() {
        return this.height <= 270;
    }

    protected int getLineHeight() {
        if (this.hugeGUI()) {
            Objects.requireNonNull(this.minecraft.font);
            return (int)(9.0 * 1.5) + 1;
        }
        Objects.requireNonNull(this.minecraft.font);
        return 9 * 2;
    }
}

