/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common;

import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.ServerDataExtension;
import com.aizistral.nochatreports.common.core.ServerSafetyLevel;
import com.aizistral.nochatreports.common.core.ServerSafetyState;
import com.aizistral.nochatreports.common.core.SigningMode;
import com.aizistral.nochatreports.common.platform.events.ClientEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;

@Environment(value=EnvType.CLIENT)
public class NCRClient {
    private static boolean signingKeysPresent = false;

    private NCRClient() {
        throw new IllegalStateException("Can't touch this");
    }

    static void setup() {
        NCRCore.LOGGER.debug("Client initialization...");
        ClientEvents.DISCONNECT.register(NCRClient::onDisconnect);
        ClientEvents.PLAY_READY.register(NCRClient::onPlayReady);
    }

    private static void onDisconnect(Minecraft client) {
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        if (NCRConfig.getCommon().enableDebugLog()) {
            NCRCore.LOGGER.info("Disconnected from server, resetting safety state!");
        }
        ServerSafetyState.reset();
    }

    private static void onPlayReady(ClientPacketListener handler, Minecraft client) {
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        client.execute(() -> {
            if (!client.isLocalServer()) {
                if (!ServerSafetyState.isOnRealms()) {
                    if (!handler.getConnection().isEncrypted()) {
                        ServerSafetyState.updateCurrent(ServerSafetyLevel.SECURE);
                    } else {
                        ServerDataExtension ext;
                        ServerData patt0$temp = client.getCurrentServer();
                        if (patt0$temp instanceof ServerDataExtension && (ext = (ServerDataExtension)patt0$temp).preventsChatReports()) {
                            ServerSafetyState.updateCurrent(ServerSafetyLevel.SECURE);
                        } else if (NCRConfig.getServerPreferences().hasMode(ServerSafetyState.getLastServer(), SigningMode.ALWAYS)) {
                            ServerSafetyState.updateCurrent(ServerSafetyLevel.INSECURE);
                            ServerSafetyState.setAllowChatSigning(true);
                        } else {
                            ServerSafetyState.updateCurrent(ServerSafetyLevel.UNKNOWN);
                        }
                    }
                }
            } else {
                ServerSafetyState.updateCurrent(ServerSafetyLevel.SINGLEPLAYER);
            }
            if (NCRConfig.getCommon().enableDebugLog()) {
                NCRCore.LOGGER.info("Successfully connected to server, safety state: {}", (Object)ServerSafetyState.getCurrent());
            }
            if (NCRConfig.getClient().demandOnServer() && !ServerSafetyState.getCurrent().isSecure()) {
                handler.getConnection().disconnect((Component)Component.translatable((String)"disconnect.nochatreports.client"));
            }
        });
    }

    public static boolean areSigningKeysPresent() {
        return signingKeysPresent;
    }

    public static void setSigningKeysPresent(boolean present) {
        signingKeysPresent = present;
    }

    public static void resendLastChatMessage() {
        ChatScreen chat;
        ChatScreen chatScr;
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        ChatScreen chatScreen = chatScr = screen instanceof ChatScreen ? (chat = (ChatScreen)screen) : null;
        if (chatScr == null) {
            chatScr = new ChatScreen("", false);
            chatScr.init(mc, mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight());
        }
        chatScr.handleChatInput(ServerSafetyState.getLastMessage(), false);
    }
}

