/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.client;

import com.aizistral.nochatreports.common.NCRClient;
import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.ServerSafetyLevel;
import com.aizistral.nochatreports.common.core.ServerSafetyState;
import com.aizistral.nochatreports.common.core.SigningMode;
import com.aizistral.nochatreports.common.gui.UnsafeServerScreen;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.client.multiplayer.chat.ChatTrustLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatListener.class})
public class MixinChatListener {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    private boolean isSenderLocalPlayer(UUID uuid) {
        throw new IllegalStateException("@Shadow transformation failed. Should never happen.");
    }

    @Inject(method={"handleSystemMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleSystemMessage(Component message, boolean overlay, CallbackInfo info) {
        if (message instanceof MutableComponent) {
            TranslatableContents translatable;
            MutableComponent mutable = (MutableComponent)message;
            ComponentContents componentContents = message.getContents();
            if (componentContents instanceof TranslatableContents && (translatable = (TranslatableContents)componentContents).getKey().equals("chat.disabled.missingProfileKey")) {
                mutable.contents = new TranslatableContents("chat.nochatreports.disabled.signing_requested", null, TranslatableContents.NO_ARGS);
                if (!ServerSafetyState.isOnRealms()) {
                    ServerSafetyState.updateCurrent(ServerSafetyLevel.INSECURE);
                }
                if (UnsafeServerScreen.hideThisSession() || ServerSafetyState.allowChatSigning()) {
                    return;
                }
                if (NCRConfig.getServerPreferences().hasModeCurrent(SigningMode.ON_DEMAND)) {
                    ServerSafetyState.scheduleSigningAction(NCRClient::resendLastChatMessage);
                    ServerSafetyState.setAllowChatSigning(true);
                    if (NCRConfig.getClient().hideSigningRequestMessage()) {
                        info.cancel();
                    }
                    return;
                }
                if (NCRConfig.getServerPreferences().hasModeCurrent(SigningMode.PROMPT)) {
                    ChatScreen chat;
                    Screen screen = Minecraft.getInstance().screen;
                    ChatScreen returnScreen = screen instanceof ChatScreen ? (chat = (ChatScreen)screen) : new ChatScreen("", false);
                    UnsafeServerScreen unsafeScreen = new UnsafeServerScreen((Screen)returnScreen);
                    Minecraft.getInstance().setScreen((Screen)unsafeScreen);
                    if (NCRConfig.getClient().hideSigningRequestMessage()) {
                        info.cancel();
                    }
                }
            }
        }
    }

    @Inject(method={"evaluateTrustLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEvaluateTrustLevel(PlayerChatMessage playerChatMessage, Component component, Instant instant, CallbackInfoReturnable<ChatTrustLevel> info) {
        if (this.isSenderLocalPlayer(playerChatMessage.sender())) {
            info.setReturnValue((Object)ChatTrustLevel.SECURE);
        } else {
            ChatTrustLevel evaluate;
            if (playerChatMessage.hasSignature() && ServerSafetyState.getCurrent() == ServerSafetyLevel.SECURE) {
                ServerSafetyState.updateCurrent(ServerSafetyLevel.UNINTRUSIVE);
            }
            if ((evaluate = ChatTrustLevel.evaluate((PlayerChatMessage)playerChatMessage, (Component)component, (Instant)instant)) == ChatTrustLevel.NOT_SECURE && NCRConfig.getClient().hideInsecureMessageIndicators()) {
                info.setReturnValue((Object)ChatTrustLevel.SECURE);
            } else if (evaluate == ChatTrustLevel.MODIFIED && NCRConfig.getClient().hideModifiedMessageIndicators()) {
                info.setReturnValue((Object)ChatTrustLevel.SECURE);
            }
        }
        if (NCRConfig.getCommon().enableDebugLog()) {
            Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
            NCRCore.LOGGER.info("Received message: {}, from: {}, signature: {}", (Object)GSON.toJson((JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)RegistryAccess.EMPTY.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)playerChatMessage.decoratedContent()).getOrThrow(JsonParseException::new)), (Object)playerChatMessage.link().sender(), (Object)Base64.getEncoder().encodeToString(playerChatMessage.signature() != null ? playerChatMessage.signature().bytes() : new byte[]{}));
        }
    }
}

