/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.config.palette;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_2248;
import net.minecraft.class_3620;
import org.apache.commons.io.FilenameUtils;
import rh.maparthelper.config.palette.PaletteGenerator;
import rh.maparthelper.util.Utils;

public class PalettePresetsConfig {
    String currentPresetFile;
    public Map<String, String> presetFiles = new HashMap<String, String>();
    transient Map<String, PalettePreset> presets = new HashMap<String, PalettePreset>();

    static PalettePresetsConfig createDefaultConfig() {
        PalettePresetsConfig config = new PalettePresetsConfig();
        config.currentPresetFile = config.createNewPreset(true);
        return config;
    }

    public PalettePresetsConfig copyConfig() {
        PalettePresetsConfig clone = new PalettePresetsConfig();
        clone.currentPresetFile = this.currentPresetFile;
        clone.presetFiles = new HashMap<String, String>(this.presetFiles);
        clone.presets = new HashMap<String, PalettePreset>(this.presets);
        return clone;
    }

    public Editable getEditable() {
        return new Editable(this);
    }

    public String getCurrentPresetFilename() {
        return this.currentPresetFile;
    }

    public String getCurrentPresetName() {
        return this.presetFiles.get(this.currentPresetFile);
    }

    public Set<class_3620> getPresetColors(String filename) {
        return this.presets.get((Object)filename).colors.keySet();
    }

    public Set<class_3620> getCurrentPresetColors() {
        return this.getPresetColors(this.currentPresetFile);
    }

    public class_2248 getPresetBlockOfMapColor(String preset, class_3620 color) {
        return this.presets.get(preset).getBlockOfMapColor(color);
    }

    public class_2248 getBlockOfMapColor(class_3620 color) {
        return this.getPresetBlockOfMapColor(this.currentPresetFile, color);
    }

    void setCurrentPreset(String presetFilename) {
        if (this.presetFiles.containsKey(presetFilename)) {
            this.currentPresetFile = presetFilename;
        }
    }

    String createNewPreset(boolean createDefault) {
        String presetName = Utils.makeUniqueFilename(this.presetFiles::containsKey, "new_preset", "json", "%s_%d");
        PalettePreset preset = createDefault ? new PalettePreset(PaletteGenerator.getDefaultPreset()) : new PalettePreset();
        this.presetFiles.put(presetName, "New Preset");
        this.presets.put(presetName, preset);
        return presetName;
    }

    public static class Editable
    extends PalettePresetsConfig {
        public Editable(PalettePresetsConfig config) {
            this.currentPresetFile = config.currentPresetFile;
            this.presetFiles = new HashMap<String, String>(config.presetFiles);
            this.presets = new HashMap<String, PalettePreset>(config.presets);
        }

        @Override
        public void setCurrentPreset(String presetFilename) {
            if (this.presetFiles.containsKey(presetFilename)) {
                this.currentPresetFile = presetFilename;
            }
        }

        public PalettePreset getPreset(String presetFilename) {
            return (PalettePreset)this.presets.get(presetFilename);
        }

        public String createNewPreset() {
            return super.createNewPreset(false);
        }

        public Editable deletePreset(String filename) {
            if (this.presetFiles.size() == 1) {
                return new Editable(Editable.createDefaultConfig());
            }
            PalettePresetsConfig newConfig = this.copyConfig();
            newConfig.presetFiles.remove(filename);
            newConfig.presets.remove(filename);
            newConfig.currentPresetFile = newConfig.presetFiles.keySet().iterator().next();
            return new Editable(newConfig);
        }

        public String duplicatePreset(String filename) {
            PalettePreset preset = new PalettePreset((PalettePreset)this.presets.get(filename));
            Object newFilename = FilenameUtils.getBaseName((String)filename) + " (Copy)";
            newFilename = Utils.makeUniqueFilename(this.presetFiles::containsKey, (String)newFilename, "json", "%s_%d");
            this.presets.put(newFilename, preset);
            this.presetFiles.put(newFilename, (String)this.presetFiles.get(filename) + " (Copy)");
            return newFilename;
        }
    }

    public static class PalettePreset {
        public final Map<class_3620, class_2248> colors = new TreeMap<class_3620, class_2248>(Comparator.comparingInt(o -> o.field_16021));

        PalettePreset() {
        }

        PalettePreset(Map<class_3620, class_2248> colors) {
            this.colors.putAll(colors);
        }

        PalettePreset(PalettePreset origin) {
            this.colors.putAll(origin.colors);
        }

        class_2248 getBlockOfMapColor(class_3620 color) {
            return this.colors.get(color);
        }

        public void updateColor(class_3620 mapColor, class_2248 block) {
            this.colors.put(mapColor, block);
        }

        public void removeColor(class_3620 mapColor) {
            this.colors.remove(mapColor);
        }
    }
}

