/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion.staircases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_3620;
import rh.maparthelper.config.palette.PaletteColors;
import rh.maparthelper.conversion.staircases.IMapartStaircase;

public class Waves3DStaircase
implements IMapartStaircase {
    @Override
    public List<List<Integer>> getStaircase(int[][] colors) {
        int z;
        int height = colors.length + 1;
        int width = colors[0].length;
        int[] negativeHeights = new int[width];
        Arrays.fill(negativeHeights, 0);
        ArrayList<List<Integer>> staircase = new ArrayList<List<Integer>>();
        for (z = 0; z < height; ++z) {
            ArrayList<Integer> row = new ArrayList<Integer>(Collections.nCopies(width, 0));
            staircase.add(row);
        }
        for (int x = 0; x < width; ++x) {
            for (int z2 = height - 2; z2 >= 0; --z2) {
                if (z2 > 0 && colors[z2 - 1][x] == 0) continue;
                int y = (Integer)((List)staircase.get(z2 + 1)).get(x) + Waves3DStaircase.getHeightAlt(colors, x, z2);
                ((List)staircase.get(z2)).set(x, y);
                negativeHeights[x] = Math.min(negativeHeights[x], y);
            }
        }
        for (z = 0; z < height; ++z) {
            for (int x = 0; x < width; ++x) {
                if (z == 0 && colors[z][x] == 0) {
                    ((List)staircase.get(z)).set(x, 0);
                    continue;
                }
                ((List)staircase.get(z)).set(x, (Integer)((List)staircase.get(z)).get(x) - negativeHeights[x]);
            }
        }
        return staircase;
    }

    private static int getHeightAlt(int[][] colors, int x, int z) {
        if (z == colors.length) {
            return 0;
        }
        class_3620.class_6594 brightness = PaletteColors.getMapColorEntryByARGB(colors[z][x]).brightness();
        if (brightness == class_3620.class_6594.field_34759) {
            return 1;
        }
        if (brightness == class_3620.class_6594.field_34761) {
            return -1;
        }
        return 0;
    }
}

