/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.config.palette;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_3620;
import org.apache.commons.io.FilenameUtils;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.config.adapter.BlockTypeAdapter;
import rh.maparthelper.config.adapter.MapColorEntryAdapter;
import rh.maparthelper.config.palette.CompletePalette;
import rh.maparthelper.config.palette.PalettePresetsConfig;

public class PaletteConfigManager {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("mapart-helper");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(class_2248.class, (Object)new BlockTypeAdapter()).registerTypeAdapter(new TypeToken<Map<class_3620, class_2248>>(){}.getType(), (Object)new MapColorEntryAdapter()).create();
    public static PalettePresetsConfig presetsConfig;
    public static CompletePalette completePalette;

    public static void regenerateCompletePalette() {
        completePalette = CompletePalette.generate();
        PaletteConfigManager.saveCompletePalette();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readCompletePalette() {
        Path completePaletepath = CONFIG_PATH.resolve("complete_palette.json");
        if (!Files.exists(completePaletepath, new LinkOption[0])) {
            return false;
        }
        try (FileReader reader = new FileReader(completePaletepath.toFile());){
            completePalette = (CompletePalette)gson.fromJson((Reader)reader, CompletePalette.class);
            if (completePalette == null) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            MapartHelper.LOGGER.error("Failed to read JSON syntax \"{}\": {}", new Object[]{completePaletepath, e.getMessage(), e});
        }
        return false;
    }

    public static void updateCompletePalette() {
        boolean validPaletteFile = PaletteConfigManager.readCompletePalette();
        if (!validPaletteFile) {
            PaletteConfigManager.regenerateCompletePalette();
        }
    }

    public static void saveCompletePalette() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH.resolve("complete_palette.json").toFile());){
            gson.toJson((Object)completePalette, (Appendable)writer);
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void readPresetsConfigFile() {
        Path presetsConfigPath = CONFIG_PATH.resolve("palette_presets.json");
        if (!Files.exists(presetsConfigPath, new LinkOption[0])) {
            presetsConfig = PalettePresetsConfig.createDefaultConfig();
            PaletteConfigManager.savePresetsConfigFile();
            PaletteConfigManager.savePresetFiles();
            return;
        }
        try (FileReader reader = new FileReader(presetsConfigPath.toFile());){
            presetsConfig = (PalettePresetsConfig)gson.fromJson((Reader)reader, PalettePresetsConfig.class);
            if (presetsConfig == null) {
                presetsConfig = PalettePresetsConfig.createDefaultConfig();
                PaletteConfigManager.savePresetsConfigFile();
                PaletteConfigManager.savePresetFiles();
                return;
            }
            if (PaletteConfigManager.removeUnexist() | PaletteConfigManager.readPresetsFiles() | PaletteConfigManager.validatePresetsConfig()) {
                PaletteConfigManager.savePresetsConfigFile();
            }
        }
        catch (Exception e) {
            MapartHelper.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean removeUnexist() {
        boolean hasChanges = false;
        Path presetsPath = CONFIG_PATH.resolve("presets");
        Iterator<String> it = PaletteConfigManager.presetsConfig.presetFiles.keySet().iterator();
        while (it.hasNext()) {
            Path presetPath = presetsPath.resolve(it.next());
            if (Files.exists(presetPath, new LinkOption[0])) continue;
            it.remove();
            hasChanges = true;
        }
        return hasChanges;
    }

    private static boolean validatePresetsConfig() {
        boolean hasChanges = false;
        if (PaletteConfigManager.presetsConfig.presetFiles.isEmpty()) {
            PaletteConfigManager.presetsConfig.currentPresetFile = presetsConfig.createNewPreset(true);
            PaletteConfigManager.savePresetFiles();
            hasChanges = true;
        } else if (!PaletteConfigManager.presetsConfig.presetFiles.containsKey(PaletteConfigManager.presetsConfig.currentPresetFile)) {
            PaletteConfigManager.presetsConfig.currentPresetFile = PaletteConfigManager.presetsConfig.presetFiles.keySet().iterator().next();
            hasChanges = true;
        }
        return hasChanges;
    }

    public static void savePresetsConfigFile() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH.resolve("palette_presets.json").toFile());){
            gson.toJson((Object)presetsConfig, (Appendable)writer);
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean readPresetsFiles() {
        boolean hasChanges = false;
        Path presetsPath = CONFIG_PATH.resolve("presets");
        if (!Files.exists(presetsPath, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(presetsPath, "*.json");){
            for (Path path : stream) {
                try (FileReader reader = new FileReader(path.toFile());){
                    PalettePresetsConfig.PalettePreset preset = (PalettePresetsConfig.PalettePreset)gson.fromJson((Reader)reader, PalettePresetsConfig.PalettePreset.class);
                    if (preset == null || preset.colors == null || preset.colors.isEmpty()) {
                        MapartHelper.LOGGER.info("JSON file \"{}\" is not a preset or empty, ignoring", (Object)path);
                        continue;
                    }
                    String filename = path.getFileName().toString();
                    if (PaletteConfigManager.presetsConfig.presetFiles.containsKey(filename)) {
                        PaletteConfigManager.presetsConfig.presets.put(filename, preset);
                    } else {
                        PaletteConfigManager.presetsConfig.presetFiles.put(filename, FilenameUtils.getBaseName((String)filename));
                        PaletteConfigManager.presetsConfig.presets.put(filename, preset);
                        hasChanges = true;
                    }
                    MapartHelper.LOGGER.info("Preset file \"{}\" successfully read", (Object)path);
                }
                catch (JsonSyntaxException e) {
                    MapartHelper.LOGGER.error("Failed to read JSON syntax \"{}\": {}", (Object)path, (Object)e.getMessage());
                    PaletteConfigManager.presetsConfig.presetFiles.remove(path.getFileName().toString());
                }
                catch (IOException e) {
                    MapartHelper.LOGGER.error("Failed to read preset \"{}\"", (Object)path, (Object)e);
                    PaletteConfigManager.presetsConfig.presetFiles.remove(path.getFileName().toString());
                }
            }
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error("Failed to read presets directory", (Throwable)e);
        }
        return hasChanges;
    }

    private static void savePresetFiles() {
        try {
            Path presetsPath = CONFIG_PATH.resolve("presets");
            if (!Files.exists(presetsPath, new LinkOption[0])) {
                Files.createDirectory(presetsPath, new FileAttribute[0]);
            }
            for (Map.Entry<String, String> entry : PaletteConfigManager.presetsConfig.presetFiles.entrySet()) {
                try (FileWriter writer = new FileWriter(presetsPath.resolve(entry.getKey()).toFile());){
                    PalettePresetsConfig.PalettePreset preset = PaletteConfigManager.presetsConfig.presets.get(entry.getKey());
                    gson.toJson((Object)preset, (Appendable)writer);
                }
                catch (IOException e) {
                    MapartHelper.LOGGER.error("Failed to write preset \"{}\"", (Object)entry.getKey(), (Object)e);
                }
            }
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error("Failed to write presets directory", (Throwable)e);
        }
    }

    public static void savePresetFile(String filename) {
        Path presetsPath = CONFIG_PATH.resolve("presets");
        try (FileWriter writer = new FileWriter(presetsPath.resolve(filename).toFile());){
            PalettePresetsConfig.PalettePreset preset = PaletteConfigManager.presetsConfig.presets.get(filename);
            gson.toJson((Object)preset, (Appendable)writer);
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error("Failed to save preset \"{}\"", (Object)filename, (Object)e);
        }
    }

    public static void deletePresetFile(String filename) {
        try {
            Path presetsPath = CONFIG_PATH.resolve("presets");
            Files.delete(presetsPath.resolve(filename));
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error("Failed to delete preset \"{}\"", (Object)filename, (Object)e);
        }
    }

    public static void changeCurrentPreset(String name) {
        presetsConfig.setCurrentPreset(name);
        PaletteConfigManager.savePresetsConfigFile();
    }
}

