/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.gui;

import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3620;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.command.FakeMapsPreview;
import rh.maparthelper.config.ConversionConfiguration;
import rh.maparthelper.config.MapartHelperConfig;
import rh.maparthelper.config.UseAuxBlocks;
import rh.maparthelper.config.palette.PaletteConfigManager;
import rh.maparthelper.config.palette.PalettePresetsConfig;
import rh.maparthelper.conversion.CroppingMode;
import rh.maparthelper.conversion.CurrentConversionSettings;
import rh.maparthelper.conversion.MapartImageConverter;
import rh.maparthelper.conversion.dithering.DitheringAlgorithms;
import rh.maparthelper.conversion.schematic.MapartToNBT;
import rh.maparthelper.conversion.schematic.NbtSchematicUtils;
import rh.maparthelper.conversion.staircases.StaircaseStyles;
import rh.maparthelper.gui.PresetsEditorScreen;
import rh.maparthelper.gui.ScreenAdapted;
import rh.maparthelper.gui.widget.BlockItemWidget;
import rh.maparthelper.gui.widget.DropdownMenuWidget;
import rh.maparthelper.gui.widget.EnumDropdownMenuWidget;
import rh.maparthelper.gui.widget.ImageAdjustmentSliderWidget;
import rh.maparthelper.gui.widget.MapartPreviewWidget;
import rh.maparthelper.gui.widget.PresetsDropdownMenuWidget;
import rh.maparthelper.gui.widget.ScrollableGridWidget;

@Environment(value=EnvType.CLIENT)
public class MapartEditorScreen
extends ScreenAdapted {
    class_8667 settingsLeft;
    class_8667 settingsRight;
    ScrollableGridWidget materialList;
    MapartPreviewWidget mapartPreview;
    private final int baseElementWidth = 165;
    private int auxBlockCount = 0;

    public MapartEditorScreen() {
        super((class_2561)class_2561.method_43471((String)"maparthelper.gui.mapart_editor_screen"));
    }

    public void updateMaterialList() {
        this.method_37066((class_364)this.materialList);
        if (CurrentConversionSettings.imagePath == null) {
            return;
        }
        int listTop = this.settingsRight.method_46427() + this.settingsRight.method_25364();
        this.materialList = new ScrollableGridWidget(null, this.settingsRight.method_46426() - 6, listTop, this.field_22789 - this.settingsRight.method_46426() - 1, this.field_22790 - listTop, listTop, this.field_22790, 6);
        this.materialList.setLeftScroll(true);
        this.materialList.grid.method_48635(0);
        this.materialList.grid.method_46458().method_46474();
        class_7845.class_7939 materialListAdder = this.materialList.grid.method_47610(2);
        PalettePresetsConfig palette = PaletteConfigManager.presetsConfig;
        MapartImageConverter.MapColorCount[] colorsCounter = MapartImageConverter.getColorsCounter();
        this.auxBlockCount = CurrentConversionSettings.getWidth() * 128;
        BlockItemWidget auxBlockItemWidget = new BlockItemWidget(this, 0, 0, 24, 24, MapartHelper.config.conversionSettings.auxBlock);
        auxBlockItemWidget.insertToTooltip(1, (class_2561)class_2561.method_43471((String)"maparthelper.aux_block").method_27692(class_124.field_1080));
        class_7842 auxAmountText = new class_7842((class_2561)class_2561.method_43473(), this.field_22793);
        materialListAdder.method_47615((class_8021)auxBlockItemWidget, this.materialList.grid.method_46457().method_46469(6));
        materialListAdder.method_47612((class_8021)auxAmountText);
        for (MapartImageConverter.MapColorCount colorCount : colorsCounter) {
            this.addBlockToMaterialList(materialListAdder, palette, colorCount);
        }
        class_2561 amountText = class_2561.method_30163((String)this.getAmountString(this.auxBlockCount, auxBlockItemWidget.getStackSize()));
        auxAmountText.method_25358(this.field_22793.method_27525((class_5348)amountText));
        auxAmountText.method_25355(amountText);
        auxAmountText.method_47400(class_7919.method_47407((class_2561)amountText));
        this.materialList.method_48222();
        this.method_37063(this.materialList);
    }

    private void addBlockToMaterialList(class_7845.class_7939 adder, PalettePresetsConfig palette, MapartImageConverter.MapColorCount color) {
        if (color.amount() == 0) {
            return;
        }
        class_2248 block = palette.getBlockOfMapColor(class_3620.method_38479((int)color.id()));
        if (block == null) {
            return;
        }
        BlockItemWidget blockItemWidget = new BlockItemWidget(this, 0, 0, 24, 24, block);
        adder.method_47615((class_8021)blockItemWidget, this.materialList.grid.method_46457().method_46469(6));
        class_7842 amountText = new class_7842(class_2561.method_30163((String)this.getAmountString(color.amount(), block.method_8389().method_7882())), this.field_22793);
        adder.method_47612((class_8021)amountText);
        amountText.method_47400(class_7919.method_47407((class_2561)amountText.method_25369()));
        amountText.method_47402(Duration.ofMillis(100L));
        if (NbtSchematicUtils.needsAuxBlock(block)) {
            this.auxBlockCount += color.amount();
        }
    }

    private String getAmountString(int amount, int stackSize) {
        boolean counted;
        StringBuilder text = new StringBuilder();
        int shBoxSize = 27 * stackSize;
        int shBoxes = amount / shBoxSize;
        int stacks = amount % shBoxSize / stackSize;
        int items = amount % shBoxSize % stackSize;
        boolean bl = counted = shBoxes > 0 || stacks > 0;
        if (shBoxes > 0) {
            text.append(shBoxes).append("\u00a73").append(class_2561.method_43471((String)"maparthelper.gui.shulker_box_abbr").getString()).append("\u00a7r");
        }
        if (stacks > 0) {
            text.append(shBoxes > 0 ? " + " : "").append(stacks);
            if (stackSize > 1) {
                text.append("\u00a73x").append(stackSize).append("\u00a7r");
            }
        }
        if (counted) {
            text.insert(0, " = ");
            if (items > 0) {
                text.append(" + ").append(items);
            }
        }
        return text.insert(0, "" + amount).toString();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.settingsLeft = class_8667.method_52741();
        this.settingsLeft.method_48229(5, 20);
        class_7847 settingLeftPositioner = this.settingsLeft.method_52740().method_46471(5);
        class_342 mapartName = this.createTextInputFieldWidget(165, CurrentConversionSettings.mapartName, -1);
        mapartName.method_1863(value -> {
            mapartName.method_1868(-1);
            if (value.isEmpty()) {
                mapartName.method_1887(class_2561.method_43471((String)"maparthelper.gui.mapart_name_field").getString());
                return;
            }
            mapartName.method_1887(null);
            if (value.matches(".*[<>:\"/|?*\\\\].*")) {
                mapartName.method_1868(-2142128);
                return;
            }
            CurrentConversionSettings.mapartName = value;
        });
        this.settingsLeft.method_52736((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"maparthelper.gui.mapart_name_field"), this.field_22793));
        this.settingsLeft.method_52737((class_8021)mapartName, settingLeftPositioner.method_46478().method_46471(0));
        class_7845 size = this.createSizeSettingsGrid();
        this.settingsLeft.method_52736((class_8021)size);
        EnumDropdownMenuWidget croppingMode = new EnumDropdownMenuWidget(this, 0, 0, 165, 20, 165, (class_2561)class_2561.method_43471((String)"maparthelper.gui.cropMode"), (class_2561)class_2561.method_43471((String)("maparthelper.gui.option." + CurrentConversionSettings.cropMode.name())));
        croppingMode.addEntries(e -> {
            CurrentConversionSettings.cropMode = (CroppingMode)((Object)e);
            MapartImageConverter.updateMapart();
        }, CroppingMode.values());
        croppingMode.forEachEntry(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.settingsLeft.method_52736((class_8021)croppingMode);
        EnumDropdownMenuWidget staircaseStyle = new EnumDropdownMenuWidget(this, 0, 0, 165, 20, 165, (class_2561)class_2561.method_43471((String)"maparthelper.gui.staircaseStyle"), (class_2561)class_2561.method_43471((String)("maparthelper.gui.option." + MapartHelper.config.conversionSettings.staircaseStyle.name())));
        staircaseStyle.addEntries(e -> {
            ConversionConfiguration config = MapartHelper.config.conversionSettings;
            boolean was3D = config.use3D();
            config.staircaseStyle = (StaircaseStyles)((Object)e);
            if (config.use3D() != was3D) {
                MapartImageConverter.updateMapart();
            }
            AutoConfig.getConfigHolder(MapartHelperConfig.class).save();
        }, StaircaseStyles.values());
        staircaseStyle.forEachEntry(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.settingsLeft.method_52736((class_8021)staircaseStyle);
        EnumDropdownMenuWidget ditheringAlg = new EnumDropdownMenuWidget(this, 0, 0, 165, 20, 165, (class_2561)class_2561.method_43471((String)"maparthelper.gui.ditheringAlg"), (class_2561)class_2561.method_43471((String)("maparthelper.gui.option." + MapartHelper.config.conversionSettings.ditheringAlgorithm.name())));
        ditheringAlg.addEntries(e -> {
            MapartHelper.config.conversionSettings.ditheringAlgorithm = (DitheringAlgorithms)((Object)e);
            MapartImageConverter.updateMapart();
            AutoConfig.getConfigHolder(MapartHelperConfig.class).save();
        }, DitheringAlgorithms.values());
        ditheringAlg.forEachEntry(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.settingsLeft.method_52736((class_8021)ditheringAlg);
        class_5250 isOn = class_2561.method_43471((String)"maparthelper.gui.isOn");
        class_5250 isOff = class_2561.method_43471((String)"maparthelper.gui.isOff");
        class_4185 useLAB = class_4185.method_46430((class_2561)class_2561.method_43470((String)"LAB: ").method_10852((class_2561)(MapartHelper.config.conversionSettings.useLAB ? isOn : isOff)), arg_0 -> MapartEditorScreen.lambda$init$7((class_2561)isOn, (class_2561)isOff, arg_0)).method_46437(80, 20).method_46431();
        if (MapartHelper.config.commonConfiguration.showUseLABTooltip) {
            useLAB.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"maparthelper.gui.useLAB_tooltip")));
            useLAB.method_47402(Duration.ofMillis(500L));
        }
        this.settingsLeft.method_52736((class_8021)useLAB);
        DropdownMenuWidget imagePreprocessing = this.createImagePreprocessingDropdown();
        imagePreprocessing.forEachEntry(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.settingsLeft.method_52736((class_8021)imagePreprocessing);
        this.settingsLeft.method_52737((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"maparthelper.aux_block"), this.field_22793), settingLeftPositioner.method_46478().method_46471(15));
        String currentAuxBlock = class_7923.field_41175.method_10221((Object)MapartHelper.config.conversionSettings.auxBlock).toString();
        currentAuxBlock = currentAuxBlock.substring(currentAuxBlock.indexOf("minecraft:") + 10);
        class_342 auxBlockId = this.createTextInputFieldWidget(165, currentAuxBlock, -1);
        auxBlockId.method_1863(s -> {
            auxBlockId.method_1868(-1);
            int delimiterInd = s.indexOf(58);
            if (delimiterInd != -1 && !class_2960.method_20209((String)s.substring(0, delimiterInd)) || !class_2960.method_20208((String)s.substring(delimiterInd + 1))) {
                auxBlockId.method_1868(-2142128);
                return;
            }
            if (s.equals(class_7923.field_41175.method_10221((Object)MapartHelper.config.conversionSettings.auxBlock).toString())) {
                return;
            }
            class_2960 id = class_2960.method_60654((String)s);
            class_2248 newBlock = (class_2248)class_7923.field_41175.method_63535(id);
            if (newBlock != class_2246.field_10124 && !NbtSchematicUtils.needsAuxBlock(newBlock)) {
                MapartHelper.config.conversionSettings.auxBlock = newBlock;
                this.updateMaterialList();
                AutoConfig.getConfigHolder(MapartHelperConfig.class).save();
            } else {
                auxBlockId.method_1868(-2142128);
            }
        });
        this.settingsLeft.method_52736((class_8021)auxBlockId);
        EnumDropdownMenuWidget useAuxBlocks = new EnumDropdownMenuWidget(this, 0, 0, 165, 20, 165, (class_2561)class_2561.method_43471((String)"maparthelper.gui.use_aux"), (class_2561)class_2561.method_43471((String)("maparthelper.gui.option." + String.valueOf((Object)MapartHelper.config.conversionSettings.useAuxBlocks))));
        useAuxBlocks.addEntries(e -> {
            UseAuxBlocks was = MapartHelper.config.conversionSettings.useAuxBlocks;
            MapartHelper.config.conversionSettings.useAuxBlocks = (UseAuxBlocks)((Object)e);
            if (was != MapartHelper.config.conversionSettings.useAuxBlocks) {
                this.updateMaterialList();
                AutoConfig.getConfigHolder(MapartHelperConfig.class).save();
            }
        }, UseAuxBlocks.values());
        useAuxBlocks.forEachEntry(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.settingsLeft.method_52736((class_8021)useAuxBlocks);
        this.settingsLeft.method_48222();
        this.settingsLeft.method_48206(this::method_37063);
        this.settingsRight = class_8667.method_52741();
        class_7847 settingsRightPositioner = this.settingsRight.method_52740().method_46471(5);
        PresetsDropdownMenuWidget presetsList = new PresetsDropdownMenuWidget(this, 0, 0, 165, 20, 165, class_2561.method_30163((String)("\"" + PaletteConfigManager.presetsConfig.getCurrentPresetName() + "\"")), true);
        presetsList.addEntries(s -> {
            PaletteConfigManager.changeCurrentPreset(s);
            MapartImageConverter.updateMapart();
        }, PaletteConfigManager.presetsConfig.presetFiles);
        this.settingsRight.method_52736((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"maparthelper.gui.current_preset_label"), this.field_22793));
        presetsList.forEachEntry(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.settingsRight.method_52737((class_8021)presetsList, settingsRightPositioner.method_46478().method_46471(0));
        class_4185 presetsEditor = class_4185.method_46430((class_2561)class_2561.method_43471((String)"maparthelper.gui.presets_editor_screen"), btn -> class_310.method_1551().method_1507((class_437)new PresetsEditorScreen(this, 45, 30, 45, 30))).method_46437(165, 20).method_46431();
        this.settingsRight.method_52736((class_8021)presetsEditor);
        this.settingsRight.method_52737((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"maparthelper.gui.material_list_label"), this.field_22793), settingsRightPositioner.method_46478().method_46471(15));
        this.settingsRight.method_48222();
        this.settingsRight.method_48229(this.field_22789 - this.settingsRight.method_25368() - 5, 20);
        this.settingsRight.method_48206(this::method_37063);
        this.updateMaterialList();
        this.mapartPreview = new MapartPreviewWidget(this.settingsLeft.method_46426() + this.settingsLeft.method_25368() + 15, 33, this.settingsRight.method_46426() - 15, this.field_22790 - 20);
        this.method_37063(this.mapartPreview);
        class_8667 mapartOptions = class_8667.method_52742().method_52735(2);
        mapartOptions.method_48229(this.mapartPreview.method_46426(), 10);
        mapartOptions.method_52736((class_8021)this.createSaveMapartDropdown());
        class_4185 showGridButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"#"), btn -> {
            CurrentConversionSettings.doShowGrid = !CurrentConversionSettings.doShowGrid;
        }).method_46437(20, 20).method_46431();
        showGridButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"maparthelper.gui.showGrid_tooltip")));
        mapartOptions.method_52736((class_8021)showGridButton);
        class_4185 showInWorldButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\ud83c\udf0d"), btn -> {
            if (this.field_22787 == null || this.field_22787.field_1724 == null) {
                return;
            }
            if (FakeMapsPreview.createFakeFramesFromMapart(this.field_22787.field_1724)) {
                FakeMapsPreview.showFakeFrames(this.field_22787.field_1724, CurrentConversionSettings.getWidth(), CurrentConversionSettings.getHeight());
                this.method_25419();
            }
        }).method_46437(20, 20).method_46431();
        showInWorldButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"maparthelper.gui.showInWorld_tooltip")));
        mapartOptions.method_52736((class_8021)showInWorldButton);
        mapartOptions.method_48222();
        mapartOptions.method_48206(this::method_37063);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.settingsLeft.method_46426() + this.settingsLeft.method_25368() + 7, this.field_22790, 0x77000000);
        context.method_25294(this.settingsRight.method_46426() - 7, 0, this.field_22789, this.field_22790, 0x77000000);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (CurrentConversionSettings.cropMode == CroppingMode.USER_CROP) {
            return this.mapartPreview.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (CurrentConversionSettings.cropMode == CroppingMode.USER_CROP) {
            return this.mapartPreview.method_16803(keyCode, scanCode, modifiers);
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.method_19355(mouseX, mouseY).orElse(null) == this.mapartPreview) {
            this.mapartPreview.method_16014(mouseX, mouseY);
        }
        super.method_16014(mouseX, mouseY);
    }

    public void method_29638(List<Path> paths) {
        CurrentConversionSettings.resetMapart();
        CurrentConversionSettings.imagePath = paths.getFirst();
        MapartImageConverter.readAndUpdateMapartImage(CurrentConversionSettings.imagePath);
    }

    private class_342 createTextInputFieldWidget(int width, String initialValue, int maxLength) {
        class_342 textInputField = new class_342(this.field_22793, width, 20, (class_2561)class_2561.method_43473());
        if (maxLength != -1) {
            textInputField.method_1880(maxLength);
        }
        textInputField.method_1852(initialValue);
        return textInputField;
    }

    private class_7845 createSizeSettingsGrid() {
        class_7845 size = new class_7845().method_48637(10).method_48636(1);
        class_7845.class_7939 adder = size.method_47610(2);
        class_342 widthInput = this.createTextInputFieldWidget(30, "" + CurrentConversionSettings.getWidth(), 3);
        widthInput.method_1863(value -> {
            widthInput.method_1868(-1);
            if (value.isEmpty()) {
                widthInput.method_1887("x");
                return;
            }
            widthInput.method_1887(null);
            try {
                if (CurrentConversionSettings.setWidth(Integer.parseInt(value))) {
                    MapartImageConverter.updateMapart();
                }
            }
            catch (NumberFormatException e) {
                widthInput.method_1868(-2142128);
            }
        });
        class_342 heightInput = this.createTextInputFieldWidget(30, "" + CurrentConversionSettings.getHeight(), 3);
        heightInput.method_1863(value -> {
            heightInput.method_1868(-1);
            if (value.isEmpty()) {
                heightInput.method_1887("y");
                return;
            }
            heightInput.method_1887(null);
            try {
                if (CurrentConversionSettings.setHeight(Integer.parseInt(value))) {
                    MapartImageConverter.updateMapart();
                }
            }
            catch (NumberFormatException e) {
                heightInput.method_1868(-2142128);
            }
        });
        adder.method_47613((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"maparthelper.gui.mapart_size_label"), this.field_22793), 2);
        adder.method_47612((class_8021)widthInput);
        adder.method_47612((class_8021)heightInput);
        return size;
    }

    private ImageAdjustmentSliderWidget createBrightnessSlider() {
        class_5250 brightness = class_2561.method_43471((String)"maparthelper.gui.brightness");
        return new ImageAdjustmentSliderWidget(165, 15, 0.0f, 2.0f, true, CurrentConversionSettings.brightness, value -> {
            CurrentConversionSettings.brightness = value.floatValue();
            MapartImageConverter.updateMapart();
        }, arg_0 -> MapartEditorScreen.lambda$createBrightnessSlider$20((class_2561)brightness, arg_0));
    }

    private ImageAdjustmentSliderWidget createContrastSlider() {
        class_5250 contrast = class_2561.method_43471((String)"maparthelper.gui.contrast");
        return new ImageAdjustmentSliderWidget(165, 15, -255.0f, 255.0f, false, CurrentConversionSettings.contrast, value -> {
            CurrentConversionSettings.contrast = value.floatValue();
            MapartImageConverter.updateMapart();
        }, arg_0 -> MapartEditorScreen.lambda$createContrastSlider$22((class_2561)contrast, arg_0));
    }

    private ImageAdjustmentSliderWidget createSaturationSlider() {
        class_5250 saturation = class_2561.method_43471((String)"maparthelper.gui.saturation");
        return new ImageAdjustmentSliderWidget(165, 15, 0.0f, 2.0f, true, CurrentConversionSettings.saturation, value -> {
            CurrentConversionSettings.saturation = value.floatValue();
            MapartImageConverter.updateMapart();
        }, arg_0 -> MapartEditorScreen.lambda$createSaturationSlider$24((class_2561)saturation, arg_0));
    }

    private DropdownMenuWidget createImagePreprocessingDropdown() {
        ImageAdjustmentSliderWidget sliderBrightness = this.createBrightnessSlider();
        ImageAdjustmentSliderWidget sliderContrast = this.createContrastSlider();
        ImageAdjustmentSliderWidget sliderSaturation = this.createSaturationSlider();
        class_4185 reset = class_4185.method_46430((class_2561)class_2561.method_43471((String)"maparthelper.gui.reset"), btn -> {
            CurrentConversionSettings.brightness = 1.0f;
            CurrentConversionSettings.contrast = 0.0f;
            CurrentConversionSettings.saturation = 1.0f;
            sliderBrightness.setValue(0.5);
            sliderContrast.setValue(0.5);
            sliderSaturation.setValue(0.5);
        }).method_46437(80, 20).method_46431();
        DropdownMenuWidget imagePreprocessing = new DropdownMenuWidget(this, 0, 0, 100, 20, 169, (class_2561)class_2561.method_43471((String)"maparthelper.gui.image_preprocessing"));
        imagePreprocessing.addEntry((class_339)reset);
        imagePreprocessing.addEntry((class_339)sliderBrightness);
        imagePreprocessing.addEntry((class_339)sliderContrast);
        imagePreprocessing.addEntry((class_339)sliderSaturation);
        return imagePreprocessing;
    }

    private DropdownMenuWidget createSaveMapartDropdown() {
        class_4185 saveImage = class_4185.method_46430((class_2561)class_2561.method_43471((String)"maparthelper.gui.savePNG"), btn -> MapartImageConverter.saveMapartImage(CurrentConversionSettings.mapartName)).method_46437(156, 20).method_46431();
        class_4185 saveNBT = class_4185.method_46430((class_2561)class_2561.method_43471((String)"maparthelper.gui.saveNBT"), btn -> MapartToNBT.saveNBT(true)).method_46437(156, 20).method_46431();
        class_4185 saveSplitNBT = class_4185.method_46430((class_2561)class_2561.method_43471((String)"maparthelper.gui.saveEveryNBT"), btn -> MapartToNBT.saveNBT(false)).method_46437(156, 20).method_46431();
        class_4185 saveZipNBT = class_4185.method_46430((class_2561)class_2561.method_43471((String)"maparthelper.gui.saveZip"), btn -> MapartToNBT.saveNBTAsZip()).method_46437(156, 20).method_46431();
        DropdownMenuWidget saveMapart = new DropdownMenuWidget(this, 0, 0, 20, 20, 160, class_2561.method_30163((String)"\ud83d\uddab"));
        saveMapart.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"maparthelper.gui.save_mapart_as")));
        saveMapart.addEntry((class_339)saveImage);
        saveMapart.addEntry((class_339)saveNBT);
        saveMapart.addEntry((class_339)saveSplitNBT);
        saveMapart.addEntry((class_339)saveZipNBT);
        return saveMapart;
    }

    private static /* synthetic */ String lambda$createSaturationSlider$24(class_2561 saturation, Double value) {
        return String.format(saturation.getString() + ": %.2f", value);
    }

    private static /* synthetic */ String lambda$createContrastSlider$22(class_2561 contrast, Double value) {
        return String.format(contrast.getString() + ": %.0f", value);
    }

    private static /* synthetic */ String lambda$createBrightnessSlider$20(class_2561 brightness, Double value) {
        return String.format(brightness.getString() + ": %.2f", value);
    }

    private static /* synthetic */ void lambda$init$7(class_2561 isOn, class_2561 isOff, class_4185 btn) {
        MapartHelper.config.conversionSettings.useLAB = !MapartHelper.config.conversionSettings.useLAB;
        btn.method_25355((class_2561)class_2561.method_43470((String)"LAB: ").method_10852(MapartHelper.config.conversionSettings.useLAB ? isOn : isOff));
        MapartImageConverter.updateMapart();
    }
}

