/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion;

import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import rh.maparthelper.conversion.CroppingMode;
import rh.maparthelper.conversion.MapartImageConverter;

@Environment(value=EnvType.CLIENT)
public class CurrentConversionSettings {
    public static Path imagePath;
    public static class_1043 guiMapartImage;
    public static class_2960 guiMapartId;
    public static String mapartName;
    private static int width;
    private static int height;
    public static CroppingMode cropMode;
    public static int croppingFrameX;
    public static int croppingFrameY;
    public static int croppingFrameWidth;
    public static int croppingFrameHeight;
    public static boolean doShowGrid;
    public static double previewScale;
    public static float brightness;
    public static float contrast;
    public static float saturation;

    public static void resetMapart() {
        imagePath = null;
        guiMapartImage = null;
        MapartImageConverter.lastImagePath = null;
        MapartImageConverter.lastImage = null;
        previewScale = 1.0;
    }

    public static int getWidth() {
        return width;
    }

    public static boolean setWidth(int newWidth) {
        if (width == newWidth) {
            return false;
        }
        width = newWidth;
        guiMapartImage = null;
        if (MapartImageConverter.lastImage != null) {
            CurrentConversionSettings.centerCroppingSize(MapartImageConverter.lastImage.getWidth(), MapartImageConverter.lastImage.getHeight());
        }
        return true;
    }

    public static int getHeight() {
        return height;
    }

    public static boolean setHeight(int newHeight) {
        if (height == newHeight) {
            return false;
        }
        height = newHeight;
        guiMapartImage = null;
        if (MapartImageConverter.lastImage != null) {
            CurrentConversionSettings.centerCroppingSize(MapartImageConverter.lastImage.getWidth(), MapartImageConverter.lastImage.getHeight());
        }
        return true;
    }

    public static void centerCroppingSize(int imageWidth, int imageHeight) {
        int frameX;
        int frameWidth;
        int frameY;
        int frameHeight;
        double imageAspect = (double)imageWidth / (double)imageHeight;
        double mapartAspect = (double)width / (double)height;
        if (imageAspect > mapartAspect) {
            frameHeight = imageHeight;
            frameY = 0;
            frameWidth = (int)((double)frameHeight * mapartAspect);
            frameX = (imageWidth - frameWidth) / 2;
        } else {
            frameWidth = imageWidth;
            frameX = 0;
            frameHeight = (int)((double)frameWidth / mapartAspect);
            frameY = (imageHeight - frameHeight) / 2;
        }
        croppingFrameX = frameX;
        croppingFrameY = frameY;
        croppingFrameWidth = frameWidth;
        croppingFrameHeight = frameHeight;
    }

    static {
        guiMapartId = class_2960.method_60655((String)"mapart-helper", (String)"mapart_gui_texture");
        mapartName = "New mapart";
        width = 1;
        height = 1;
        cropMode = CroppingMode.AUTO_CROP;
        croppingFrameX = 0;
        croppingFrameY = 0;
        croppingFrameWidth = 1;
        croppingFrameHeight = 1;
        doShowGrid = false;
        previewScale = 1.0;
        brightness = 1.0f;
        contrast = 0.0f;
        saturation = 1.0f;
    }
}

