/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3620;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.config.palette.PaletteColors;
import rh.maparthelper.conversion.CroppingMode;
import rh.maparthelper.conversion.CurrentConversionSettings;
import rh.maparthelper.conversion.NativeImageUtils;
import rh.maparthelper.conversion.colors.ColorUtils;
import rh.maparthelper.conversion.colors.MapColorEntry;
import rh.maparthelper.conversion.dithering.DitheringAlgorithms;
import rh.maparthelper.gui.MapartEditorScreen;
import rh.maparthelper.util.Utils;

@Environment(value=EnvType.CLIENT)
public class MapartImageConverter {
    public static BufferedImage lastImage;
    public static Path lastImagePath;
    private static final ColorsCounter colorsCounter;
    private static volatile AtomicDouble conversionProgress;
    private static final Path SAVED_MAPS_DIR;
    private static final ExecutorService convertingExecutor;
    private static Future<?> currentConvertingFuture;

    public static void readAndUpdateMapartImage(Path path) {
        boolean logExecutionTime = MapartHelper.commonConfig.logConversionTime;
        FutureTask<Object> future = path.equals(lastImagePath) ? new FutureTask<Object>(new ConvertImageFileRunnable(null, logExecutionTime), null) : new FutureTask<Object>(new ConvertImageFileRunnable(path, logExecutionTime), null);
        if (currentConvertingFuture != null) {
            currentConvertingFuture.cancel(true);
        }
        currentConvertingFuture = convertingExecutor.submit(future);
    }

    public static void updateMapart() {
        if (CurrentConversionSettings.imagePath != null) {
            MapartImageConverter.readAndUpdateMapartImage(CurrentConversionSettings.imagePath);
        }
    }

    public static MapColorCount[] getColorsCounter() {
        MapColorCount[] countsSorted = new MapColorCount[63];
        for (int id = 1; id < 64; ++id) {
            countsSorted[id - 1] = new MapColorCount(id, colorsCounter.get(id));
        }
        Arrays.sort(countsSorted, Comparator.comparingInt(MapColorCount::amount).reversed());
        return countsSorted;
    }

    public static boolean isConverting() {
        double d = conversionProgress.get();
        return d > 0.0 && d < 1.0;
    }

    public static double getConversionProgress() {
        return conversionProgress.get();
    }

    private static BufferedImage preprocessImage(BufferedImage image) {
        float brightness = CurrentConversionSettings.brightness;
        float contrast = CurrentConversionSettings.contrast;
        float saturation = CurrentConversionSettings.saturation;
        return ColorUtils.preprocessImage(image, brightness, contrast, saturation);
    }

    private static boolean saveMapartImage(Path imagePath) {
        try {
            class_1043 mapartTexture = CurrentConversionSettings.guiMapartImage;
            if (mapartTexture == null || mapartTexture.method_4525() == null) {
                return false;
            }
            mapartTexture.method_4525().method_4314(imagePath);
        }
        catch (InvalidPathException e) {
            MapartHelper.LOGGER.error("Invalid path for saving the map:\n{}", (Object)e.toString());
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            MapartHelper.LOGGER.error("Error occurred while saving the image to \"{}\"", (Object)imagePath, (Object)e);
            throw new RuntimeException(e);
        }
        return true;
    }

    public static void saveMapartImage(String filename, class_1657 player) {
        try {
            filename = Utils.makeUniqueFilename(SAVED_MAPS_DIR, filename, "png");
            Path filepath = SAVED_MAPS_DIR.resolve(filename);
            if (MapartImageConverter.saveMapartImage(filepath) && player != null) {
                class_5250 mapartFile = class_2561.method_43470((String)filename).method_27694(style -> style.method_10977(class_124.field_1060).method_10958((class_2558)new class_2558.class_10607(filepath.toFile())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"maparthelper.open_image_file"))).method_30938(Boolean.valueOf(true)));
                player.method_7353((class_2561)class_2561.method_43469((String)"maparthelper.mapart_saved", (Object[])new Object[]{mapartFile}).method_27692(class_124.field_1060), false);
            }
        }
        catch (InvalidPathException e) {
            player.method_7353((class_2561)class_2561.method_43471((String)"maparthelper.saving_path_error").method_27692(class_124.field_1061), false);
            MapartHelper.LOGGER.error("Invalid path for saving the map:\n{}", (Object)e.toString());
        }
        catch (Exception e) {
            player.method_7353((class_2561)class_2561.method_43471((String)"maparthelper.saving_error").method_27692(class_124.field_1061), false);
        }
    }

    public static void convertToBlocksPalette(BufferedImage image, boolean use3D, boolean logExecutionTime) {
        boolean useDithering;
        long startTime = System.currentTimeMillis();
        PaletteColors.clearColorCache();
        colorsCounter.clear();
        int width = image.getWidth();
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        double progressStep = 1.0 / (double)pixels.length;
        int[] errorsArray = new int[]{};
        DitheringAlgorithms ditherAlg = MapartHelper.conversionSettings.ditheringAlgorithm;
        boolean bl = useDithering = ditherAlg != DitheringAlgorithms.NONE;
        if (useDithering) {
            errorsArray = new int[ditherAlg.rowsNumber * width * 3];
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < width; ++x) {
                if (Thread.currentThread().isInterrupted()) {
                    PaletteColors.clearColorCache();
                    colorsCounter.clear();
                    return;
                }
                int argb = pixels[x + y * width];
                if (argb == 0) continue;
                if (useDithering) {
                    int ind = x * 3;
                    int[] argb0 = ColorUtils.getARGB(argb);
                    argb0[1] = Math.clamp((long)(argb0[1] + errorsArray[ind]), 0, 255);
                    argb0[2] = Math.clamp((long)(argb0[2] + errorsArray[ind + 1]), 0, 255);
                    argb0[3] = Math.clamp((long)(argb0[3] + errorsArray[ind + 2]), 0, 255);
                    argb = ColorUtils.getARGB(argb0);
                }
                MapColorEntry color = PaletteColors.getClosestColor(argb, use3D, useDithering);
                if (useDithering) {
                    ditherAlg.spreadDiffusionError(errorsArray, width, x, color.distError());
                }
                int newArgb = y > 0 && pixels[x + (y - 1) * width] == 0 ? color.mapColor().method_15820(class_3620.class_6594.field_34761) : color.mapColor().method_15820(color.brightness());
                pixels[x + y * width] = newArgb;
                if (color != MapColorEntry.CLEAR) {
                    colorsCounter.increment(color.mapColor().field_16021);
                }
                conversionProgress.addAndGet(progressStep);
            }
            if (!useDithering) continue;
            for (int row = 1; row < ditherAlg.rowsNumber; ++row) {
                System.arraycopy(errorsArray, row * width * 3, errorsArray, (row - 1) * width * 3, width * 3);
            }
            Arrays.fill(errorsArray, (ditherAlg.rowsNumber - 1) * width * 3, ditherAlg.rowsNumber * width * 3, 0);
        }
        if (logExecutionTime) {
            double timeLeft = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            MapartHelper.LOGGER.info("[{}] Colors conversion took {} seconds", (Object)(use3D ? "3D" : "2D"), (Object)timeLeft);
        }
        conversionProgress.set(1.0);
        PaletteColors.clearColorCache();
    }

    public static BufferedImage scaleImage(BufferedImage image, int width, int height) {
        boolean scaleUp;
        boolean bl = scaleUp = width > image.getWidth() || height > image.getHeight();
        if (scaleUp) {
            BufferedImage resized = new BufferedImage(width, height, 2);
            Graphics2D g2 = resized.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(image, 0, 0, width, height, null);
            g2.dispose();
            return resized;
        }
        Image scaled = image.getScaledInstance(width, height, 4);
        image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.drawImage(scaled, 0, 0, null);
        g2d.dispose();
        return image;
    }

    public static BufferedImage cropAndScaleImage(BufferedImage image, int frameX, int frameY, int frameWidth, int frameHeight, int mapartWidth, int mapartHeight) {
        BufferedImage subimage = image.getSubimage(frameX, frameY, frameWidth, frameHeight);
        return MapartImageConverter.scaleImage(subimage, mapartWidth, mapartHeight);
    }

    public static BufferedImage autoCropAndScale(BufferedImage image, int mapartWidth, int mapartHeight) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        CurrentConversionSettings.centerCroppingSize(imageWidth, imageHeight);
        int frameX = CurrentConversionSettings.croppingFrameX;
        int frameY = CurrentConversionSettings.croppingFrameY;
        int frameWidth = CurrentConversionSettings.croppingFrameWidth;
        int frameHeight = CurrentConversionSettings.croppingFrameHeight;
        return MapartImageConverter.cropAndScaleImage(image, frameX, frameY, frameWidth, frameHeight, mapartWidth, mapartHeight);
    }

    private static BufferedImage cropAndScaleToMapSize(BufferedImage image) {
        int mapartWidth = CurrentConversionSettings.getWidth() * 128;
        int mapartHeight = CurrentConversionSettings.getHeight() * 128;
        return switch (CurrentConversionSettings.cropMode) {
            default -> throw new MatchException(null, null);
            case CroppingMode.NO_CROP -> MapartImageConverter.scaleImage(image, mapartWidth, mapartHeight);
            case CroppingMode.AUTO_CROP -> MapartImageConverter.autoCropAndScale(image, mapartWidth, mapartHeight);
            case CroppingMode.USER_CROP -> {
                int frameX = CurrentConversionSettings.croppingFrameX;
                int frameY = CurrentConversionSettings.croppingFrameY;
                int frameWidth = CurrentConversionSettings.croppingFrameWidth;
                int frameHeight = CurrentConversionSettings.croppingFrameHeight;
                yield MapartImageConverter.cropAndScaleImage(image, frameX, frameY, frameWidth, frameHeight, mapartWidth, mapartHeight);
            }
        };
    }

    static {
        colorsCounter = new ColorsCounter();
        conversionProgress = new AtomicDouble(0.0);
        SAVED_MAPS_DIR = FabricLoader.getInstance().getGameDir().resolve("saved_maps");
        convertingExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Mart Helper Image").build());
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConvertImageFileRunnable
    implements Runnable {
        private final Path imagePath;
        private final boolean logExecutionTime;

        public ConvertImageFileRunnable(Path path, boolean logExecutionTime) {
            this.imagePath = path;
            this.logExecutionTime = logExecutionTime;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                conversionProgress = new AtomicDouble(0.0);
                if (this.imagePath != null) {
                    lastImagePath = null;
                    BufferedImage readImage = ImageIO.read(this.imagePath.toFile());
                    CurrentConversionSettings.centerCroppingSize(readImage.getWidth(), readImage.getHeight());
                    lastImage = readImage;
                    lastImagePath = this.imagePath;
                }
                BufferedImage bufferedImage = lastImage;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                bufferedImage = MapartImageConverter.cropAndScaleToMapSize(bufferedImage);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                bufferedImage = MapartImageConverter.preprocessImage(bufferedImage);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                MapartImageConverter.convertToBlocksPalette(bufferedImage, MapartHelper.conversionSettings.use3D(), this.logExecutionTime);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                class_1011 image = NativeImageUtils.convertBufferedImageToNativeImage(bufferedImage);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                class_310.method_1551().execute(() -> NativeImageUtils.updateMapartImageTexture(image));
                if (this.logExecutionTime) {
                    double timeLeft = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                    MapartHelper.LOGGER.info("Image preprocessing and conversion took {} seconds", (Object)timeLeft);
                }
            }
            catch (Exception e) {
                CurrentConversionSettings.imagePath = null;
                MapartHelper.LOGGER.error("Error occurred while reading and converting an image: ", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                class_310.method_1551().execute(() -> {
                    class_437 patt0$temp = class_310.method_1551().field_1755;
                    if (patt0$temp instanceof MapartEditorScreen) {
                        MapartEditorScreen editorScreen = (MapartEditorScreen)patt0$temp;
                        editorScreen.updateMaterialList();
                    }
                });
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record MapColorCount(int id, int amount) {
    }

    @Environment(value=EnvType.CLIENT)
    private static class ColorsCounter {
        private int[] counter = new int[63];

        private ColorsCounter() {
        }

        void increment(int colorId) {
            int n = colorId - 1;
            this.counter[n] = this.counter[n] + 1;
        }

        int get(int colorId) {
            return this.counter[colorId - 1];
        }

        void clear() {
            this.counter = new int[63];
        }
    }
}

