/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;

public class Utils {
    public static String makeUniqueFilename(Predicate<String> existingTest, String filename, String ext, String nameFormat) {
        if (existingTest.test(filename + "." + ext)) {
            int suffix = 1;
            while (existingTest.test(String.format(nameFormat, filename, suffix) + "." + ext)) {
                ++suffix;
            }
            return String.format(nameFormat, filename, suffix) + "." + ext;
        }
        return filename + "." + ext;
    }

    public static String makeUniqueFilename(Path dir, String filename, String ext, String nameFormat) {
        return Utils.makeUniqueFilename((String f) -> Files.exists(dir.resolve((String)f), new LinkOption[0]), filename, ext, nameFormat);
    }

    public static String makeUniqueFilename(Path dir, String filename, String ext) {
        return Utils.makeUniqueFilename(dir, filename, ext, "%s (%d)");
    }
}

