/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.config.palette;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3620;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.config.palette.PaletteConfigManager;
import rh.maparthelper.conversion.colors.ColorUtils;
import rh.maparthelper.conversion.colors.MapColorEntry;

public class PaletteColors {
    static final Map<Integer, MapColorEntry> argbMapColors = new HashMap<Integer, MapColorEntry>();
    static final Map<Integer, MapColorEntry> cachedClosestColors = new HashMap<Integer, MapColorEntry>();

    public static MapColorEntry getMapColorEntryByARGB(int argb) {
        if (argb == 0) {
            return MapColorEntry.CLEAR;
        }
        return argbMapColors.get(argb);
    }

    private static MapColorEntry getClosestColor3D(int argb, boolean useDithering) {
        class_3620 closestColor = class_3620.field_16008;
        class_3620.class_6594 closeBrightness = class_3620.class_6594.field_34760;
        double minDist = 2.147483647E9;
        int[] rgbOriginal = new int[]{};
        int[] rgbClosest = new int[]{};
        if (useDithering) {
            rgbOriginal = ColorUtils.getRGB(argb);
        }
        block0: for (class_3620 color : PaletteConfigManager.presetsConfig.getCurrentPresetColors()) {
            for (int brightId = 0; brightId < 3; ++brightId) {
                class_3620.class_6594 brightness = color == class_3620.field_16019 ? class_3620.class_6594.field_34760 : class_3620.class_6594.method_38484((int)brightId);
                int current = color.method_15820(brightness);
                if (current == argb) {
                    return new MapColorEntry(color, brightness, new int[]{0, 0, 0});
                }
                double dist = ColorUtils.colorDistance(argb, current, MapartHelper.conversionSettings.useLAB);
                if (dist < minDist) {
                    minDist = dist;
                    closestColor = color;
                    closeBrightness = brightness;
                    if (useDithering) {
                        rgbClosest = ColorUtils.getRGB(current);
                    }
                }
                if (color == class_3620.field_16019) continue block0;
            }
        }
        if (useDithering) {
            int[] distError = new int[]{rgbOriginal[0] - rgbClosest[0], rgbOriginal[1] - rgbClosest[1], rgbOriginal[2] - rgbClosest[2]};
            return new MapColorEntry(closestColor, closeBrightness, distError);
        }
        return new MapColorEntry(closestColor, closeBrightness);
    }

    private static MapColorEntry getClosestColor2D(int argb, boolean useDithering) {
        class_3620 closest = class_3620.field_16008;
        double minDist = 2.147483647E9;
        int[] rgbOriginal = new int[]{};
        int[] rgbClosest = new int[]{};
        if (useDithering) {
            rgbOriginal = ColorUtils.getRGB(argb);
        }
        for (class_3620 color : PaletteConfigManager.presetsConfig.getCurrentPresetColors()) {
            int current = color.method_15820(class_3620.class_6594.field_34760);
            if (current == argb) {
                return new MapColorEntry(color, class_3620.class_6594.field_34760, new int[]{0, 0, 0});
            }
            double dist = ColorUtils.colorDistance(argb, current, MapartHelper.conversionSettings.useLAB);
            if (!(dist < minDist)) continue;
            minDist = dist;
            closest = color;
            if (!useDithering) continue;
            rgbClosest = ColorUtils.getRGB(current);
        }
        if (useDithering) {
            int[] distError = new int[]{rgbOriginal[0] - rgbClosest[0], rgbOriginal[1] - rgbClosest[1], rgbOriginal[2] - rgbClosest[2]};
            return new MapColorEntry(closest, class_3620.class_6594.field_34760, distError);
        }
        return new MapColorEntry(closest, class_3620.class_6594.field_34760);
    }

    public static MapColorEntry getClosestColor(int argb, boolean use3D, boolean useDithering) {
        if ((argb >> 24 & 0xFF) < 80) {
            return MapColorEntry.CLEAR;
        }
        if (use3D) {
            return cachedClosestColors.computeIfAbsent(argb, c -> PaletteColors.getClosestColor3D(c, useDithering));
        }
        return cachedClosestColors.computeIfAbsent(argb, c -> PaletteColors.getClosestColor2D(c, useDithering));
    }

    public static void clearColorCache() {
        cachedClosestColors.clear();
        ColorUtils.clearRgb2LabCache();
    }
}

