/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class Utils {
    @NotNull
    public static String makeUniqueName(@NotNull Predicate<String> existingTest, String filename, String ext, String nameFormat) {
        Object suf;
        Object object = suf = ext == null ? "" : "." + ext;
        if (existingTest.test(filename + (String)suf)) {
            int suffix = 1;
            while (existingTest.test(String.format(nameFormat, filename, suffix) + (String)suf)) {
                ++suffix;
            }
            return String.format(nameFormat, filename, suffix) + (String)suf;
        }
        return filename + (String)suf;
    }

    @NotNull
    public static String makeUniqueFilename(Path dir, String filename, String ext, String nameFormat) {
        return Utils.makeUniqueName(f -> Files.exists(dir.resolve((String)f), new LinkOption[0]), filename, ext, nameFormat);
    }

    @NotNull
    public static String makeUniqueFilename(Path dir, String filename, String ext) {
        return Utils.makeUniqueFilename(dir, filename, ext, "%s (%d)");
    }
}

