/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.HashMap;
import java.util.Map;

public class ColorUtils {
    private static final Map<Integer, int[]> rgb2LabCache = new HashMap<Integer, int[]>();

    public static void clearRgb2LabCache() {
        rgb2LabCache.clear();
    }

    public static int[] rgb2lab(int argb) {
        double r = argb >> 16 & 0xFF;
        double g = argb >> 8 & 0xFF;
        double b = argb & 0xFF;
        r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : r / 12.92;
        g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : g / 12.92;
        b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : b / 12.92;
        double[] XYZ = new double[]{0.4360747 * r + 0.3850649 * g + 0.1430804 * b, 0.2225045 * r + 0.7168786 * g + 0.0606169 * b, 0.0139322 * r + 0.0971045 * g + 0.7141733 * b};
        XYZ[0] = XYZ[0] / 0.96422;
        XYZ[2] = XYZ[2] / 0.82521;
        double[] fVals = new double[3];
        for (int i = 0; i < 3; ++i) {
            double val = XYZ[i];
            double f = val > 0.008856451679035631 ? Math.pow(val, 0.3333333333333333) : (903.2962962962963 * val + 16.0) / 116.0;
            fVals[i] = f;
        }
        int[] lab = new int[]{(int)(2.55 * (116.0 * fVals[1] - 16.0)), 128 + (int)(500.0 * (fVals[0] - fVals[1])), 128 + (int)(200.0 * (fVals[1] - fVals[2]))};
        return lab;
    }

    public static double colorDistanceARGB_noSqrt(int argb1, int argb2) {
        int[] rgb1 = ColorUtils.getRGB(argb1);
        int[] rgb2 = ColorUtils.getRGB(argb2);
        int dr = rgb2[0] - rgb1[0];
        int dg = rgb2[1] - rgb1[1];
        int db = rgb2[2] - rgb1[2];
        return dr * dr + dg * dg + db * db;
    }

    public static double colorDistanceLAB_noSqrt(int[] lab1, int[] lab2) {
        int L1 = lab1[0];
        int a1 = lab1[1];
        int b1 = lab1[2];
        int L2 = lab2[0];
        int a2 = lab2[1];
        int b2 = lab2[2];
        int dL = L2 - L1;
        int da = a2 - a1;
        int db = b2 - b1;
        return dL * dL + da * da + db * db;
    }

    public static double colorDistance(int argb1, int argb2, boolean useLAB) {
        if (useLAB) {
            int[] lab1 = rgb2LabCache.computeIfAbsent(argb1, ColorUtils::rgb2lab);
            int[] lab2 = rgb2LabCache.computeIfAbsent(argb2, ColorUtils::rgb2lab);
            return ColorUtils.colorDistanceLAB_noSqrt(lab1, lab2);
        }
        return ColorUtils.colorDistanceARGB_noSqrt(argb1, argb2);
    }

    public static BufferedImage preprocessImage(BufferedImage image, float brightnessFactor, float contrastLevel, float saturationFactor) {
        boolean neutralSaturation;
        float contrastFactor = 259.0f * (contrastLevel + 255.0f) / (255.0f * (259.0f - contrastLevel));
        boolean neutralBrightness = Float.compare(brightnessFactor, 1.0f) == 0;
        boolean neutralContrast = Float.compare(contrastFactor, 1.0f) == 0;
        boolean bl = neutralSaturation = Float.compare(saturationFactor, 1.0f) == 0;
        if (neutralBrightness && neutralContrast && neutralSaturation) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        int[] pixelsFrom = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] pixels = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        System.arraycopy(pixelsFrom, 0, pixels, 0, pixels.length);
        if (!neutralBrightness || !neutralContrast) {
            for (int pixel = 0; pixel < width * height; ++pixel) {
                int argbInt = pixels[pixel];
                if (argbInt == 0) continue;
                int[] argb = ColorUtils.getARGB(argbInt);
                if (!neutralBrightness) {
                    ColorUtils.applyBrightness(argb, brightnessFactor);
                }
                if (!neutralContrast) {
                    ColorUtils.applyContrast(argb, contrastFactor);
                }
                pixels[pixel] = ColorUtils.getARGB(argb);
            }
        }
        if (!neutralSaturation) {
            ColorUtils.applySaturation(pixels, saturationFactor);
        }
        return result;
    }

    private static void applyBrightness(int[] argb, float brightnessFactor) {
        argb[1] = Math.clamp((long)((int)((float)argb[1] * brightnessFactor)), 0, 255);
        argb[2] = Math.clamp((long)((int)((float)argb[2] * brightnessFactor)), 0, 255);
        argb[3] = Math.clamp((long)((int)((float)argb[3] * brightnessFactor)), 0, 255);
    }

    private static void applyContrast(int[] argb, float contrastFactor) {
        argb[1] = Math.clamp((long)((int)(contrastFactor * (float)(argb[1] - 128) + 128.0f)), 0, 255);
        argb[2] = Math.clamp((long)((int)(contrastFactor * (float)(argb[2] - 128) + 128.0f)), 0, 255);
        argb[3] = Math.clamp((long)((int)(contrastFactor * (float)(argb[3] - 128) + 128.0f)), 0, 255);
    }

    private static void applySaturation(int[] pixels, float saturationFactor) {
        for (int pixel = 0; pixel < pixels.length; ++pixel) {
            int argbInt = pixels[pixel];
            if ((argbInt >> 24 & 0xFF) < 80) continue;
            int[] argb = ColorUtils.getARGB(argbInt);
            float[] hsb = Color.RGBtoHSB(argb[1], argb[2], argb[3], null);
            float hue = hsb[0];
            float saturation = hsb[1];
            float brightness = hsb[2];
            saturation = Math.max(0.0f, Math.min(1.0f, saturation * saturationFactor));
            int rgb = Color.HSBtoRGB(hue, saturation, brightness);
            pixels[pixel] = argb[0] << 24 | rgb & 0xFFFFFF;
        }
    }

    public static int[] getRGB(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return new int[]{r, g, b};
    }

    public static int[] getARGB(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return new int[]{a, r, g, b};
    }

    public static int getARGB(int[] argb) {
        return argb[0] << 24 | argb[1] << 16 | argb[2] << 8 | argb[3];
    }
}

