/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import rh.maparthelper.conversion.mapart.MapartImage;
import rh.maparthelper.conversion.mapart.ProcessingMapartImage;

@Environment(value=EnvType.CLIENT)
public class MapartImageResizer {
    public static BufferedImage adjustToMapartSize(ProcessingMapartImage mapart) {
        BufferedImage image = mapart.getOriginal();
        int imageW = image.getWidth();
        int imageH = image.getHeight();
        MapartImage.CroppingFrame frame = mapart.getCroppingFrame();
        int visibleW = frame.getWidth();
        int visibleH = frame.getHeight();
        image = image.getSubimage(frame.getX(), frame.getY(), Math.min(imageW, visibleW), Math.min(imageH, visibleH));
        int mapartW = mapart.getWidth() * 128;
        int mapartH = mapart.getHeight() * 128;
        int mapartScaledW = (int)Math.min((long)mapartW, Math.round((double)mapartW * ((double)imageW / (double)visibleW)));
        int mapartScaledH = (int)Math.min((long)mapartH, Math.round((double)mapartH * ((double)imageH / (double)visibleH)));
        if (mapartScaledW > 1 && mapartScaledH > 1) {
            mapart.setScaledImage(MapartImageResizer.scaleImage(image, mapartScaledW, mapartScaledH));
            mapart.setScale(Math.min((double)mapartScaledW / (double)visibleW, (double)mapartScaledH / (double)visibleH));
        }
        return MapartImageResizer.placeOnMapartCanvas(mapart, mapartW, mapartH);
    }

    public static BufferedImage placeOnMapartCanvas(ProcessingMapartImage mapart, int mapartWidth, int mapartHeight) {
        BufferedImage mapartImage = new BufferedImage(mapartWidth, mapartHeight, 2);
        Graphics2D g2d = mapartImage.createGraphics();
        BufferedImage scaled = mapart.getScaledImage();
        g2d.drawImage((Image)scaled, mapart.getInsertionX(), mapart.getInsertionY(), null);
        g2d.dispose();
        return mapartImage;
    }

    public static BufferedImage scaleImage(ProcessingMapartImage mapart, int width, int height) {
        BufferedImage image = mapart.getOriginal();
        image = MapartImageResizer.scaleImage(image, width, height);
        mapart.setScaledImage(image);
        return image;
    }

    public static BufferedImage scaleImage(BufferedImage image, int width, int height) {
        BufferedImage scaledImage;
        boolean scaleUp;
        if (width <= 0 || height <= 0) {
            return image;
        }
        boolean bl = scaleUp = width > image.getWidth() || height > image.getHeight();
        if (scaleUp) {
            scaledImage = new BufferedImage(width, height, 2);
            Graphics2D g2 = scaledImage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(image, 0, 0, width, height, null);
            g2.dispose();
        } else {
            Image scaled = image.getScaledInstance(width, height, 4);
            scaledImage = new BufferedImage(width, height, 2);
            Graphics2D g2d = scaledImage.createGraphics();
            g2d.drawImage(scaled, 0, 0, null);
            g2d.dispose();
        }
        return scaledImage;
    }
}

