/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion.mapart;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import rh.maparthelper.conversion.mapart.ColorsCounter;

@Environment(value=EnvType.CLIENT)
public abstract class MapartImage {
    protected static final Path SAVED_MAPS_DIR = FabricLoader.getInstance().getGameDir().resolve("saved_maps");
    protected ColorsCounter colorsCounter = new ColorsCounter();
    protected class_1011 nativeImage;
    protected BufferedImage original;
    protected Path imagePath;
    public String mapartName = "New mapart";
    protected int width = 1;
    protected int height = 1;
    protected final CroppingFrame croppingFrame = new CroppingFrame();
    protected BufferedImage scaledImage;
    protected double scale = 1.0;
    protected int insertionX = 0;
    protected int insertionY = 0;

    public MapartImage() {
    }

    public MapartImage(MapartImage mapart) {
        this.colorsCounter = new ColorsCounter(mapart.colorsCounter);
        this.nativeImage = mapart.nativeImage;
        this.original = mapart.original;
        this.imagePath = mapart.imagePath;
        this.mapartName = mapart.mapartName;
        this.width = mapart.width;
        this.height = mapart.height;
        this.insertionX = mapart.insertionX;
        this.insertionY = mapart.insertionY;
        this.scaledImage = mapart.scaledImage;
        this.scale = mapart.scale;
        this.croppingFrame.x = mapart.croppingFrame.x;
        this.croppingFrame.y = mapart.croppingFrame.y;
        this.croppingFrame.width = mapart.croppingFrame.width;
        this.croppingFrame.height = mapart.croppingFrame.height;
    }

    public ColorsCounter getColorsCounter() {
        return this.colorsCounter;
    }

    public class_1011 getNativeImage() {
        return this.nativeImage;
    }

    public BufferedImage getOriginal() {
        return this.original;
    }

    public Path getImagePath() {
        return this.imagePath;
    }

    public CroppingFrame getCroppingFrame() {
        return this.croppingFrame;
    }

    public BufferedImage getScaledImage() {
        return this.scaledImage;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getInsertionX() {
        return this.insertionX;
    }

    public int getInsertionY() {
        return this.insertionY;
    }

    @Environment(value=EnvType.CLIENT)
    public class CroppingFrame {
        private int x = 0;
        private int y = 0;
        private int width = 1;
        private int height = 1;

        public int getX() {
            return this.x;
        }

        protected void setX(int x) {
            if (x < 0 || x > MapartImage.this.original.getWidth()) {
                return;
            }
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        protected void setY(int y) {
            if (y < 0 || y > MapartImage.this.original.getHeight()) {
                return;
            }
            this.y = y;
        }

        public int getWidth() {
            return this.width;
        }

        protected void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        protected void setHeight(int height) {
            this.height = height;
        }
    }
}

