/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.gui.widget;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3620;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.conversion.CroppingMode;
import rh.maparthelper.conversion.CurrentConversionSettings;
import rh.maparthelper.conversion.MapartImageConverter;
import rh.maparthelper.conversion.MapartImageUpdater;
import rh.maparthelper.conversion.mapart.ConvertedMapartImage;
import rh.maparthelper.gui.sprites.ManualCroppingSprites;
import rh.maparthelper.render.pipeline.ColorsHighlightUniform;
import rh.maparthelper.render.pipeline.CustomPipelines;
import rh.maparthelper.scheduler.DelayedRepeater;

@Environment(value=EnvType.CLIENT)
public class MapartPreviewWidget
extends class_339 {
    private final ConvertedMapartImage mapart;
    private final int maxWidth;
    private final int maxHeight;
    private final DelayedRepeater repeater = new DelayedRepeater();
    private boolean scaleToCursor = true;
    private ManualCroppingAction hoveredAction = null;
    private class_3620 highlightingColor = class_3620.field_16008;

    public MapartPreviewWidget(ConvertedMapartImage mapart, int x, int y, int maxX, int maxY) {
        super(x, y, mapart.getWidth(), mapart.getHeight(), (class_2561)class_2561.method_43473());
        this.maxWidth = maxX - 16 - x;
        this.maxHeight = maxY - y;
        this.mapart = mapart;
    }

    public void setHighlightingColor(class_3620 color) {
        if (this.highlightingColor != color) {
            this.highlightingColor = color;
            if (color == class_3620.field_16008) {
                return;
            }
            ColorsHighlightUniform.set(this.highlightingColor.method_15820(class_3620.class_6594.field_34759), this.highlightingColor.method_15820(class_3620.class_6594.field_34760), this.highlightingColor.method_15820(class_3620.class_6594.field_34761), MapartHelper.commonConfig.selectionColor);
        }
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        int x = this.getImageX();
        int y = this.method_46427();
        int mapartWidth = this.mapart.getWidth() * 128;
        int mapartHeight = this.mapart.getHeight() * 128;
        double scale = 2.0;
        this.field_22758 = (int)((double)mapartWidth * scale);
        this.field_22759 = (int)((double)mapartHeight * scale);
        if (this.field_22758 > this.maxWidth || this.field_22759 > this.maxHeight) {
            scale = Math.min((double)this.maxWidth / (double)mapartWidth, (double)this.maxHeight / (double)mapartHeight);
            this.field_22758 = (int)((double)mapartWidth * scale);
            this.field_22759 = (int)((double)mapartHeight * scale);
        }
        if (CurrentConversionSettings.guiMapartImage != null) {
            RenderPipeline pipeline = class_10799.field_56883;
            if (!MapartHelper.conversionSettings.showOriginalImage && this.highlightingColor != class_3620.field_16008) {
                pipeline = CustomPipelines.PREVIEW_COLOR_HIGHLIGHT;
                ColorsHighlightUniform.set(this.highlightingColor.method_15820(class_3620.class_6594.field_34759), this.highlightingColor.method_15820(class_3620.class_6594.field_34760), this.highlightingColor.method_15820(class_3620.class_6594.field_34761), MapartHelper.commonConfig.mapartEditor.previewHighlightingColor);
            }
            context.method_25290(pipeline, CurrentConversionSettings.guiMapartId, x, y, 0.0f, 0.0f, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
        } else if (!MapartImageConverter.isConverting()) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            class_5250 dropFileText = class_2561.method_43471((String)"maparthelper.gui.drop_here_mapart");
            int centerX = x + this.field_22758 / 2;
            List lines = textRenderer.method_1728((class_5348)dropFileText, this.field_22758 - 5);
            for (int i = 0; i < lines.size(); ++i) {
                context.method_35719(textRenderer, (class_5481)lines.get(i), centerX, y + 5 + i * 9, -11141121);
            }
        }
        if (CurrentConversionSettings.doShowGrid) {
            for (int mapX = 1; mapX < mapartWidth / 128; ++mapX) {
                int lineX = (int)((double)x + (double)(mapX * 128) * scale);
                context.method_25294(lineX, y, lineX + 1, y + this.field_22759, -11010079);
            }
            for (int mapY = 1; mapY < mapartHeight / 128; ++mapY) {
                int lineY = (int)((double)y + (double)(mapY * 128) * scale);
                context.method_25294(x, lineY, x + this.field_22758, lineY + 1, -11010079);
            }
        }
        if (MapartImageConverter.isConverting()) {
            double conversionProgress = MapartImageConverter.getConversionProgress();
            class_327 textRenderer = class_310.method_1551().field_1772;
            context.method_25294(x, y, (int)((double)x + (double)this.field_22758 * conversionProgress), this.method_55443(), 0x3000FF00);
            context.method_25300(textRenderer, (int)(conversionProgress * 100.0) + "%", x + this.field_22758 / 2, y + 14, -16711936);
        }
        if (CurrentConversionSettings.doShowManualCroppingButtons && CurrentConversionSettings.guiMapartImage != null && CurrentConversionSettings.cropMode == CroppingMode.USER_CROP) {
            this.renderManualCroppingButtons(context, mouseX, mouseY);
        } else {
            this.setHoveredAction(null);
        }
        context.method_49601(x - 1, y - 1, this.field_22758 + 2, this.field_22759 + 2, -11010079);
    }

    public int getImageX() {
        return this.method_46426() + 16;
    }

    public int method_25368() {
        return this.field_22758 + 16;
    }

    protected void method_47399(class_6382 builder) {
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.scaleImageCrop(mouseX, mouseY, verticalAmount);
    }

    private boolean scaleImageCrop(double mouseX, double mouseY, double verticalAmount) {
        if (CurrentConversionSettings.cropMode == CroppingMode.USER_CROP && CurrentConversionSettings.guiMapartImage != null) {
            if (this.scaleToCursor) {
                double pointX = (mouseX - (double)this.getImageX()) / (double)this.field_22758;
                double pointY = (mouseY - (double)this.method_46427()) / (double)this.field_22759;
                MapartImageUpdater.scaleToPoint(this.mapart, pointX, pointY, verticalAmount);
            } else {
                MapartImageUpdater.scaleToCenter(this.mapart, verticalAmount);
            }
        }
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.scaleToCursor = false;
            return true;
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.scaleToCursor = true;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (CurrentConversionSettings.cropMode != CroppingMode.USER_CROP || button != 0) {
            return false;
        }
        if (mouseX < (double)this.getImageX() || CurrentConversionSettings.doShowManualCroppingButtons && this.isMouseOverActionsArea(mouseX, mouseY)) {
            return false;
        }
        this.setHoveredAction(null);
        MapartImageUpdater.moveCroppingFrameOrMapartImage(this.mapart, deltaX, deltaY, true);
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (CurrentConversionSettings.cropMode != CroppingMode.USER_CROP) {
            return true;
        }
        if (this.hoveredAction != null && button == 0) {
            this.repeater.start(() -> this.hoveredAction.perform(this.mapart), 500L, 100L);
        }
        return true;
    }

    public void method_25357(double mouseX, double mouseY) {
        this.repeater.stop();
    }

    private boolean isMouseOverActionsArea(double mouseX, double mouseY) {
        if (!this.method_25405(mouseX, mouseY) || mouseX < (double)this.getImageX()) {
            return false;
        }
        float xCenter = (float)this.getImageX() + (float)this.field_22758 / 2.0f;
        float yCenter = (float)this.method_46427() + (float)this.field_22759 / 2.0f;
        return Math.abs((double)xCenter - mouseX) < 15.0 && Math.abs((double)yCenter - mouseY) < 15.0 || mouseX < (double)(this.getImageX() + 16) || mouseY < (double)(this.method_46427() + 16) || mouseX > (double)(this.method_55442() - 16) || mouseY > (double)(this.method_55443() - 16);
    }

    private void setHoveredAction(ManualCroppingAction action) {
        if (this.hoveredAction != action) {
            this.hoveredAction = action;
        }
    }

    private void renderSprite(class_332 context, class_2960 sprite, int x, int y, int width, int height, int alpha) {
        context.method_25291(class_10799.field_56883, sprite, x, y, 0.0f, 0.0f, width, height, width, height, alpha << 24 | 0xFFFFFF);
    }

    private void renderSprite(class_332 context, class_2960 sprite, int x, int y, int width, int height) {
        this.renderSprite(context, sprite, x, y, width, height, 255);
    }

    private void renderManualCroppingButtons(class_332 context, int mouseX, int mouseY) {
        int size = 50;
        int mLeft = mouseX - this.getImageX();
        int mTop = mouseY - this.method_46427();
        int mRight = this.method_55442() - mouseX;
        int mBottom = this.method_55443() - mouseY;
        boolean highlight = this.isMouseOverActionsArea(mouseX, mouseY);
        boolean hoveringAction = false;
        hoveringAction |= this.renderEdgeArrow(context, mLeft, mTop, this.getImageX(), this.method_46427(), ManualCroppingAction.LEFT_UP_BIG, ManualCroppingAction.LEFT_UP_SMALL, highlight, size);
        hoveringAction |= this.renderEdgeArrow(context, mRight, mTop, this.method_55442() - size, this.method_46427(), ManualCroppingAction.RIGHT_UP_BIG, ManualCroppingAction.RIGHT_UP_SMALL, highlight, size);
        hoveringAction |= this.renderEdgeArrow(context, mLeft, mBottom, this.getImageX(), this.method_55443() - size, ManualCroppingAction.LEFT_DOWN_BIG, ManualCroppingAction.LEFT_DOWN_SMALL, highlight, size);
        hoveringAction |= this.renderEdgeArrow(context, mRight, mBottom, this.method_55442() - size, this.method_55443() - size, ManualCroppingAction.RIGHT_DOWN_BIG, ManualCroppingAction.RIGHT_DOWN_SMALL, highlight, size);
        int xCenter = this.getImageX() + this.field_22758 / 2;
        int yCenter = this.method_46427() + this.field_22759 / 2;
        int xStart = xCenter - size / 2;
        int yStart = yCenter - size / 2;
        int mStartX = mouseX - xStart;
        int mStartY = mouseY - yStart;
        hoveringAction |= this.renderAxisArrow(context, mStartX, mTop, xStart, this.method_46427(), ManualCroppingAction.UP_BIG, ManualCroppingAction.UP_SMALL, highlight, size);
        hoveringAction |= this.renderAxisArrow(context, mStartY, mRight, this.method_55442() - size, yStart, ManualCroppingAction.RIGHT_BIG, ManualCroppingAction.RIGHT_SMALL, highlight, size);
        hoveringAction |= this.renderAxisArrow(context, mStartX, mBottom, xStart, this.method_55443() - size, ManualCroppingAction.DOWN_BIG, ManualCroppingAction.DOWN_SMALL, highlight, size);
        hoveringAction |= this.renderAxisArrow(context, mStartY, mLeft, this.getImageX(), yStart, ManualCroppingAction.LEFT_BIG, ManualCroppingAction.LEFT_SMALL, highlight, size);
        hoveringAction |= this.renderManualCroppingActionSprite(context, ManualCroppingAction.ZOOM_IN, this.method_46426(), this.method_46427(), 14, 14, () -> mouseX < this.getImageX() && mouseX > this.method_46426() && mouseY > this.method_46427() && mouseY < this.method_46427() + 14);
        hoveringAction |= this.renderManualCroppingActionSprite(context, ManualCroppingAction.ZOOM_OUT, this.method_46426(), this.method_46427() + 14, 14, 14, () -> mouseX < this.getImageX() && mouseX > this.method_46426() && mouseY > this.method_46427() + 14 && mouseY < this.method_46427() + 28);
        double dist = Math.sqrt((xCenter - mouseX) * (xCenter - mouseX) + (yCenter - mouseY) * (yCenter - mouseY));
        int alpha = this.method_25405(mouseX, mouseY) ? (dist < (double)this.field_22758 / 3.0 ? Math.clamp((long)((int)(255.0 / dist * 16.0)), 0, 255) : 30) : 0;
        hoveringAction |= this.renderManualCroppingActionSprite(context, ManualCroppingAction.CENTER_IMAGE, xCenter - 16, yCenter - 16, 32, 32, alpha, () -> Math.abs(xCenter - mouseX - 1) <= 8 && Math.abs(yCenter - mouseY - 1) <= 8);
        hoveringAction |= this.renderManualCroppingActionSprite(context, ManualCroppingAction.FIT_BY_WIDTH, xCenter - 16, yCenter - 16, 32, 32, alpha, () -> Math.abs(xCenter - mouseX - 1) <= 8 && mouseY > yCenter - 20 && mouseY < yCenter - 8);
        if (!(hoveringAction |= this.renderManualCroppingActionSprite(context, ManualCroppingAction.FIT_BY_HEIGHT, xCenter - 16, yCenter - 16, 32, 32, alpha, () -> Math.abs(yCenter - mouseY - 1) <= 8 && mouseX > xCenter - 20 && mouseX < xCenter - 8))) {
            this.setHoveredAction(null);
        }
    }

    private boolean renderManualCroppingActionSprite(class_332 context, ManualCroppingAction action, int x, int y, int width, int height, int alpha, Supplier<Boolean> isHovered) {
        if (isHovered.get().booleanValue()) {
            this.renderSprite(context, action.highlighted, x, y, width, height);
            this.setHoveredAction(action);
            return true;
        }
        this.renderSprite(context, action.normal, x, y, width, height, alpha);
        return false;
    }

    private boolean renderManualCroppingActionSprite(class_332 context, ManualCroppingAction action, int x, int y, int width, int height, Supplier<Boolean> isHovered) {
        return this.renderManualCroppingActionSprite(context, action, x, y, width, height, 255, isHovered);
    }

    private boolean renderEdgeArrow(class_332 context, int dx, int dy, int x, int y, ManualCroppingAction bigArrow, ManualCroppingAction smallArrow, boolean highlight, int size) {
        boolean hovering = false;
        hovering |= this.renderManualCroppingActionSprite(context, bigArrow, x, y, size, size, () -> highlight && (dx < size && dy < 7 || dx < 7 && dy < size));
        return hovering |= this.renderManualCroppingActionSprite(context, smallArrow, x, y, size, size, () -> dx > 6 && dy > 6 && (dx < 18 && dy < 39 || dx < 39 && dy < 18));
    }

    private boolean renderAxisArrow(class_332 context, int dStart, int dSide, int x, int y, ManualCroppingAction bigArrow, ManualCroppingAction smallArrow, boolean highlight, int size) {
        boolean hovering = false;
        hovering |= this.renderManualCroppingActionSprite(context, bigArrow, x, y, size, size, () -> highlight && dStart >= 0 && dStart <= size && dSide < 9);
        return hovering |= this.renderManualCroppingActionSprite(context, smallArrow, x, y, size, size, () -> dSide > 8 && dSide < 18 && dStart >= 8 && dStart <= 42);
    }

    @Environment(value=EnvType.CLIENT)
    private static enum ManualCroppingAction {
        LEFT_UP_BIG(ManualCroppingSprites.LEFT_UP_BIG_TEXTURE, ManualCroppingSprites.LEFT_UP_BIG_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, 5, 5)),
        LEFT_UP_SMALL(ManualCroppingSprites.LEFT_UP_SMALL_TEXTURE, ManualCroppingSprites.LEFT_UP_SMALL_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, 1, 1)),
        RIGHT_UP_BIG(ManualCroppingSprites.RIGHT_UP_BIG_TEXTURE, ManualCroppingSprites.RIGHT_UP_BIG_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, -5, 5)),
        RIGHT_UP_SMALL(ManualCroppingSprites.RIGHT_UP_SMALL_TEXTURE, ManualCroppingSprites.RIGHT_UP_SMALL_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, -1, 1)),
        LEFT_DOWN_BIG(ManualCroppingSprites.LEFT_DOWN_BIG_TEXTURE, ManualCroppingSprites.LEFT_DOWN_BIG_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, 5, -5)),
        LEFT_DOWN_SMALL(ManualCroppingSprites.LEFT_DOWN_SMALL_TEXTURE, ManualCroppingSprites.LEFT_DOWN_SMALL_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, 1, -1)),
        RIGHT_DOWN_BIG(ManualCroppingSprites.RIGHT_DOWN_BIG_TEXTURE, ManualCroppingSprites.RIGHT_DOWN_BIG_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, -5, -5)),
        RIGHT_DOWN_SMALL(ManualCroppingSprites.RIGHT_DOWN_SMALL_TEXTURE, ManualCroppingSprites.RIGHT_DOWN_SMALL_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, -1, -1)),
        UP_BIG(ManualCroppingSprites.UP_BIG_TEXTURE, ManualCroppingSprites.UP_BIG_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, 0, 5)),
        UP_SMALL(ManualCroppingSprites.UP_SMALL_TEXTURE, ManualCroppingSprites.UP_SMALL_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, 0, 1)),
        LEFT_BIG(ManualCroppingSprites.LEFT_BIG_TEXTURE, ManualCroppingSprites.LEFT_BIG_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, 5, 0)),
        LEFT_SMALL(ManualCroppingSprites.LEFT_SMALL_TEXTURE, ManualCroppingSprites.LEFT_SMALL_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, 1, 0)),
        RIGHT_BIG(ManualCroppingSprites.RIGHT_BIG_TEXTURE, ManualCroppingSprites.RIGHT_BIG_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, -5, 0)),
        RIGHT_SMALL(ManualCroppingSprites.RIGHT_SMALL_TEXTURE, ManualCroppingSprites.RIGHT_SMALL_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, -1, 0)),
        DOWN_BIG(ManualCroppingSprites.DOWN_BIG_TEXTURE, ManualCroppingSprites.DOWN_BIG_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, 0, -5)),
        DOWN_SMALL(ManualCroppingSprites.DOWN_SMALL_TEXTURE, ManualCroppingSprites.DOWN_SMALL_HIGHLIGHTED_TEXTURE, mapart -> ManualCroppingAction.move(mapart, 0, -1)),
        CENTER_IMAGE(ManualCroppingSprites.CENTER_IMAGE_TEXTURE, ManualCroppingSprites.CENTER_IMAGE_HIGHLIGHTED_TEXTURE, MapartImageUpdater::centerCroppingFrameAndMapartImage),
        FIT_BY_WIDTH(ManualCroppingSprites.FIT_BY_WIDTH_TEXTURE, ManualCroppingSprites.FIT_BY_WIDTH_HIGHLIGHTED_TEXTURE, mapart -> MapartImageUpdater.fitImageBySide(mapart, 0)),
        FIT_BY_HEIGHT(ManualCroppingSprites.FIT_BY_HEIGHT_TEXTURE, ManualCroppingSprites.FIT_BY_HEIGHT_HIGHLIGHTED_TEXTURE, mapart -> MapartImageUpdater.fitImageBySide(mapart, 1)),
        ZOOM_IN(ManualCroppingSprites.ZOOM_IN_TEXTURE, ManualCroppingSprites.ZOOM_IN_HIGHLIGHTED_TEXTURE, mapart -> MapartImageUpdater.scaleToCenter(mapart, 1.0)),
        ZOOM_OUT(ManualCroppingSprites.ZOOM_OUT_TEXTURE, ManualCroppingSprites.ZOOM_OUT_HIGHLIGHTED_TEXTURE, mapart -> MapartImageUpdater.scaleToCenter(mapart, -1.0));

        final class_2960 normal;
        final class_2960 highlighted;
        final Consumer<ConvertedMapartImage> action;

        private ManualCroppingAction(class_2960 normal, class_2960 highlighted, Consumer<ConvertedMapartImage> action) {
            this.normal = normal;
            this.highlighted = highlighted;
            this.action = action;
        }

        void perform(ConvertedMapartImage mapart) {
            this.action.accept(mapart);
        }

        static void move(ConvertedMapartImage mapart, int dx, int dy) {
            MapartImageUpdater.moveCroppingFrameOrMapartImage(mapart, dx, dy, false);
        }
    }
}

