/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion.mapart;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import rh.maparthelper.conversion.ImageChangeResult;
import rh.maparthelper.conversion.mapart.ConvertedMapartImage;
import rh.maparthelper.conversion.mapart.MapartImage;

@Environment(value=EnvType.CLIENT)
public class ProcessingMapartImage
extends MapartImage {
    public ProcessingMapartImage(MapartImage mapart) {
        super(mapart);
    }

    public ConvertedMapartImage release(ConvertedMapartImage mapart) {
        return mapart.update(this);
    }

    public void autoCropOriginalImage() {
        int frameX;
        int frameWidth;
        int frameY;
        int frameHeight;
        double mapartAspect;
        int imageHeight;
        int imageWidth = this.original.getWidth();
        double imageAspect = (double)imageWidth / (double)(imageHeight = this.original.getHeight());
        if (imageAspect > (mapartAspect = (double)this.width / (double)this.height)) {
            frameHeight = imageHeight;
            frameY = 0;
            frameWidth = (int)((double)frameHeight * mapartAspect);
            frameX = (imageWidth - frameWidth) / 2;
        } else {
            frameWidth = imageWidth;
            frameX = 0;
            frameHeight = (int)((double)frameWidth / mapartAspect);
            frameY = (imageHeight - frameHeight) / 2;
        }
        this.croppingFrame.setX(frameX);
        this.croppingFrame.setY(frameY);
        this.croppingFrame.setWidth(frameWidth);
        this.croppingFrame.setHeight(frameHeight);
        this.insertionX = 0;
        this.insertionY = 0;
    }

    private int fittingAxis() {
        int mapartHeight;
        int imageHeight;
        int mapartWidth;
        int imageWidth = this.original.getWidth();
        if ((double)imageWidth / (double)(mapartWidth = this.width * 128) > (double)(imageHeight = this.original.getHeight()) / (double)(mapartHeight = this.height * 128)) {
            return 0;
        }
        return 1;
    }

    public void fitOriginalCroppingFrame() {
        this.croppingFrame.setX(0);
        this.croppingFrame.setY(0);
        if (this.fittingAxis() == 0) {
            this.fitByWidth();
        } else {
            this.fitByHeight();
        }
    }

    public void fitBySide(int side) {
        if (this.fittingAxis() == side) {
            this.croppingFrame.setX(0);
            this.croppingFrame.setY(0);
            if (side == 0) {
                this.fitByWidth();
            } else {
                this.fitByHeight();
            }
        } else {
            this.autoCropOriginalImage();
        }
    }

    private void fitByWidth() {
        int imageWidth = this.original.getWidth();
        int imageHeight = this.original.getHeight();
        int mapartWidth = this.width * 128;
        int mapartHeight = this.height * 128;
        double mapartAspect = (double)this.width / (double)this.height;
        double scale = Math.min(1.0, (double)mapartWidth / (double)imageWidth);
        this.croppingFrame.setWidth(Math.max(mapartWidth, imageWidth));
        this.croppingFrame.setHeight((int)((double)this.croppingFrame.getWidth() / mapartAspect));
        this.insertionX = (int)(((double)mapartWidth - (double)imageWidth * scale) / 2.0);
        this.insertionY = (int)(((double)mapartHeight - (double)imageHeight * scale) / 2.0);
    }

    private void fitByHeight() {
        int imageWidth = this.original.getWidth();
        int imageHeight = this.original.getHeight();
        int mapartWidth = this.width * 128;
        int mapartHeight = this.height * 128;
        double mapartAspect = (double)this.width / (double)this.height;
        double scale = Math.min(1.0, (double)mapartHeight / (double)imageHeight);
        this.croppingFrame.setHeight(Math.max(mapartHeight, imageHeight));
        this.croppingFrame.setWidth((int)((double)this.croppingFrame.getHeight() * mapartAspect));
        this.insertionX = (int)(((double)mapartWidth - (double)imageWidth * scale) / 2.0);
        this.insertionY = (int)(((double)mapartHeight - (double)imageHeight * scale) / 2.0);
    }

    public void centerImage() {
        int imageWidth = this.scaledImage.getWidth();
        int imageHeight = this.scaledImage.getHeight();
        int mapartWidth = this.width * 128;
        int mapartHeight = this.height * 128;
        if (imageWidth < mapartWidth) {
            this.croppingFrame.setX(0);
            this.insertionX = (mapartWidth - imageWidth) / 2;
        } else {
            this.insertionX = 0;
            this.croppingFrame.setX((this.original.getWidth() - this.croppingFrame.getWidth()) / 2);
        }
        if (imageHeight < mapartHeight) {
            this.croppingFrame.setY(0);
            this.insertionY = (mapartHeight - imageHeight) / 2;
        } else {
            this.insertionY = 0;
            this.croppingFrame.setY((this.original.getHeight() - this.croppingFrame.getHeight()) / 2);
        }
    }

    public void scaleToCenter(double scale) {
        this.scaleToPoint(0.5, 0.5, scale);
    }

    public void scaleToPoint(double pointX, double pointY, double scale) {
        int imageWidth = this.original.getWidth();
        int imageHeight = this.original.getHeight();
        double mapartAspect = (double)this.width / (double)this.height;
        double imageAspect = (double)imageWidth / (double)imageHeight;
        int delta = (int)scale * 5;
        int minSize = Math.min(imageWidth, Math.min(imageHeight, 64));
        int cropWidth = this.croppingFrame.getWidth();
        int cropHeight = this.croppingFrame.getHeight();
        int centerX = (int)((double)this.croppingFrame.getX() + (double)cropWidth * pointX);
        int centerY = (int)((double)this.croppingFrame.getY() + (double)cropHeight * pointY);
        if (imageAspect < mapartAspect) {
            cropWidth = Math.max(cropWidth - 2 * delta, minSize);
            cropHeight = (int)Math.round((double)cropWidth / mapartAspect);
        } else {
            cropHeight = Math.max(cropHeight - 2 * delta, minSize);
            cropWidth = (int)Math.round((double)cropHeight * mapartAspect);
        }
        int mapartW = this.width * 128;
        int mapartH = this.height * 128;
        int mapartScaledW = (int)Math.min((long)mapartW, Math.round((double)mapartW * ((double)imageWidth / (double)cropWidth)));
        int mapartScaledH = (int)Math.min((long)mapartH, Math.round((double)mapartH * ((double)imageHeight / (double)cropHeight)));
        this.setInsertionX(Math.max(0, (mapartW - mapartScaledW) / 2));
        this.setInsertionY(Math.max(0, (mapartH - mapartScaledH) / 2));
        int frameX = Math.clamp((long)(centerX - (int)((double)cropWidth * pointX)), 0, Math.max(imageWidth - cropWidth, 0));
        int frameY = Math.clamp((long)(centerY - (int)((double)cropHeight * pointY)), 0, Math.max(imageHeight - cropHeight, 0));
        this.croppingFrame.setX(frameX);
        this.croppingFrame.setY(frameY);
        this.croppingFrame.setWidth(cropWidth);
        this.croppingFrame.setHeight(cropHeight);
    }

    public ImageChangeResult moveCroppingFrame(int dx, int dy, int type) {
        if (this.original == null) {
            return ImageChangeResult.SIMPLE;
        }
        ImageChangeResult imageChangeResult = ImageChangeResult.SIMPLE;
        int imageWidth = this.original.getWidth();
        int imageHeight = this.original.getHeight();
        int mapartWidth = this.width * 128;
        int mapartHeight = this.height * 128;
        if (dx != 0) {
            if (this.scaledImage.getWidth() < mapartWidth) {
                this.insertionX = Math.clamp((long)this.insertionX - (long)dx * (long)type, 0, mapartWidth - this.scaledImage.getWidth());
            } else {
                this.insertionX = 0;
                int oldCropX = this.croppingFrame.getX();
                this.croppingFrame.setX(Math.clamp((long)(oldCropX - dx), 0, imageWidth - this.croppingFrame.getWidth()));
                if (this.croppingFrame.getX() != oldCropX) {
                    imageChangeResult = ImageChangeResult.NEED_RESCALE;
                }
            }
        }
        if (dy != 0) {
            if (this.scaledImage.getHeight() < mapartHeight) {
                boolean wasTop = this.insertionY == 0;
                this.insertionY = Math.clamp((long)this.insertionY - (long)dy * (long)type, 0, mapartHeight - this.scaledImage.getHeight());
                if (wasTop != (this.insertionY == 0)) {
                    imageChangeResult = ImageChangeResult.TOP_LINE_CHANGED;
                }
            } else {
                this.insertionY = 0;
                int oldCropY = this.croppingFrame.getY();
                this.croppingFrame.setY(Math.clamp((long)(oldCropY - dy), 0, imageHeight - this.croppingFrame.getHeight()));
                if (this.croppingFrame.getY() != oldCropY) {
                    imageChangeResult = ImageChangeResult.NEED_RESCALE;
                }
            }
        }
        return imageChangeResult;
    }

    public void setNativeImage(class_1011 nativeImage) {
        this.nativeImage = nativeImage;
    }

    public void setImagePath(Path imagePath) {
        this.imagePath = imagePath;
    }

    public void setOriginal(BufferedImage image) {
        this.original = image;
    }

    public void setScaledImage(BufferedImage scaledImage) {
        this.scaledImage = scaledImage;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setInsertionX(int insertionX) {
        this.insertionX = insertionX;
    }

    public void setInsertionY(int insertionY) {
        this.insertionY = insertionY;
    }
}

